/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.engine.impl.ProductInfoProvider;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile String serverInfo = ProductInfoProvider.PRODUCT_NAME;
    private ErrorHandler delegate;

    void setServerInfo(String serverInfo) {
        this.serverInfo = serverInfo != null ? serverInfo : ProductInfoProvider.PRODUCT_NAME;
    }

    public void setDelegate(ErrorHandler eh) {
        this.delegate = eh;
    }

    public ErrorHandler getDelegate() {
        return this.delegate;
    }

    private void delegateFailed(int originalStatus, String originalMessage, Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String m = "Error handler failed:" + t.getClass().getName();
        this.log.error(m, t);
        this.sendError(originalStatus, originalMessage, null, request, response);
    }

    @Override
    public void handleError(int status, String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        if (this.delegate != null) {
            try {
                this.delegate.handleError(status, message, request, response);
            }
            catch (Exception e) {
                this.delegateFailed(status, message, e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Error r) {
                this.delegateFailed(status, message, r, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return;
        }
        message = message == null ? "HTTP ERROR:" + String.valueOf(status) : "HTTP ERROR:" + status + " - " + message;
        this.sendError(status, message, null, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    @Override
    public void handleError(Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        int status = 500;
        if (this.delegate != null) {
            try {
                this.delegate.handleError(throwable, request, response);
            }
            catch (Exception e) {
                this.delegateFailed(500, throwable.toString(), e, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            catch (Error r) {
                this.delegateFailed(500, throwable.toString(), r, (HttpServletRequest)request, (HttpServletResponse)response);
            }
            return;
        }
        this.sendError(500, throwable.getMessage(), throwable, (HttpServletRequest)request, (HttpServletResponse)response);
    }

    private void sendError(int status, String message, Throwable throwable, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (response.isCommitted()) {
            this.log.error("handleError: Response already committed; cannot send error " + status + message, throwable);
        } else {
            String servletName = (String)request.getAttribute("javax.servlet.error.servlet_name");
            String requestURI = (String)request.getAttribute("javax.servlet.error.request_uri");
            if (requestURI == null) {
                requestURI = request.getRequestURI();
            }
            response.reset();
            response.setStatus(status);
            response.setContentType("text/html; charset=UTF-8");
            PrintWriter pw = response.getWriter();
            pw.println("<html><head><title>");
            pw.println(ResponseUtil.escapeXml((String)message));
            pw.println("</title></head><body><h1>");
            if (throwable != null) {
                pw.println(ResponseUtil.escapeXml((String)throwable.toString()));
            } else if (message != null) {
                pw.println(ResponseUtil.escapeXml((String)message));
            } else {
                pw.println("Internal error (no Exception to report)");
            }
            pw.println("</h1><p>");
            pw.print("RequestURI=");
            pw.println(ResponseUtil.escapeXml((String)request.getRequestURI()));
            if (servletName != null) {
                pw.println("</p><p>Servlet=");
                pw.println(ResponseUtil.escapeXml((String)servletName));
            }
            pw.println("</p>");
            if (throwable != null) {
                PrintWriter escapingWriter = new PrintWriter(ResponseUtil.getXmlEscapingWriter((Writer)pw));
                pw.println("<h3>Exception stacktrace:</h3>");
                pw.println("<pre>");
                pw.flush();
                throwable.printStackTrace(escapingWriter);
                escapingWriter.flush();
                pw.println("</pre>");
                RequestProgressTracker tracker = ((SlingHttpServletRequest)request).getRequestProgressTracker();
                pw.println("<h3>Request Progress:</h3>");
                pw.println("<pre>");
                pw.flush();
                tracker.dump(new PrintWriter(escapingWriter));
                escapingWriter.flush();
                pw.println("</pre>");
            }
            pw.println("<hr /><address>");
            pw.println(ResponseUtil.escapeXml((String)this.serverInfo));
            pw.println("</address></body></html>");
            response.flushBuffer();
            pw.close();
        }
    }
}

