/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.filter;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.ErrorHandler;
import org.apache.sling.engine.impl.filter.AbstractSlingFilterChain;
import org.apache.sling.engine.impl.filter.FilterHandle;

public class ErrorFilterChain
extends AbstractSlingFilterChain {
    private static final String RECURSION_ATTRIBUTE = ErrorFilterChain.class.getName() + ".RECURSION";
    private static final String PREFIX_COMMITTED = "handleError: Response already committed; cannot send error ";
    private static final String PREFIX_RECURSION = "handleError: Recursive invocation. Not further handling status ";
    private final int status;
    private final String message;
    private final ErrorHandler errorHandler;
    private final Throwable throwable;
    private final Mode mode;
    private boolean firstCall = true;

    public ErrorFilterChain(FilterHandle[] filters, ErrorHandler errorHandler, int status, String message) {
        super(filters);
        this.mode = Mode.STATUS;
        this.status = status;
        this.message = message;
        this.errorHandler = errorHandler;
        this.throwable = null;
    }

    public ErrorFilterChain(FilterHandle[] filters, ErrorHandler errorHandler, Throwable t) {
        super(filters);
        this.mode = Mode.THROWABLE;
        this.status = 0;
        this.message = null;
        this.throwable = t;
        this.errorHandler = errorHandler;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this.firstCall) {
            if (request.getAttribute(RECURSION_ATTRIBUTE) != null) {
                if (this.mode == Mode.STATUS) {
                    if (this.message == null) {
                        LOG.warn(PREFIX_RECURSION.concat(String.valueOf(this.status)));
                    } else {
                        LOG.warn(PREFIX_RECURSION.concat(String.valueOf(this.status)).concat(" : ").concat(this.message));
                    }
                } else if (this.throwable.getMessage() != null) {
                    LOG.warn(PREFIX_RECURSION.concat(this.throwable.getMessage()), this.throwable);
                } else {
                    LOG.warn(PREFIX_RECURSION.concat(this.throwable.getClass().getName()), this.throwable);
                }
                return;
            }
            request.setAttribute(RECURSION_ATTRIBUTE, (Object)"true");
            this.firstCall = false;
            if (response.isCommitted()) {
                if (this.mode == Mode.STATUS) {
                    if (this.message == null) {
                        LOG.warn(PREFIX_COMMITTED.concat(String.valueOf(this.status)));
                    } else {
                        LOG.warn(PREFIX_COMMITTED.concat(String.valueOf(this.status)).concat(" : ").concat(this.message));
                    }
                } else if (this.throwable.getMessage() != null) {
                    LOG.warn(PREFIX_COMMITTED.concat(this.throwable.getMessage()), this.throwable);
                } else {
                    LOG.warn(PREFIX_COMMITTED.concat(this.throwable.getClass().getName()), this.throwable);
                }
                return;
            }
            response.reset();
        }
        super.doFilter(request, response);
    }

    @Override
    protected void render(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException, ServletException {
        if (this.mode == Mode.STATUS) {
            this.errorHandler.handleError(this.status, this.message, request, response);
        } else {
            this.errorHandler.handleError(this.throwable, request, response);
        }
    }

    private static enum Mode {
        THROWABLE,
        STATUS;

    }
}

