/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.QuerySyntaxException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.scheduler.Job;
import org.apache.sling.commons.scheduler.JobContext;
import org.apache.sling.commons.scheduler.ScheduleOptions;
import org.apache.sling.commons.scheduler.Scheduler;
import org.apache.sling.event.impl.jobs.JobBuilderImpl;
import org.apache.sling.event.impl.jobs.JobManagerImpl;
import org.apache.sling.event.impl.jobs.ScheduledJobInfoImpl;
import org.apache.sling.event.impl.jobs.config.ConfigurationChangeListener;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.apache.sling.event.impl.support.ScheduleInfoImpl;
import org.apache.sling.event.jobs.JobBuilder;
import org.apache.sling.event.jobs.ScheduleInfo;
import org.apache.sling.event.jobs.ScheduledJobInfo;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobSchedulerImpl
implements EventHandler,
ConfigurationChangeListener,
Job {
    private static final String TOPIC_READ_JOB = "org/apache/sling/event/impl/jobs/READSCHEDULEDJOB";
    private static final String PROPERTY_READ_JOB = "properties";
    private static final String PROPERTY_SCHEDULE_INDEX = "index";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean running;
    private volatile boolean active;
    private final JobManagerConfiguration configuration;
    private final Scheduler scheduler;
    private final JobManagerImpl jobManager;
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final Set<String> unloadedEvents = new HashSet<String>();
    private final Map<String, ScheduledJobInfoImpl> scheduledJobs = new HashMap<String, ScheduledJobInfoImpl>();

    public JobSchedulerImpl(JobManagerConfiguration configuration, Scheduler scheduler, JobManagerImpl jobManager) {
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.running = true;
        this.jobManager = jobManager;
        final long now = System.currentTimeMillis();
        Thread backgroundThread = new Thread(new Runnable(){

            @Override
            public void run() {
                JobSchedulerImpl.this.loadScheduledJobs(now);
                try {
                    JobSchedulerImpl.this.runInBackground();
                }
                catch (Throwable t) {
                    JobSchedulerImpl.this.logger.error("Background thread stopped with exception: " + t.getMessage(), t);
                    JobSchedulerImpl.this.running = false;
                }
            }
        });
        backgroundThread.start();
        this.configuration.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.configuration.removeListener(this);
        this.running = false;
        this.stopScheduling();
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            this.scheduledJobs.clear();
        }
        this.queue.clear();
        try {
            this.queue.put(new Event("org/apache/sling/event/notification/job/REMOVED", (Dictionary)null));
        }
        catch (InterruptedException e) {
            this.ignoreException(e);
            Thread.currentThread().interrupt();
        }
    }

    private void stopScheduling() {
        if (this.active) {
            Collection<ScheduledJobInfo> jobs = this.getScheduledJobs(null, -1L, null);
            for (ScheduledJobInfo info : jobs) {
                this.stopScheduledJob((ScheduledJobInfoImpl)info);
            }
        }
    }

    private void startScheduling() {
        if (this.active) {
            Collection<ScheduledJobInfo> jobs = this.getScheduledJobs(null, -1L, null);
            for (ScheduledJobInfo info : jobs) {
                this.startScheduledJob((ScheduledJobInfoImpl)info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void runInBackground() {
        event = null;
        while (this.running) {
            if (event == null) {
                try {
                    event = this.queue.take();
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                    this.running = false;
                }
            }
            if (event == null || !this.running) continue;
            nextEvent = null;
            if (event.getTopic().equals("org/apache/sling/event/impl/jobs/READSCHEDULEDJOB")) {
                properties = (Map)event.getProperty("properties");
                info = this.addOrUpdateScheduledJob(properties);
                if (this.active) {
                    this.startScheduledJob(info);
                }
            }
            if (event.getTopic().equals("org/apache/sling/api/resource/Resource/ADDED") || event.getTopic().equals("org/apache/sling/api/resource/Resource/CHANGED")) {
                path = (String)event.getProperty("path");
                resolver = this.configuration.createResourceResolver();
                try {
                    eventResource = resolver.getResource(path);
                    if (!"slingevent:TimedEvent".equals(eventResource.getResourceType()) || (result = this.readScheduledJob(eventResource)) == null) ** GOTO lbl50
                    if (result.hasReadErrors) {
                        var7_8 = this.unloadedEvents;
                        synchronized (var7_8) {
                            this.unloadedEvents.add(eventResource.getPath());
                        }
                    }
                    nextEvent = result.event;
                }
                finally {
                    resolver.close();
                }
            } else if (event.getTopic().equals("org/apache/sling/api/resource/Resource/REMOVED")) {
                path = (String)event.getProperty("path");
                scheduleName = ResourceUtil.getName((String)path);
                var6_7 = this.scheduledJobs;
                synchronized (var6_7) {
                    info = this.scheduledJobs.remove(scheduleName);
                }
                if (info != null && this.active) {
                    this.stopScheduledJob(info);
                }
            }
lbl50:
            // 8 sources

            event = nextEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScheduledJobInfoImpl addOrUpdateScheduledJob(Map<String, Object> properties) {
        ScheduledJobInfoImpl info;
        properties.remove("sling:resourceType");
        properties.remove("slingevent:created");
        properties.remove("slingevent:application");
        String jobTopic = (String)properties.remove("event.job.topic");
        String schedulerName = (String)properties.remove("slingevent:scheduleName");
        List scheduleInfos = (List)properties.remove("slingevent:scheduleInfo");
        boolean isSuspended = properties.remove("slingevent:scheduleSuspended") != null;
        String key = ResourceHelper.filterName(schedulerName);
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            info = this.scheduledJobs.get(key);
            if (info == null) {
                info = new ScheduledJobInfoImpl(this, jobTopic, properties, schedulerName);
                this.scheduledJobs.put(key, info);
            }
            info.update(isSuspended, scheduleInfos);
        }
        return info;
    }

    private void startScheduledJob(ScheduledJobInfoImpl info) {
        if (!info.isSuspended()) {
            this.logger.debug("Adding scheduled job: {}", (Object)info.getName());
            int index = 0;
            for (ScheduleInfo si : info.getSchedules()) {
                String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
                ScheduleOptions options = null;
                switch (si.getType()) {
                    case DAILY: 
                    case WEEKLY: 
                    case HOURLY: 
                    case MONTHLY: 
                    case YEARLY: 
                    case CRON: {
                        options = this.scheduler.EXPR(((ScheduleInfoImpl)si).getCronExpression());
                        break;
                    }
                    case DATE: {
                        options = this.scheduler.AT(((ScheduleInfoImpl)si).getNextScheduledExecution());
                    }
                }
                HashMap<String, Serializable> config = new HashMap<String, Serializable>();
                config.put(PROPERTY_READ_JOB, info);
                config.put(PROPERTY_SCHEDULE_INDEX, Integer.valueOf(index));
                this.scheduler.schedule((Object)this, options.name(name).config(config).canRunConcurrently(false));
                ++index;
            }
        }
    }

    private void stopScheduledJob(ScheduledJobInfoImpl info) {
        this.logger.debug("Stopping scheduled job : {}", (Object)info.getName());
        for (int index = 0; index < info.getSchedules().size(); ++index) {
            String name = info.getSchedulerJobId() + "-" + String.valueOf(index);
            this.scheduler.unschedule(name);
        }
    }

    public void execute(JobContext context) {
        ScheduledJobInfoImpl info = (ScheduledJobInfoImpl)context.getConfiguration().get(PROPERTY_READ_JOB);
        this.jobManager.addJob(info.getJobTopic(), info.getJobProperties());
        int index = (Integer)context.getConfiguration().get(PROPERTY_SCHEDULE_INDEX);
        Iterator<ScheduleInfo> iter = info.getSchedules().iterator();
        ScheduleInfo si = iter.next();
        for (int i = 0; i < index; ++i) {
            si = iter.next();
        }
        if (si.getType() == ScheduleInfo.ScheduleType.DATE) {
            if (index == 0 && info.getSchedules().size() == 1) {
                this.unschedule(info);
            } else {
                ArrayList<ScheduleInfoImpl> infos = new ArrayList<ScheduleInfoImpl>();
                for (ScheduleInfo i : info.getSchedules()) {
                    if (i == si) continue;
                    infos.add((ScheduleInfoImpl)i);
                }
                try {
                    this.writeJob(info.getJobTopic(), null, info.getJobProperties(), info.getName(), info.isSuspended(), infos);
                }
                catch (PersistenceException pe) {
                    this.logger.warn("Unable to update scheduled job", (Throwable)pe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unschedule(ScheduledJobInfoImpl info) {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            StringBuilder sb = new StringBuilder(this.configuration.getScheduledJobsPath(true));
            sb.append(ResourceHelper.filterName(info.getName()));
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                resolver.delete(eventResource);
                resolver.commit();
            }
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            resolver.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (this.running) {
            if ("org/osgi/framework/BundleEvent/STARTED".equals(event.getTopic()) || "org/osgi/framework/BundleEvent/UPDATED".equals(event.getTopic())) {
                boolean doIt = false;
                Set<String> set = this.unloadedEvents;
                synchronized (set) {
                    if (this.unloadedEvents.size() > 0) {
                        doIt = true;
                    }
                }
                if (doIt) {
                    Runnable t = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Set set = JobSchedulerImpl.this.unloadedEvents;
                            synchronized (set) {
                                ResourceResolver resolver = JobSchedulerImpl.this.configuration.createResourceResolver();
                                HashSet<String> newUnloadedEvents = new HashSet<String>();
                                newUnloadedEvents.addAll(JobSchedulerImpl.this.unloadedEvents);
                                try {
                                    for (String path : JobSchedulerImpl.this.unloadedEvents) {
                                        newUnloadedEvents.remove(path);
                                        Resource eventResource = resolver.getResource(path);
                                        ReadResult result = JobSchedulerImpl.this.readScheduledJob(eventResource);
                                        if (result == null) continue;
                                        if (result.hasReadErrors) {
                                            newUnloadedEvents.add(path);
                                            continue;
                                        }
                                        try {
                                            JobSchedulerImpl.this.queue.put(result.event);
                                        }
                                        catch (InterruptedException e) {
                                            JobSchedulerImpl.this.ignoreException(e);
                                            Thread.currentThread().interrupt();
                                        }
                                    }
                                }
                                finally {
                                    resolver.close();
                                    JobSchedulerImpl.this.unloadedEvents.clear();
                                    JobSchedulerImpl.this.unloadedEvents.addAll(newUnloadedEvents);
                                }
                            }
                        }
                    };
                    Environment.THREAD_POOL.execute(t);
                }
            } else {
                String path = (String)event.getProperty("path");
                String resourceType = (String)event.getProperty("resourceType");
                if (path != null && path.startsWith(this.configuration.getScheduledJobsPath(true)) && (resourceType == null || "slingevent:TimedEvent".equals(resourceType))) {
                    this.logger.debug("Received resource event for {} : {}", (Object)path, (Object)resourceType);
                    try {
                        this.queue.put(event);
                    }
                    catch (InterruptedException ignore) {
                        this.ignoreException(ignore);
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadScheduledJobs(long startTime) {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            Calendar startDate = Calendar.getInstance();
            startDate.setTimeInMillis(startTime);
            StringBuilder buf = new StringBuilder(64);
            buf.append("//element(*,");
            buf.append("slingevent:TimedEvent");
            buf.append(")[@");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" < xs:dateTime('");
            buf.append(ISO8601.format(startDate));
            buf.append("')] order by @");
            buf.append(ISO9075.encode("slingevent:created"));
            buf.append(" ascending");
            Iterator result = resolver.findResources(buf.toString(), "xpath");
            while (result.hasNext()) {
                ReadResult readResult;
                Resource eventResource = (Resource)result.next();
                if (!eventResource.getPath().startsWith(this.configuration.getScheduledJobsPath(true)) || (readResult = this.readScheduledJob(eventResource)) == null) continue;
                if (readResult.hasReadErrors) {
                    Set<String> set = this.unloadedEvents;
                    synchronized (set) {
                        this.unloadedEvents.add(eventResource.getPath());
                        continue;
                    }
                }
                try {
                    this.queue.put(readResult.event);
                }
                catch (InterruptedException e) {
                    this.ignoreException(e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        catch (QuerySyntaxException qse) {
            this.ignoreException((Exception)((Object)qse));
        }
        finally {
            resolver.close();
        }
    }

    private ReadResult readScheduledJob(Resource eventResource) {
        if (eventResource != null) {
            try {
                ValueMap vm = ResourceHelper.getValueMap(eventResource);
                Map<String, Object> properties = ResourceHelper.cloneValueMap(vm);
                ReadResult result = new ReadResult();
                List readErrorList = (List)properties.remove(ResourceHelper.PROPERTY_MARKER_READ_ERROR_LIST);
                boolean bl = result.hasReadErrors = readErrorList != null;
                if (readErrorList != null) {
                    for (Exception e : readErrorList) {
                        this.logger.warn("Unable to read scheduled job from " + eventResource.getPath(), (Throwable)e);
                    }
                }
                Map<String, Map<String, Object>> eventProps = Collections.singletonMap(PROPERTY_READ_JOB, properties);
                result.event = new Event(TOPIC_READ_JOB, eventProps);
                return result;
            }
            catch (InstantiationException ie) {
                this.ignoreException(ie);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledJobInfoImpl writeJob(String jobTopic, String jobName, Map<String, Object> jobProperties, String scheduleName, boolean suspend, List<ScheduleInfoImpl> scheduleInfos) throws PersistenceException {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (jobProperties != null) {
                for (Map.Entry<String, Object> entry : jobProperties.entrySet()) {
                    String propName = entry.getKey();
                    if (ResourceHelper.ignoreProperty(propName)) continue;
                    properties.put(propName, entry.getValue());
                }
            }
            properties.put("event.job.topic", jobTopic);
            if (jobName != null) {
                properties.put("event.job.id", jobName);
            }
            properties.put("slingevent:created", Calendar.getInstance());
            properties.put("slingevent:application", Environment.APPLICATION_ID);
            properties.put("slingevent:scheduleName", scheduleName);
            String[] infoArray = new String[scheduleInfos.size()];
            int index = 0;
            for (ScheduleInfoImpl info : scheduleInfos) {
                infoArray[index] = info.getSerializedString();
                ++index;
            }
            properties.put("slingevent:scheduleInfo", infoArray);
            if (suspend) {
                properties.put("slingevent:scheduleSuspended", Boolean.TRUE);
            }
            properties.put("sling:resourceType", "slingevent:TimedEvent");
            String path = this.configuration.getScheduledJobsPath(true) + ResourceHelper.filterName(scheduleName);
            Resource existingInfo = resolver.getResource(path);
            if (existingInfo != null) {
                resolver.delete(existingInfo);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Updating scheduled job {} at {}", properties, (Object)path);
                }
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Storing new scheduled job {} at {}", properties, (Object)path);
            }
            ResourceHelper.getOrCreateResource(resolver, path, properties);
            properties.put("slingevent:scheduleInfo", scheduleInfos);
            ScheduledJobInfoImpl scheduledJobInfoImpl = this.addOrUpdateScheduledJob(properties);
            return scheduledJobInfoImpl;
        }
        finally {
            resolver.close();
        }
    }

    private void ignoreException(Exception e) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Ignored exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void configurationChanged(boolean active) {
        if (!active) {
            this.active = false;
            this.stopScheduling();
        } else {
            boolean previouslyActive = this.active;
            JobManagerConfiguration config = this.configuration;
            if (config != null) {
                this.active = config.getTopologyCapabilities().isLeader();
                if (this.active && !previouslyActive) {
                    this.startScheduling();
                }
                if (!this.active && previouslyActive) {
                    this.stopScheduling();
                }
            }
        }
    }

    public JobBuilder.ScheduleBuilder createJobBuilder(ScheduledJobInfoImpl info) {
        JobBuilderImpl builder = (JobBuilderImpl)this.jobManager.createJob(info.getJobTopic()).properties(info.getJobProperties());
        JobBuilder.ScheduleBuilder sb = builder.schedule(info.getName());
        return info.isSuspended() ? sb.suspend() : sb;
    }

    private boolean match(ScheduledJobInfoImpl job, Map<String, Object> template) {
        if (template != null) {
            for (Map.Entry<String, Object> current : template.entrySet()) {
                Operation op;
                String propName;
                char firstChar;
                String key = current.getKey();
                char c = firstChar = key.length() > 0 ? key.charAt(0) : (char)'\u0000';
                if (firstChar == '=') {
                    propName = key.substring(1);
                    op = Operation.EQUALS;
                } else if (firstChar == '<') {
                    char secondChar;
                    char c2 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.LESS_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.LESS;
                        propName = key.substring(1);
                    }
                } else if (firstChar == '>') {
                    char secondChar;
                    char c3 = secondChar = key.length() > 1 ? key.charAt(1) : (char)'\u0000';
                    if (secondChar == '=') {
                        op = Operation.GREATER_OR_EQUALS;
                        propName = key.substring(2);
                    } else {
                        op = Operation.GREATER;
                        propName = key.substring(1);
                    }
                } else {
                    propName = key;
                    op = Operation.EQUALS;
                }
                Object value = current.getValue();
                if (op == Operation.EQUALS) {
                    if (value.equals(job.getJobProperties().get(propName))) continue;
                    return false;
                }
                if (value instanceof Comparable) {
                    int result = ((Comparable)value).compareTo(job.getJobProperties().get(propName));
                    if (op == Operation.LESS && result != -1) {
                        return false;
                    }
                    if (op == Operation.LESS_OR_EQUALS && result == 1) {
                        return false;
                    }
                    if (op == Operation.GREATER_OR_EQUALS && result == -1) {
                        return false;
                    }
                    if (op != Operation.GREATER || result == 1) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ScheduledJobInfo> getScheduledJobs(String topic, long limit, Map<String, Object> ... templates) {
        ArrayList<ScheduledJobInfo> jobs = new ArrayList<ScheduledJobInfo>();
        long count = 0L;
        Map<String, ScheduledJobInfoImpl> map = this.scheduledJobs;
        synchronized (map) {
            for (ScheduledJobInfoImpl job : this.scheduledJobs.values()) {
                boolean add = true;
                if (topic != null && !topic.equals(job.getJobTopic())) {
                    add = false;
                }
                if (add && templates != null && templates.length != 0) {
                    Map<String, Object> template;
                    add = false;
                    Map<String, Object>[] arr$ = templates;
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && !(add = this.match(job, template = arr$[i$])); ++i$) {
                    }
                }
                if (!add) continue;
                jobs.add(job);
                if (limit <= 0L || ++count != limit) continue;
                break;
            }
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuspended(ScheduledJobInfoImpl info, boolean flag) {
        ResourceResolver resolver = this.configuration.createResourceResolver();
        try {
            StringBuilder sb = new StringBuilder(this.configuration.getScheduledJobsPath(true));
            sb.append(ResourceHelper.filterName(info.getName()));
            String path = sb.toString();
            Resource eventResource = resolver.getResource(path);
            if (eventResource != null) {
                ModifiableValueMap mvm = (ModifiableValueMap)eventResource.adaptTo(ModifiableValueMap.class);
                if (flag) {
                    mvm.put((Object)"slingevent:scheduleSuspended", (Object)Boolean.TRUE);
                } else {
                    mvm.remove((Object)"slingevent:scheduleSuspended");
                }
                resolver.commit();
            }
        }
        catch (PersistenceException pe) {
            this.ignoreException((Exception)((Object)pe));
        }
        finally {
            resolver.close();
        }
    }

    private static enum Operation {
        LESS,
        LESS_OR_EQUALS,
        EQUALS,
        GREATER_OR_EQUALS,
        GREATER;

    }

    private static final class ReadResult {
        public Event event;
        public boolean hasReadErrors;

        private ReadResult() {
        }
    }
}

