/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.jmx;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.StandardEmitterMBean;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.impl.jobs.jmx.QueueMBeanImpl;
import org.apache.sling.event.impl.jobs.jmx.QueueStatusEvent;
import org.apache.sling.event.jobs.Queue;
import org.apache.sling.event.jobs.jmx.QueuesMBean;
import org.apache.sling.event.jobs.jmx.StatisticsMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@Component
@Service(value={QueuesMBean.class})
@Property(name="jmx.objectname", value={"org.apache.sling:type=queues,name=QueueNames"})
public class QueuesMBeanImpl
extends StandardEmitterMBean
implements QueuesMBean {
    private static final String QUEUE_NOTIFICATION = "org.apache.sling.event.queue";
    private static final String[] NOTIFICATION_TYPES = new String[]{"org.apache.sling.event.queue"};
    private Map<String, QueueMBeanHolder> queues = new ConcurrentHashMap<String, QueueMBeanHolder>();
    private String[] names;
    private AtomicLong sequence = new AtomicLong(System.currentTimeMillis());
    private BundleContext bundleContext;

    public QueuesMBeanImpl() {
        super(QueuesMBean.class, false, (NotificationEmitter)new NotificationBroadcasterSupport(new MBeanNotificationInfo(NOTIFICATION_TYPES, Notification.class.getName(), "Notifications about queues")));
    }

    @Activate
    public void activate(BundleContext bc) {
        this.bundleContext = bc;
    }

    @Deactivate
    public void deactivate() {
        this.bundleContext = null;
    }

    public void sendEvent(QueueStatusEvent e) {
        if (e.isNew()) {
            this.bindQueueMBean(e);
        } else if (e.isRemoved()) {
            this.unbindQueueMBean(e);
        } else {
            this.updateQueueMBean(e);
        }
    }

    private void updateQueueMBean(QueueStatusEvent e) {
        QueueMBeanHolder queueMBeanHolder = this.queues.get(e.getQueue().getName());
        if (queueMBeanHolder != null) {
            String[] oldQueue = this.getQueueNames();
            this.names = null;
            this.sendNotification(new AttributeChangeNotification(this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "Queue " + e.getQueue().getName() + " updated ", "queueNames", "String[]", oldQueue, this.getQueueNames()));
        }
    }

    private void unbindQueueMBean(QueueStatusEvent e) {
        QueueMBeanHolder queueMBeanHolder = this.queues.get(e.getOldQueue().getName());
        if (queueMBeanHolder != null) {
            this.removeAndNotify(queueMBeanHolder);
        }
    }

    private void bindQueueMBean(QueueStatusEvent e) {
        QueueMBeanHolder queueMBeanHolder = this.queues.get(e.getQueue().getName());
        if (queueMBeanHolder != null) {
            this.removeAndNotify(queueMBeanHolder);
        }
        this.addAndNotify(e.getQueue());
    }

    private void addAndNotify(Queue queue) {
        String[] oldQueue = this.getQueueNames();
        QueueMBeanHolder queueMBeanHolder = this.add(queue);
        this.names = null;
        this.sendNotification(new AttributeChangeNotification(this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "Queue " + queueMBeanHolder.name + " added ", "queueNames", "String[]", oldQueue, this.getQueueNames()));
    }

    private void removeAndNotify(QueueMBeanHolder queueMBeanHolder) {
        String[] oldQueue = this.getQueueNames();
        this.remove(queueMBeanHolder);
        this.names = null;
        this.sendNotification(new AttributeChangeNotification(this, this.sequence.incrementAndGet(), System.currentTimeMillis(), "Queue " + queueMBeanHolder.name + " removed ", "queueNames", "String[]", oldQueue, this.getQueueNames()));
    }

    private QueueMBeanHolder add(Queue queue) {
        QueueMBeanImpl queueMBean = new QueueMBeanImpl(queue);
        ServiceRegistration serviceRegistration = this.bundleContext.registerService(StatisticsMBean.class.getName(), (Object)queueMBean, this.createProperties("jmx.objectname", "org.apache.sling:type=queues,name=" + queue.getName(), "service.description", "QueueMBean for queue " + queue.getName(), "service.vendor", "The Apache Software Foundation"));
        QueueMBeanHolder queueMBeanHolder = new QueueMBeanHolder(queue.getName(), queueMBean, serviceRegistration);
        this.queues.put(queueMBeanHolder.name, queueMBeanHolder);
        return queueMBeanHolder;
    }

    private Dictionary<String, Object> createProperties(Object ... values) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        for (int i = 0; i < values.length; i += 2) {
            ((Dictionary)props).put((String)values[i], values[i + 1]);
        }
        return props;
    }

    private void remove(QueueMBeanHolder queueMBeanHolder) {
        queueMBeanHolder.registration.unregister();
        this.queues.remove(queueMBeanHolder.name);
    }

    @Override
    public String[] getQueueNames() {
        if (this.names == null) {
            ArrayList<String> lnames = new ArrayList<String>(this.queues.keySet());
            Collections.sort(lnames);
            this.names = lnames.toArray(new String[lnames.size()]);
        }
        return this.names;
    }

    class QueueMBeanHolder {
        QueueMBeanImpl queueMBean;
        ServiceRegistration registration;
        String name;

        QueueMBeanHolder(String name, QueueMBeanImpl queueMBean, ServiceRegistration registration) {
            this.name = name;
            this.queueMBean = queueMBean;
            this.registration = registration;
        }
    }
}

