/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.stats;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.apache.sling.event.impl.jobs.stats.StatisticsImpl;
import org.apache.sling.event.impl.jobs.stats.TopicStatisticsImpl;
import org.apache.sling.event.jobs.Statistics;
import org.apache.sling.event.jobs.TopicStatistics;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

@Component(immediate=true)
@Service(value={EventHandler.class, StatisticsManager.class})
@Properties(value={@Property(name="event.topics", value={"org/apache/sling/event/notification/job/ADDED", "org/apache/sling/event/notification/job/START", "org/apache/sling/event/notification/job/CANCELLED", "org/apache/sling/event/notification/job/FAILED", "org/apache/sling/event/notification/job/FINISHED", "org/apache/sling/event/notification/job/REMOVED"})})
public class StatisticsManager
implements EventHandler {
    @Reference
    private JobManagerConfiguration configuration;
    private final StatisticsImpl globalStatistics = new StatisticsImpl(){

        @Override
        public synchronized void reset() {
            super.reset();
            StatisticsManager.this.topicStatistics.clear();
            for (Statistics s : StatisticsManager.this.queueStatistics.values()) {
                s.reset();
            }
        }
    };
    private final ConcurrentMap<String, TopicStatistics> topicStatistics = new ConcurrentHashMap<String, TopicStatistics>();
    private final ConcurrentMap<String, Statistics> queueStatistics = new ConcurrentHashMap<String, Statistics>();

    public Statistics getGlobalStatistics() {
        return this.globalStatistics;
    }

    public Map<String, TopicStatistics> getTopicStatistics() {
        return this.topicStatistics;
    }

    public Statistics getQueueStatistics(String queueName) {
        Statistics queueStats = (Statistics)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            queueStats = new StatisticsImpl();
        }
        return queueStats;
    }

    private StatisticsImpl getStatisticsForQueue(String queueName) {
        if (queueName == null) {
            return null;
        }
        StatisticsImpl queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
        if (queueStats == null) {
            this.queueStatistics.putIfAbsent(queueName, new StatisticsImpl());
            queueStats = (StatisticsImpl)this.queueStatistics.get(queueName);
        }
        return queueStats;
    }

    public void handleEvent(Event event) {
        String topic = (String)event.getProperty("event.job.topic");
        if (topic != null) {
            String queueName = (String)event.getProperty("event.job.queuename");
            StatisticsImpl queueStats = this.getStatisticsForQueue(queueName);
            TopicStatisticsImpl ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            if (ts == null) {
                this.topicStatistics.putIfAbsent(topic, new TopicStatisticsImpl(topic));
                ts = (TopicStatisticsImpl)this.topicStatistics.get(topic);
            }
            if (event.getTopic().equals("org/apache/sling/event/notification/job/ADDED")) {
                this.globalStatistics.incQueued();
                queueStats.incQueued();
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/CANCELLED")) {
                ts.addCancelled();
                this.globalStatistics.cancelledJob();
                if (queueStats != null) {
                    queueStats.cancelledJob();
                }
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FAILED")) {
                ts.addFailed();
                this.globalStatistics.failedJob();
                if (queueStats != null) {
                    queueStats.failedJob();
                }
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/FINISHED")) {
                Long time = (Long)event.getProperty(":time");
                ts.addFinished(time == null ? -1L : time);
                this.globalStatistics.finishedJob(time == null ? -1L : time);
                if (queueStats != null) {
                    queueStats.finishedJob(time == null ? -1L : time);
                }
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/START")) {
                Long time = (Long)event.getProperty(":time");
                ts.addActivated(time == null ? -1L : time);
                this.globalStatistics.addActive(time == null ? -1L : time);
                if (queueStats != null) {
                    queueStats.addActive(time == null ? -1L : time);
                }
            } else if (event.getTopic().equals("org/apache/sling/event/notification/job/REMOVED")) {
                this.globalStatistics.decQueued();
                this.globalStatistics.cancelledJob();
                if (queueStats != null) {
                    queueStats.decQueued();
                    queueStats.cancelledJob();
                }
            }
        }
    }

    protected void bindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        this.configuration = jobManagerConfiguration;
    }

    protected void unbindConfiguration(JobManagerConfiguration jobManagerConfiguration) {
        if (this.configuration == jobManagerConfiguration) {
            this.configuration = null;
        }
    }
}

