/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.timed;

import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.sling.event.EventUtil;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.event.impl.support.ResourceHelper;
import org.osgi.service.event.Event;

final class ScheduleInfo
implements Serializable {
    private static final long serialVersionUID = 8667701700547811142L;
    public final String topic;
    public final String expression;
    public final Long period;
    public final Date date;
    public final String jobId;
    private static final AtomicLong eventCounter = new AtomicLong(0L);

    public ScheduleInfo(Event event) throws IllegalArgumentException {
        this.expression = (String)event.getProperty("event.timed.scheduler");
        this.period = (Long)event.getProperty("event.timed.period");
        this.date = (Date)event.getProperty("event.timed.date");
        int count = 0;
        if (this.expression != null) {
            ++count;
        }
        if (this.period != null) {
            ++count;
        }
        if (this.date != null) {
            ++count;
        }
        if (count > 1) {
            throw new IllegalArgumentException("Only one configuration property from event.timed.scheduler, event.timed.period, or event.timed.date should be used.");
        }
        this.topic = (String)event.getProperty("event.topic.timed");
        if (this.topic == null) {
            throw new IllegalArgumentException("Timed event does not contain required property event.topic.timed : " + EventUtil.toString(event));
        }
        String id = (String)event.getProperty("event.timed.id");
        String jId = (String)event.getProperty("event.job.id");
        this.jobId = ScheduleInfo.getJobId(this.topic, id, jId);
    }

    private ScheduleInfo(String topic, String jobId) {
        this.topic = topic;
        this.expression = null;
        this.period = null;
        this.date = null;
        this.jobId = jobId;
    }

    public ScheduleInfo getStopInfo() {
        return new ScheduleInfo(this.topic, this.jobId);
    }

    public boolean isStopEvent() {
        return this.expression == null && this.period == null && this.date == null;
    }

    public static String getJobId(String topic, String timedEventId, String jobId) {
        StringBuilder sb = new StringBuilder(topic.replace('/', '.'));
        if (timedEventId != null) {
            sb.append('_');
            sb.append(ResourceHelper.filterName(timedEventId));
        }
        if (jobId != null) {
            sb.append('_');
            sb.append(ResourceHelper.filterName(jobId));
        }
        if (timedEventId == null && jobId == null) {
            sb.append("__");
            sb.append(Environment.APPLICATION_ID);
            sb.append("__");
            sb.append(eventCounter.getAndIncrement());
        }
        return sb.toString();
    }
}

