/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.timed;

import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.event.impl.EnvironmentComponent;

@Component(immediate=true)
@Service(value={TimedEventConfiguration.class})
@Property(name="repository.path", value={"/var/eventing/timed-jobs"})
public class TimedEventConfiguration {
    static final String DEFAULT_REPOSITORY_PATH = "/var/eventing/timed-jobs";
    static final String CONFIG_PROPERTY_REPOSITORY_PATH = "repository.path";
    @Reference
    private EnvironmentComponent environment;
    private String resourcePath;
    private String resourcePathWithSlash;

    @Activate
    protected void activate(Map<String, Object> props) {
        this.resourcePath = PropertiesUtil.toString(props.get(CONFIG_PROPERTY_REPOSITORY_PATH), DEFAULT_REPOSITORY_PATH);
        this.resourcePathWithSlash = this.resourcePath.concat("/");
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getResourcePathWithSlash() {
        return this.resourcePathWithSlash;
    }

    protected void bindEnvironment(EnvironmentComponent environmentComponent) {
        this.environment = environmentComponent;
    }

    protected void unbindEnvironment(EnvironmentComponent environmentComponent) {
        if (this.environment == environmentComponent) {
            this.environment = null;
        }
    }
}

