/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.sling.fsprovider.internal.FsResourceProvider;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMonitor
extends TimerTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Timer timer = new Timer();
    private boolean stop = false;
    private boolean stopped = true;
    private final Monitorable root;
    private final FsResourceProvider provider;

    public FileMonitor(FsResourceProvider provider, long interval) {
        this.provider = provider;
        this.root = new Monitorable(this.provider.getProviderRoot(), this.provider.getRootFile());
        FileMonitor.createStatus(this.root);
        this.logger.debug("Starting file monitor for {} with an interval of {}ms", (Object)this.root.file, (Object)interval);
        this.timer.schedule((TimerTask)this, 0L, interval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Timer timer = this.timer;
        synchronized (timer) {
            if (!this.stop) {
                this.stop = true;
                this.cancel();
                this.timer.cancel();
            }
            boolean interrupted = false;
            while (!this.stopped) {
                try {
                    this.timer.wait();
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
        this.logger.debug("Stopped file monitor for {}", (Object)this.root.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.timer;
        synchronized (object) {
            this.stopped = false;
            if (this.stop) {
                this.stopped = true;
                this.timer.notifyAll();
                return;
            }
        }
        object = this;
        synchronized (object) {
            try {
                EventAdmin localEA = this.provider.getEventAdmin();
                if (localEA != null) {
                    this.check(this.root, localEA);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object = this.timer;
        synchronized (object) {
            this.stopped = true;
            this.timer.notifyAll();
        }
    }

    private void check(Monitorable monitorable, EventAdmin localEA) {
        this.logger.debug("Checking {}", (Object)monitorable.file);
        if (monitorable.status instanceof NonExistingStatus) {
            if (monitorable.file.exists()) {
                FileMonitor.createStatus(monitorable);
                this.sendEvents(monitorable, "org/apache/sling/api/resource/Resource/ADDED", localEA);
            }
        } else if (!monitorable.file.exists()) {
            this.sendEvents(monitorable, "org/apache/sling/api/resource/Resource/REMOVED", localEA);
            monitorable.status = NonExistingStatus.SINGLETON;
        } else {
            FileStatus fs = (FileStatus)monitorable.status;
            boolean changed = false;
            if (fs.lastModified < monitorable.file.lastModified()) {
                fs.lastModified = monitorable.file.lastModified();
                this.sendEvents(monitorable, "org/apache/sling/api/resource/Resource/CHANGED", localEA);
                changed = true;
            }
            if (fs instanceof DirStatus) {
                DirStatus ds = (DirStatus)fs;
                for (int i = 0; i < ds.children.length; ++i) {
                    this.check(ds.children[i], localEA);
                }
                if (changed) {
                    File[] files = monitorable.file.listFiles();
                    if (files != null) {
                        Monitorable[] children = new Monitorable[files.length];
                        for (int i = 0; i < files.length; ++i) {
                            for (int m = 0; m < ds.children.length; ++m) {
                                if (!ds.children[m].file.equals(files[i])) continue;
                                children[i] = ds.children[m];
                                break;
                            }
                            if (children[i] != null) continue;
                            children[i] = new Monitorable(monitorable.path + '/' + files[i].getName(), files[i]);
                            children[i].status = NonExistingStatus.SINGLETON;
                            this.check(children[i], localEA);
                        }
                        ds.children = children;
                    } else {
                        ds.children = new Monitorable[0];
                    }
                }
            }
        }
    }

    private void sendEvents(Monitorable monitorable, String topic, EventAdmin localEA) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Detected change for resource {} : {}", (Object)monitorable.path, (Object)topic);
        }
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put("path", monitorable.path);
        String type = monitorable.status instanceof FileStatus ? "nt:file" : "nt:folder";
        ((Dictionary)properties).put("resourceType", type);
        localEA.postEvent(new Event(topic, properties));
    }

    private static void createStatus(Monitorable monitorable) {
        monitorable.status = !monitorable.file.exists() ? NonExistingStatus.SINGLETON : (monitorable.file.isFile() ? new FileStatus(monitorable.file) : new DirStatus(monitorable.file, monitorable.path));
    }

    private static final class NonExistingStatus {
        public static NonExistingStatus SINGLETON = new NonExistingStatus();

        private NonExistingStatus() {
        }
    }

    private static final class DirStatus
    extends FileStatus {
        public Monitorable[] children;

        public DirStatus(File dir, String path) {
            super(dir);
            File[] files = dir.listFiles();
            if (files != null) {
                this.children = new Monitorable[files.length];
                for (int i = 0; i < files.length; ++i) {
                    this.children[i] = new Monitorable(path + '/' + files[i].getName(), files[i]);
                    FileMonitor.createStatus(this.children[i]);
                }
            } else {
                this.children = new Monitorable[0];
            }
        }
    }

    private static class FileStatus {
        public long lastModified;

        public FileStatus(File file) {
            this.lastModified = file.lastModified();
        }
    }

    private static final class Monitorable {
        public final String path;
        public final File file;
        public Object status;

        public Monitorable(String path, File file) {
            this.path = path;
            this.file = file;
        }
    }
}

