/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.fsprovider.internal;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.fsprovider.internal.FileMonitor;
import org.apache.sling.fsprovider.internal.FsResource;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.EventAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.fsprovider.internal.FsResourceProvider", label="%resource.resolver.name", description="%resource.resolver.description", configurationFactory=true, policy=ConfigurationPolicy.REQUIRE, metatype=true)
@Service(value={ResourceProvider.class})
@Properties(value={@Property(name="service.description", value={"Sling Filesystem Resource Provider"}), @Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="provider.roots")})
public class FsResourceProvider
implements ResourceProvider {
    @Property
    public static final String PROP_PROVIDER_FILE = "provider.file";
    @Property(longValue={1000L})
    public static final String PROP_PROVIDER_CHECKINTERVAL = "provider.checkinterval";
    public static final long DEFAULT_CHECKINTERVAL = 1000L;
    private String providerRoot;
    private String providerRootPrefix;
    private File providerFile;
    private FileMonitor monitor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile EventAdmin eventAdmin;

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        return this.getResource(resourceResolver, path, this.getFile(path));
    }

    public Iterator<Resource> listChildren(Resource parent) {
        File parentFile = (File)parent.adaptTo(File.class);
        if (parentFile == null && (parentFile = this.getFile(parent.getPath())) == null) {
            Resource res;
            String relPath;
            String parentPath = parent.getPath().concat("/");
            if (this.providerRoot.startsWith(parentPath) && (relPath = this.providerRoot.substring(parentPath.length())).indexOf(47) < 0 && (res = this.getResource(parent.getResourceResolver(), this.providerRoot, this.providerFile)) != null) {
                return Collections.singletonList(res).iterator();
            }
            return null;
        }
        final File[] children = parentFile.listFiles();
        if (children != null && children.length > 0) {
            final ResourceResolver resolver = parent.getResourceResolver();
            final String parentPath = parent.getPath();
            return new Iterator<Resource>(){
                int index = 0;
                Resource next = this.seek();

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public Resource next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Resource result = this.next;
                    this.next = this.seek();
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }

                private Resource seek() {
                    while (this.index < children.length) {
                        File file = children[this.index++];
                        String path = parentPath + "/" + file.getName();
                        Resource result = FsResourceProvider.this.getResource(resolver, path, file);
                        if (result == null) continue;
                        return result;
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void activate(BundleContext bundleContext, Map<?, ?> props) {
        String providerRoot = (String)props.get("provider.roots");
        if (providerRoot == null || providerRoot.length() == 0) {
            throw new IllegalArgumentException("provider.roots property must be set");
        }
        String providerFileName = (String)props.get(PROP_PROVIDER_FILE);
        if (providerFileName == null || providerFileName.length() == 0) {
            throw new IllegalArgumentException("provider.file property must be set");
        }
        this.providerRoot = providerRoot;
        this.providerRootPrefix = providerRoot.concat("/");
        this.providerFile = this.getProviderFile(providerFileName, bundleContext);
        long checkInterval = 1000L;
        Object interval = props.get(PROP_PROVIDER_CHECKINTERVAL);
        if (interval != null && interval instanceof Long) {
            checkInterval = (Long)interval;
        }
        if (checkInterval > 100L) {
            this.monitor = new FileMonitor(this, checkInterval);
        }
    }

    protected void deactivate() {
        if (this.monitor != null) {
            this.monitor.stop();
            this.monitor = null;
        }
        this.providerRoot = null;
        this.providerRootPrefix = null;
        this.providerFile = null;
    }

    EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    File getRootFile() {
        return this.providerFile;
    }

    String getProviderRoot() {
        return this.providerRoot;
    }

    private File getProviderFile(String providerFileName, BundleContext bundleContext) {
        String home;
        File providerFile = new File(providerFileName);
        if (!providerFile.isAbsolute() && (home = bundleContext.getProperty("sling.home")) != null && home.length() > 0) {
            providerFile = new File(home, providerFileName);
        }
        if (!(providerFile = providerFile.getAbsoluteFile()).exists() && !providerFile.mkdirs()) {
            throw new IllegalArgumentException("Cannot create provider file root " + providerFile);
        }
        return providerFile;
    }

    private File getFile(String path) {
        if (path.equals(this.providerRoot)) {
            return this.providerFile;
        }
        if (path.startsWith(this.providerRootPrefix)) {
            String relPath = path.substring(this.providerRootPrefix.length());
            return new File(this.providerFile, relPath);
        }
        return null;
    }

    private Resource getResource(ResourceResolver resourceResolver, String resourcePath, File file) {
        if (file != null && file.exists()) {
            return new FsResource(resourceResolver, resourcePath, file);
        }
        return null;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }
}

