/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ChainedIterator<T>
implements Iterator<T> {
    private T nextElement;
    private final Iterator<Iterator<T>> iterators;
    private Iterator<T> currentIterator;

    public ChainedIterator(Iterator<Iterator<T>> iterators) {
        this.iterators = iterators;
    }

    protected T seek() {
        while (true) {
            if (this.currentIterator == null) {
                if (!this.iterators.hasNext()) {
                    return null;
                }
                this.currentIterator = this.iterators.next();
                continue;
            }
            if (this.currentIterator.hasNext()) {
                return this.currentIterator.next();
            }
            this.currentIterator = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.nextElement == null) {
            this.nextElement = this.seek();
        }
        return this.nextElement != null;
    }

    @Override
    public T next() {
        if (this.nextElement == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        T result = this.nextElement;
        this.nextElement = null;
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

