/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.InvalidSerializedDataException;
import javax.jcr.ItemExistsException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.lock.LockException;
import javax.jcr.lock.LockManager;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.QueryManager;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionManager;
import org.apache.sling.jcr.base.internal.mount.ProxyNamespaceRegistry;
import org.apache.sling.jcr.base.internal.mount.ProxyNodeTypeManager;
import org.apache.sling.jcr.base.internal.mount.ProxyQueryManager;
import org.apache.sling.jcr.base.internal.mount.ProxySession;
import org.apache.sling.jcr.base.internal.mount.ProxyWrapper;
import org.xml.sax.ContentHandler;

public class ProxyWorkspace<T extends Workspace>
extends ProxyWrapper<T>
implements Workspace {
    final T delegate2;

    public ProxyWorkspace(ProxySession mountSession, T delegate, T delegate2) {
        super(mountSession, delegate);
        this.delegate2 = delegate2;
    }

    public Session getSession() {
        return this.mountSession;
    }

    public String getName() {
        return ((Workspace)this.delegate).getName();
    }

    public QueryManager getQueryManager() throws RepositoryException {
        return new ProxyQueryManager(this.mountSession, ((Workspace)this.delegate).getQueryManager(), this.delegate2.getQueryManager());
    }

    public ContentHandler getImportContentHandler(String parentAbsPath, int uuidBehavior) throws PathNotFoundException, ConstraintViolationException, VersionException, LockException, AccessDeniedException, RepositoryException {
        return this.mountSession.getImportContentHandler(parentAbsPath, uuidBehavior);
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, VersionException, PathNotFoundException, ItemExistsException, ConstraintViolationException, InvalidSerializedDataException, LockException, AccessDeniedException, RepositoryException {
        this.mountSession.importXML(parentAbsPath, in, uuidBehavior);
    }

    public void copy(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        if (this.mountSession.isMount(srcAbsPath) && this.mountSession.isMount(destAbsPath)) {
            this.delegate2.copy(srcAbsPath, destAbsPath);
        } else {
            ((Workspace)this.delegate).copy(srcAbsPath, destAbsPath);
        }
    }

    public void copy(String srcWorkspace, String srcAbsPath, String destAbsPath) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        if (this.mountSession.isMount(srcAbsPath) && this.mountSession.isMount(destAbsPath)) {
            this.delegate2.copy(srcWorkspace, srcAbsPath, destAbsPath);
        } else {
            ((Workspace)this.delegate).copy(srcWorkspace, srcAbsPath, destAbsPath);
        }
    }

    public void clone(String srcWorkspace, String srcAbsPath, String destAbsPath, boolean removeExisting) throws NoSuchWorkspaceException, ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        if (this.mountSession.isMount(srcAbsPath) && this.mountSession.isMount(destAbsPath)) {
            this.delegate2.clone(srcWorkspace, srcAbsPath, destAbsPath, removeExisting);
        } else {
            ((Workspace)this.delegate).clone(srcWorkspace, srcAbsPath, destAbsPath, removeExisting);
        }
    }

    public void move(String srcAbsPath, String destAbsPath) throws ConstraintViolationException, VersionException, AccessDeniedException, PathNotFoundException, ItemExistsException, LockException, RepositoryException {
        if (this.mountSession.isMount(srcAbsPath) && this.mountSession.isMount(destAbsPath)) {
            this.delegate2.move(srcAbsPath, destAbsPath);
        } else {
            ((Workspace)this.delegate).move(srcAbsPath, destAbsPath);
        }
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        ((Workspace)this.delegate).restore(versions, removeExisting);
    }

    public void createWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
        ((Workspace)this.delegate).createWorkspace(name);
    }

    public void createWorkspace(String name, String srcWorkspace) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        ((Workspace)this.delegate).createWorkspace(name, srcWorkspace);
    }

    public void deleteWorkspace(String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        ((Workspace)this.delegate).deleteWorkspace(name);
    }

    public LockManager getLockManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Workspace)this.delegate).getLockManager();
    }

    public NamespaceRegistry getNamespaceRegistry() throws RepositoryException {
        return new ProxyNamespaceRegistry(((Workspace)this.delegate).getNamespaceRegistry(), this.delegate2.getNamespaceRegistry());
    }

    public NodeTypeManager getNodeTypeManager() throws RepositoryException {
        return new ProxyNodeTypeManager(((Workspace)this.delegate).getNodeTypeManager(), this.delegate2.getNodeTypeManager());
    }

    public ObservationManager getObservationManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Workspace)this.delegate).getObservationManager();
    }

    public VersionManager getVersionManager() throws UnsupportedRepositoryOperationException, RepositoryException {
        return ((Workspace)this.delegate).getVersionManager();
    }

    public String[] getAccessibleWorkspaceNames() throws RepositoryException {
        return ((Workspace)this.delegate).getAccessibleWorkspaceNames();
    }
}

