/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.bagel;

import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Logging;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.bagel.Aggregator;
import org.apache.spark.bagel.Combiner;
import org.apache.spark.bagel.DefaultCombiner;
import org.apache.spark.bagel.Message;
import org.apache.spark.bagel.Vertex;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class Bagel$
implements Logging {
    public static final Bagel$ MODULE$;
    private final StorageLevel DEFAULT_STORAGE_LEVEL;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new Bagel$();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public StorageLevel DEFAULT_STORAGE_LEVEL() {
        return this.DEFAULT_STORAGE_LEVEL;
    }

    public <K, V extends Vertex, M extends Message<K>, C, A> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, Option<Aggregator<V, A>> aggregator, Partitioner partitioner, int numPartitions, StorageLevel storageLevel, Function4<V, Option<C>, Option<A>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$1, Manifest<V> evidence$2, Manifest<M> evidence$3, Manifest<C> evidence$4, Manifest<A> evidence$5) {
        Tuple3<RDD<Tuple2<K, Tuple2<V, M[]>>>, Object, Object> tuple3;
        block1: {
            int numActiveVerts;
            int numMsgs;
            int splits = numPartitions != 0 ? numPartitions : sc.defaultParallelism();
            IntRef superstep = IntRef.create((int)0);
            RDD verts = vertices;
            RDD msgs = messages;
            boolean noActivity = false;
            RDD lastRDD = null;
            do {
                Tuple3 tuple32;
                RDD combinedMsgs;
                this.logInfo((Function0<String>)new Serializable(superstep){
                    public static final long serialVersionUID = 0L;
                    private final IntRef superstep$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Starting superstep ").append((Object)BoxesRunTime.boxToInteger((int)this.superstep$1.elem)).append((Object)".").toString();
                    }
                    {
                        this.superstep$1 = superstep$1;
                    }
                });
                long startTime = System.currentTimeMillis();
                Option<A> aggregated = this.agg(verts, aggregator, evidence$5);
                RDD x$7 = msgs;
                Manifest<K> x$8 = evidence$1;
                Manifest<M> x$9 = evidence$3;
                RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$7);
                Object x$10 = null;
                PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(x$7, x$8, x$9, null);
                Serializable x$11 = new Serializable(combiner){
                    public static final long serialVersionUID = 0L;
                    private final Combiner combiner$1;

                    public final C apply(M msg) {
                        return this.combiner$1.createCombiner(msg);
                    }
                    {
                        this.combiner$1 = combiner$1;
                    }
                };
                Serializable x$12 = new Serializable(combiner){
                    public static final long serialVersionUID = 0L;
                    private final Combiner combiner$1;

                    public final C apply(C combiner, M msg) {
                        return this.combiner$1.mergeMsg(combiner, msg);
                    }
                    {
                        this.combiner$1 = combiner$1;
                    }
                };
                Serializable x$13 = new Serializable(combiner){
                    public static final long serialVersionUID = 0L;
                    private final Combiner combiner$1;

                    public final C apply(C a, C b) {
                        return this.combiner$1.mergeCombiners(a, b);
                    }
                    {
                        this.combiner$1 = combiner$1;
                    }
                };
                Partitioner x$14 = partitioner;
                boolean x$15 = qual$1.combineByKeyWithClassTag$default$5();
                Serializer x$16 = qual$1.combineByKeyWithClassTag$default$6();
                RDD x$17 = combinedMsgs = qual$1.combineByKeyWithClassTag((Function1)x$11, (Function2)x$12, (Function2)x$13, x$14, x$15, x$16, evidence$4);
                Manifest<K> x$18 = evidence$1;
                Manifest<C> x$19 = evidence$4;
                RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$17);
                Object x$20 = null;
                RDD grouped = RDD$.MODULE$.rddToPairRDDFunctions(x$17, x$18, x$19, null).groupWith(verts);
                int superstep_ = superstep.elem;
                tuple3 = this.comp(sc, (RDD<Tuple2<K, Tuple2<Iterable<C>, Iterable<V>>>>)grouped, (Function2<V, Option<C>, Tuple2<V, M[]>>)new Serializable(compute, aggregated, superstep_){
                    public static final long serialVersionUID = 0L;
                    private final Function4 compute$1;
                    private final Option aggregated$1;
                    private final int superstep_$1;

                    public final Tuple2<V, M[]> apply(V x$1, Option<C> x$2) {
                        return (Tuple2)this.compute$1.apply(x$1, x$2, (Object)this.aggregated$1, (Object)BoxesRunTime.boxToInteger((int)this.superstep_$1));
                    }
                    {
                        this.compute$1 = compute$1;
                        this.aggregated$1 = aggregated$1;
                        this.superstep_$1 = superstep_$1;
                    }
                }, storageLevel, evidence$1);
                if (tuple3 == null) break block1;
                RDD processed = (RDD)tuple3._1();
                int numMsgs2 = BoxesRunTime.unboxToInt((Object)tuple3._2());
                int numActiveVerts2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                Tuple3 tuple33 = tuple32 = new Tuple3((Object)processed, (Object)BoxesRunTime.boxToInteger((int)numMsgs2), (Object)BoxesRunTime.boxToInteger((int)numActiveVerts2));
                RDD processed2 = (RDD)tuple33._1();
                numMsgs = BoxesRunTime.unboxToInt((Object)tuple33._2());
                numActiveVerts = BoxesRunTime.unboxToInt((Object)tuple33._3());
                Object object = lastRDD == null ? BoxedUnit.UNIT : lastRDD.unpersist(false);
                lastRDD = processed2;
                long timeTaken = System.currentTimeMillis() - startTime;
                this.logInfo((Function0<String>)new Serializable(superstep, timeTaken){
                    public static final long serialVersionUID = 0L;
                    private final IntRef superstep$1;
                    private final long timeTaken$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Superstep %d took %d s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.superstep$1.elem), BoxesRunTime.boxToLong((long)(this.timeTaken$1 / 1000L))}));
                    }
                    {
                        this.superstep$1 = superstep$1;
                        this.timeTaken$1 = timeTaken$1;
                    }
                });
                RDD x$21 = processed2;
                Manifest<K> x$22 = evidence$1;
                ClassTag x$23 = ClassTag$.MODULE$.apply(Tuple2.class);
                RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$21);
                Object x$24 = null;
                verts = RDD$.MODULE$.rddToPairRDDFunctions(x$21, x$22, x$23, null).mapValues((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final V apply(Tuple2<V, M[]> x0$1) {
                        Tuple2<V, M[]> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Vertex vert;
                            Vertex vertex = vert = (Vertex)tuple2._1();
                            return (V)vertex;
                        }
                        throw new MatchError(tuple2);
                    }
                });
                msgs = processed2.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final TraversableOnce<Tuple2<K, M>> apply(Tuple2<K, Tuple2<V, M[]>> x0$2) {
                        Tuple2 tuple2;
                        Tuple2<K, Tuple2<V, M[]>> tuple22 = x0$2;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            Message[] msgs = (Message[])tuple2._2();
                            TraversableOnce traversableOnce = (TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])msgs).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final Tuple2<K, M> apply(M m) {
                                    return new Tuple2(m.targetId(), m);
                                }
                            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                            return traversableOnce;
                        }
                        throw new MatchError(tuple22);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                ++superstep.elem;
            } while (!(noActivity = numMsgs == 0 && numActiveVerts == 0));
            return verts;
        }
        throw new MatchError(tuple3);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, Partitioner partitioner, int numPartitions, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$6, Manifest<V> evidence$7, Manifest<M> evidence$8, Manifest<C> evidence$9) {
        return this.run(sc, vertices, messages, combiner, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$6, evidence$7, evidence$8, evidence$9);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, Partitioner partitioner, int numPartitions, StorageLevel storageLevel, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$10, Manifest<V> evidence$11, Manifest<M> evidence$12, Manifest<C> evidence$13) {
        return this.run(sc, vertices, messages, combiner, (Option)None$.MODULE$, partitioner, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$10, evidence$11, evidence$12), evidence$10, evidence$11, evidence$12, evidence$13, (Manifest)ManifestFactory$.MODULE$.Nothing());
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, int numPartitions, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$14, Manifest<V> evidence$15, Manifest<M> evidence$16, Manifest<C> evidence$17) {
        return this.run(sc, vertices, messages, combiner, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$14, evidence$15, evidence$16, evidence$17);
    }

    public <K, V extends Vertex, M extends Message<K>, C> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, Combiner<M, C> combiner, int numPartitions, StorageLevel storageLevel, Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$18, Manifest<V> evidence$19, Manifest<M> evidence$20, Manifest<C> evidence$21) {
        HashPartitioner part = new HashPartitioner(numPartitions);
        return this.run(sc, vertices, messages, combiner, (Option)None$.MODULE$, (Partitioner)part, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$18, evidence$19, evidence$20), evidence$18, evidence$19, evidence$20, evidence$21, (Manifest)ManifestFactory$.MODULE$.Nothing());
    }

    public <K, V extends Vertex, M extends Message<K>> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, int numPartitions, Function3<V, Option<M[]>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$22, Manifest<V> evidence$23, Manifest<M> evidence$24) {
        return this.run(sc, vertices, messages, numPartitions, this.DEFAULT_STORAGE_LEVEL(), compute, evidence$22, evidence$23, evidence$24);
    }

    public <K, V extends Vertex, M extends Message<K>> RDD<Tuple2<K, V>> run(SparkContext sc, RDD<Tuple2<K, V>> vertices, RDD<Tuple2<K, M>> messages, int numPartitions, StorageLevel storageLevel, Function3<V, Option<M[]>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$25, Manifest<V> evidence$26, Manifest<M> evidence$27) {
        HashPartitioner part = new HashPartitioner(numPartitions);
        return this.run(sc, vertices, messages, (Combiner)new DefaultCombiner<M>(evidence$27), (Option)None$.MODULE$, (Partitioner)part, numPartitions, storageLevel, (Function4)this.addAggregatorArg(compute, evidence$25, evidence$26, evidence$27), evidence$25, evidence$26, evidence$27, (Manifest)ManifestFactory$.MODULE$.arrayType(evidence$27), (Manifest)ManifestFactory$.MODULE$.Nothing());
    }

    public <K, V extends Vertex, M extends Message<K>, C, A> StorageLevel run$default$8() {
        return this.DEFAULT_STORAGE_LEVEL();
    }

    private <K, V extends Vertex, A> Option<A> agg(RDD<Tuple2<K, V>> verts, Option<Aggregator<V, A>> aggregator, Manifest<A> evidence$28) {
        Option<Aggregator<V, A>> option;
        block4: {
            None$ none$;
            block3: {
                block2: {
                    option = aggregator;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Aggregator a = (Aggregator)some.x();
                    none$ = new Some(verts.map((Function1)new Serializable(a){
                        public static final long serialVersionUID = 0L;
                        private final Aggregator a$1;

                        public final A apply(Tuple2<K, V> x0$3) {
                            Tuple2<K, V> tuple2 = x0$3;
                            if (tuple2 != null) {
                                Vertex vert = (Vertex)tuple2._2();
                                A a = this.a$1.createAggregator(vert);
                                return a;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.a$1 = a$1;
                        }
                    }, evidence$28).reduce((Function2)new Serializable(a){
                        public static final long serialVersionUID = 0L;
                        private final Aggregator a$1;

                        public final A apply(A x$4, A x$5) {
                            return this.a$1.mergeAggregators(x$4, x$5);
                        }
                        {
                            this.a$1 = a$1;
                        }
                    }));
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                none$ = None$.MODULE$;
            }
            return none$;
        }
        throw new MatchError(option);
    }

    private <K, V extends Vertex, M extends Message<K>, C> Tuple3<RDD<Tuple2<K, Tuple2<V, M[]>>>, Object, Object> comp(SparkContext sc, RDD<Tuple2<K, Tuple2<Iterable<C>, Iterable<V>>>> grouped, Function2<V, Option<C>, Tuple2<V, M[]>> compute, StorageLevel storageLevel, Manifest<K> evidence$29) {
        ObjectRef numMsgs = ObjectRef.create((Object)sc.accumulator((Object)BoxesRunTime.boxToInteger((int)0), (AccumulatorParam)AccumulatorParam.IntAccumulatorParam$.MODULE$));
        ObjectRef numActiveVerts = ObjectRef.create((Object)sc.accumulator((Object)BoxesRunTime.boxToInteger((int)0), (AccumulatorParam)AccumulatorParam.IntAccumulatorParam$.MODULE$));
        RDD<Tuple2<K, Tuple2<Iterable<C>, Iterable<V>>>> x$25 = grouped;
        Manifest<K> x$26 = evidence$29;
        ClassTag x$27 = ClassTag$.MODULE$.apply(Tuple2.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$25);
        Object x$28 = null;
        RDD x$29 = RDD$.MODULE$.rddToPairRDDFunctions(x$25, x$26, x$27, null).mapValues((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Iterator<C>, Iterator<V>> apply(Tuple2<Iterable<C>, Iterable<V>> x) {
                return new Tuple2((Object)((IterableLike)x._1()).iterator(), (Object)((IterableLike)x._2()).iterator());
            }
        });
        Manifest<K> x$30 = evidence$29;
        ClassTag x$31 = ClassTag$.MODULE$.apply(Tuple2.class);
        RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$29);
        Object x$32 = null;
        RDD processed = RDD$.MODULE$.rddToPairRDDFunctions(x$29, x$30, x$31, null).flatMapValues((Function1)new Serializable(compute, numMsgs, numActiveVerts){
            public static final long serialVersionUID = 0L;
            private final Function2 compute$2;
            private final ObjectRef numMsgs$1;
            private final ObjectRef numActiveVerts$1;

            public final Iterable<Tuple2<V, M[]>> apply(Tuple2<Iterator<C>, Iterator<V>> x0$4) {
                Tuple2<Iterator<C>, Iterator<V>> tuple2;
                block6: {
                    boolean bl;
                    block9: {
                        Tuple2 tuple22;
                        block10: {
                            Iterable iterable;
                            block5: {
                                Tuple2 tuple23;
                                None$ none$;
                                Object object;
                                block8: {
                                    block7: {
                                        block4: {
                                            Iterator vs;
                                            tuple2 = x0$4;
                                            if (tuple2 == null || (vs = (Iterator)tuple2._2()).hasNext()) break block4;
                                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                            break block5;
                                        }
                                        if (tuple2 == null) break block6;
                                        Iterator c = (Iterator)tuple2._1();
                                        Iterator vs = (Iterator)tuple2._2();
                                        object = vs.next();
                                        bl = c.hasNext();
                                        if (!bl) break block7;
                                        none$ = new Some(c.next());
                                        break block8;
                                    }
                                    if (bl) break block9;
                                    none$ = None$.MODULE$;
                                }
                                tuple22 = (Tuple2)this.compute$2.apply(object, (Object)none$);
                                if (tuple22 == null) break block10;
                                Vertex newVert = (Vertex)tuple22._1();
                                Message[] newMsgs = (Message[])tuple22._2();
                                Tuple2 tuple24 = tuple23 = new Tuple2((Object)newVert, (Object)newMsgs);
                                Vertex newVert2 = (Vertex)tuple24._1();
                                Message[] newMsgs2 = (Message[])tuple24._2();
                                ((Accumulator)this.numMsgs$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.refArrayOps((Object[])newMsgs2).size()));
                                if (newVert2.active()) {
                                    ((Accumulator)this.numActiveVerts$1.elem).$plus$eq((Object)BoxesRunTime.boxToInteger((int)1));
                                }
                                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)newVert2, (Object)newMsgs2)));
                            }
                            return iterable;
                        }
                        throw new MatchError((Object)tuple22);
                    }
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                throw new MatchError(tuple2);
            }
            {
                this.compute$2 = compute$2;
                this.numMsgs$1 = numMsgs$1;
                this.numActiveVerts$1 = numActiveVerts$1;
            }
        }).persist(storageLevel);
        processed.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<K, Tuple2<V, M[]>> x) {
            }
        });
        return new Tuple3((Object)processed, ((Accumulator)numMsgs.elem).value(), ((Accumulator)numActiveVerts.elem).value());
    }

    private <K, V extends Vertex, M extends Message<K>, C> Function4<V, Option<C>, Option<Nothing$>, Object, Tuple2<V, M[]>> addAggregatorArg(Function3<V, Option<C>, Object, Tuple2<V, M[]>> compute, Manifest<K> evidence$30, Manifest<V> evidence$31, Manifest<M> evidence$32) {
        return new Serializable(compute){
            public static final long serialVersionUID = 0L;
            private final Function3 compute$3;

            public final Tuple2<V, M[]> apply(V vert, Option<C> msgs, Option<Nothing$> aggregated, int superstep) {
                return (Tuple2)this.compute$3.apply(vert, msgs, (Object)BoxesRunTime.boxToInteger((int)superstep));
            }
            {
                this.compute$3 = compute$3;
            }
        };
    }

    private Bagel$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.DEFAULT_STORAGE_LEVEL = StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }
}

