/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.math.BigInteger;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeRowWriters {

    public static class MapWriter {
        public static int getSize(UnsafeMapData input) {
            int sizeInBytes = 8 + input.getSizeInBytes();
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)sizeInBytes);
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, UnsafeMapData input) {
            long offset = target.getBaseOffset() + (long)cursor;
            UnsafeArrayData keyArray = input.keys;
            UnsafeArrayData valueArray = input.values;
            int keysNumBytes = keyArray.getSizeInBytes();
            int valuesNumBytes = valueArray.getSizeInBytes();
            int numBytes = 8 + keysNumBytes + valuesNumBytes;
            Platform.putInt((Object)target.getBaseObject(), (long)offset, (int)input.numElements());
            Platform.putInt((Object)target.getBaseObject(), (long)(offset + 4L), (int)keysNumBytes);
            if ((numBytes & 7) > 0) {
                Platform.putLong((Object)target.getBaseObject(), (long)(offset + (long)(numBytes >> 3 << 3)), (long)0L);
            }
            keyArray.writeToMemory(target.getBaseObject(), offset + 8L);
            valueArray.writeToMemory(target.getBaseObject(), offset + 8L + (long)keysNumBytes);
            target.setLong(ordinal, (long)cursor << 32 | (long)numBytes);
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }
    }

    public static class ArrayWriter {
        public static int getSize(UnsafeArrayData input) {
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)(input.getSizeInBytes() + 4));
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, UnsafeArrayData input) {
            int numBytes = input.getSizeInBytes() + 4;
            long offset = target.getBaseOffset() + (long)cursor;
            Platform.putInt((Object)target.getBaseObject(), (long)offset, (int)input.numElements());
            if ((numBytes & 7) > 0) {
                Platform.putLong((Object)target.getBaseObject(), (long)(offset + (long)(numBytes >> 3 << 3)), (long)0L);
            }
            input.writeToMemory(target.getBaseObject(), offset + 4L);
            target.setLong(ordinal, (long)cursor << 32 | (long)numBytes);
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }
    }

    public static class IntervalWriter {
        public static int write(UnsafeRow target, int ordinal, int cursor, CalendarInterval input) {
            long offset = target.getBaseOffset() + (long)cursor;
            Platform.putLong((Object)target.getBaseObject(), (long)offset, (long)input.months);
            Platform.putLong((Object)target.getBaseObject(), (long)(offset + 8L), (long)input.microseconds);
            target.setLong(ordinal, (long)cursor << 32);
            return 16;
        }
    }

    public static class StructWriter {
        public static int getSize(InternalRow input) {
            int numBytes = 0;
            if (!(input instanceof UnsafeRow)) {
                throw new UnsupportedOperationException();
            }
            numBytes = ((UnsafeRow)input).getSizeInBytes();
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, InternalRow input) {
            UnsafeRow row;
            int numBytes = 0;
            long offset = target.getBaseOffset() + (long)cursor;
            if (input instanceof UnsafeRow) {
                row = (UnsafeRow)input;
                numBytes = row.getSizeInBytes();
                if ((numBytes & 7) > 0) {
                    Platform.putLong((Object)target.getBaseObject(), (long)(offset + (long)(numBytes >> 3 << 3)), (long)0L);
                }
            } else {
                throw new UnsupportedOperationException();
            }
            row.writeToMemory(target.getBaseObject(), offset);
            target.setLong(ordinal, (long)cursor << 32 | (long)numBytes);
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }
    }

    public static class BinaryWriter {
        public static int getSize(byte[] input) {
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)input.length);
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, byte[] input) {
            long offset = target.getBaseOffset() + (long)cursor;
            int numBytes = input.length;
            if ((numBytes & 7) > 0) {
                Platform.putLong((Object)target.getBaseObject(), (long)(offset + (long)(numBytes >> 3 << 3)), (long)0L);
            }
            ByteArray.writeToMemory((byte[])input, (Object)target.getBaseObject(), (long)offset);
            target.setLong(ordinal, (long)cursor << 32 | (long)numBytes);
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }
    }

    public static class UTF8StringWriter {
        public static int getSize(UTF8String input) {
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)input.numBytes());
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, UTF8String input) {
            long offset = target.getBaseOffset() + (long)cursor;
            int numBytes = input.numBytes();
            if ((numBytes & 7) > 0) {
                Platform.putLong((Object)target.getBaseObject(), (long)(offset + (long)(numBytes >> 3 << 3)), (long)0L);
            }
            input.writeToMemory(target.getBaseObject(), offset);
            target.setLong(ordinal, (long)cursor << 32 | (long)numBytes);
            return ByteArrayMethods.roundNumberOfBytesToNearestWord((int)numBytes);
        }
    }

    public static class DecimalWriter {
        private static final int SIZE = 16;

        public static int getSize(Decimal input) {
            return 16;
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, Decimal input) {
            Object base = target.getBaseObject();
            long offset = target.getBaseOffset() + (long)cursor;
            Platform.putLong((Object)base, (long)offset, (long)0L);
            Platform.putLong((Object)base, (long)(offset + 8L), (long)0L);
            if (input == null) {
                target.setNullAt(ordinal);
                int fieldOffset = UnsafeRow.calculateBitSetWidthInBytes(target.numFields()) + ordinal * 8;
                Platform.putLong((Object)base, (long)(target.getBaseOffset() + (long)fieldOffset), (long)((long)cursor << 32));
                return 16;
            }
            BigInteger integer = input.toJavaBigDecimal().unscaledValue();
            byte[] bytes = integer.toByteArray();
            Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)base, (long)(target.getBaseOffset() + (long)cursor), (long)bytes.length);
            target.setLong(ordinal, (long)cursor << 32 | (long)bytes.length);
            return 16;
        }
    }

    public static class CompactDecimalWriter {
        public static int getSize(Decimal input) {
            return 0;
        }

        public static int write(UnsafeRow target, int ordinal, int cursor, Decimal input) {
            target.setLong(ordinal, input.toUnscaledLong());
            return 0;
        }
    }
}

