/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;

public class UnsafeWriters {
    public static void writeToMemory(Object inputObject, long inputOffset, Object targetObject, long targetOffset, int numBytes) {
        Platform.copyMemory((Object)inputObject, (long)inputOffset, (Object)targetObject, (long)targetOffset, (long)numBytes);
    }

    public static int getRoundedSize(int size) {
        return size;
    }

    public static class MapWriter {
        public static int getSize(UnsafeMapData input) {
            return UnsafeWriters.getRoundedSize(8 + input.getSizeInBytes());
        }

        public static int write(Object targetObject, long targetOffset, UnsafeMapData input) {
            UnsafeArrayData keyArray = input.keys;
            UnsafeArrayData valueArray = input.values;
            int keysNumBytes = keyArray.getSizeInBytes();
            int valuesNumBytes = valueArray.getSizeInBytes();
            int numBytes = 8 + keysNumBytes + valuesNumBytes;
            Platform.putInt((Object)targetObject, (long)targetOffset, (int)input.numElements());
            Platform.putInt((Object)targetObject, (long)(targetOffset + 4L), (int)keysNumBytes);
            UnsafeWriters.writeToMemory(keyArray.getBaseObject(), keyArray.getBaseOffset(), targetObject, targetOffset + 8L, keysNumBytes);
            UnsafeWriters.writeToMemory(valueArray.getBaseObject(), valueArray.getBaseOffset(), targetObject, targetOffset + 8L + (long)keysNumBytes, valuesNumBytes);
            return UnsafeWriters.getRoundedSize(numBytes);
        }
    }

    public static class ArrayWriter {
        public static int getSize(UnsafeArrayData input) {
            return UnsafeWriters.getRoundedSize(input.getSizeInBytes() + 4);
        }

        public static int write(Object targetObject, long targetOffset, UnsafeArrayData input) {
            int numBytes = input.getSizeInBytes();
            Platform.putInt((Object)targetObject, (long)targetOffset, (int)input.numElements());
            UnsafeWriters.writeToMemory(input.getBaseObject(), input.getBaseOffset(), targetObject, targetOffset + 4L, numBytes);
            return UnsafeWriters.getRoundedSize(numBytes + 4);
        }
    }

    public static class IntervalWriter {
        public static int getSize(UnsafeRow input) {
            return 16;
        }

        public static int write(Object targetObject, long targetOffset, CalendarInterval input) {
            Platform.putLong((Object)targetObject, (long)targetOffset, (long)input.months);
            Platform.putLong((Object)targetObject, (long)(targetOffset + 8L), (long)input.microseconds);
            return 16;
        }
    }

    public static class StructWriter {
        public static int getSize(UnsafeRow input) {
            return UnsafeWriters.getRoundedSize(input.getSizeInBytes());
        }

        public static int write(Object targetObject, long targetOffset, UnsafeRow input) {
            int numBytes = input.getSizeInBytes();
            UnsafeWriters.writeToMemory(input.getBaseObject(), input.getBaseOffset(), targetObject, targetOffset, numBytes);
            return UnsafeWriters.getRoundedSize(numBytes);
        }
    }

    public static class BinaryWriter {
        public static int getSize(byte[] input) {
            return UnsafeWriters.getRoundedSize(input.length);
        }

        public static int write(Object targetObject, long targetOffset, byte[] input) {
            int numBytes = input.length;
            UnsafeWriters.writeToMemory(input, Platform.BYTE_ARRAY_OFFSET, targetObject, targetOffset, numBytes);
            return UnsafeWriters.getRoundedSize(numBytes);
        }
    }

    public static class UTF8StringWriter {
        public static int getSize(UTF8String input) {
            return UnsafeWriters.getRoundedSize(input.numBytes());
        }

        public static int write(Object targetObject, long targetOffset, UTF8String input) {
            int numBytes = input.numBytes();
            UnsafeWriters.writeToMemory(input.getBaseObject(), input.getBaseOffset(), targetObject, targetOffset, numBytes);
            return UnsafeWriters.getRoundedSize(numBytes);
        }
    }

    public static class DecimalWriter {
        public static int getSize(Decimal input) {
            return 16;
        }

        public static int write(Object targetObject, long targetOffset, Decimal input) {
            byte[] bytes = input.toJavaBigDecimal().unscaledValue().toByteArray();
            int numBytes = bytes.length;
            assert (numBytes <= 16);
            Platform.putLong((Object)targetObject, (long)targetOffset, (long)0L);
            Platform.putLong((Object)targetObject, (long)(targetOffset + 8L), (long)0L);
            Platform.copyMemory((Object)bytes, (long)Platform.BYTE_ARRAY_OFFSET, (Object)targetObject, (long)targetOffset, (long)numBytes);
            return 16;
        }
    }
}

