/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.analysis;

import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.InternalOutputModes$Append$;
import org.apache.spark.sql.InternalOutputModes$Complete$;
import org.apache.spark.sql.InternalOutputModes$Update$;
import org.apache.spark.sql.catalyst.plans.FullOuter$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftAnti$;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.NaturalJoin;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.UsingJoin;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.CoGroup;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Except;
import org.apache.spark.sql.catalyst.plans.logical.GlobalLimit;
import org.apache.spark.sql.catalyst.plans.logical.GroupingSets;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.Intersect;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.LocalLimit;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ReturnAnswer;
import org.apache.spark.sql.catalyst.plans.logical.Sample;
import org.apache.spark.sql.catalyst.plans.logical.Sort;
import org.apache.spark.sql.catalyst.plans.logical.SortPartitions;
import org.apache.spark.sql.catalyst.plans.logical.Union;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.streaming.OutputMode;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class UnsupportedOperationChecker$ {
    public static final UnsupportedOperationChecker$ MODULE$;

    static {
        new UnsupportedOperationChecker$();
    }

    public void checkForBatch(LogicalPlan plan2) {
        plan2.foreachUp(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(LogicalPlan x0$1) {
                LogicalPlan logicalPlan = x0$1;
                if (logicalPlan.isStreaming()) {
                    throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Queries with streaming sources must be executed with writeStream.start()", logicalPlan);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
    }

    public void checkForStreaming(LogicalPlan plan2, OutputMode outputMode) {
        if (plan2.isStreaming()) {
            boolean bl;
            Seq aggregates = plan2.collect(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Aggregate aggregate;
                    A1 A1 = x1;
                    Object object = A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming() ? aggregate : function1.apply(x1);
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    Aggregate aggregate;
                    LogicalPlan logicalPlan = x1;
                    boolean bl = logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming();
                    return bl;
                }
            });
            if (aggregates.size() > 1) {
                throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Multiple streaming aggregations are not supported with streaming DataFrames/Datasets", plan2);
            }
            OutputMode outputMode2 = outputMode;
            InternalOutputModes$Append$ internalOutputModes$Append$ = InternalOutputModes$Append$.MODULE$;
            OutputMode outputMode3 = outputMode2;
            if (!(internalOutputModes$Append$ != null ? !internalOutputModes$Append$.equals(outputMode3) : outputMode3 != null) && aggregates.nonEmpty()) {
                throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " output mode not supported when there are streaming aggregations on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputMode}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streaming DataFrames/DataSets"})).s((Seq)Nil$.MODULE$)).toString(), plan2);
            }
            InternalOutputModes$Complete$ internalOutputModes$Complete$ = InternalOutputModes$Complete$.MODULE$;
            OutputMode outputMode4 = outputMode2;
            if (!(internalOutputModes$Complete$ != null ? !internalOutputModes$Complete$.equals(outputMode4) : outputMode4 != null)) {
                bl = true;
            } else {
                InternalOutputModes$Update$ internalOutputModes$Update$ = InternalOutputModes$Update$.MODULE$;
                OutputMode outputMode5 = outputMode2;
                bl = !(internalOutputModes$Update$ != null ? !internalOutputModes$Update$.equals(outputMode5) : outputMode5 != null);
            }
            if (bl && aggregates.isEmpty()) {
                throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " output mode not supported when there are no streaming aggregations on "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputMode}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"streaming DataFrames/Datasets"})).s((Seq)Nil$.MODULE$)).toString(), plan2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            plan2.foreachUp(new Serializable(plan2, outputMode){
                public static final long serialVersionUID = 0L;
                private final LogicalPlan plan$1;
                private final OutputMode outputMode$1;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void apply(LogicalPlan subPlan) {
                    LogicalPlan logicalPlan = subPlan;
                    if (logicalPlan instanceof Command) {
                        throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Commands like CreateTable*, AlterTable*, Show* are not supported with streaming DataFrames/Datasets", subPlan);
                    }
                    if (logicalPlan instanceof InsertIntoTable) {
                        throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("InsertIntoTable is not supported with streaming DataFrames/Datasets", subPlan);
                    }
                    if (logicalPlan instanceof Join) {
                        JoinType joinType;
                        Join join = (Join)logicalPlan;
                        LogicalPlan left = join.left();
                        LogicalPlan right = join.right();
                        JoinType joinType2 = joinType = join.joinType();
                        Inner$ inner$ = Inner$.MODULE$;
                        JoinType joinType3 = joinType2;
                        if (!(inner$ != null ? !inner$.equals(joinType3) : joinType3 != null)) {
                            if (left.isStreaming() && right.isStreaming()) {
                                throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Inner join between two streaming DataFrames/Datasets is not supported", subPlan);
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            FullOuter$ fullOuter$ = FullOuter$.MODULE$;
                            JoinType joinType4 = joinType2;
                            if (!(fullOuter$ != null ? !fullOuter$.equals(joinType4) : joinType4 != null)) {
                                if (left.isStreaming() || right.isStreaming()) {
                                    throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Full outer joins with streaming DataFrames/Datasets are not supported", subPlan);
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boolean bl;
                                LeftOuter$ leftOuter$ = LeftOuter$.MODULE$;
                                JoinType joinType5 = joinType2;
                                if (!(leftOuter$ != null ? !leftOuter$.equals(joinType5) : joinType5 != null)) {
                                    bl = true;
                                } else {
                                    LeftSemi$ leftSemi$ = LeftSemi$.MODULE$;
                                    JoinType joinType6 = joinType2;
                                    if (!(leftSemi$ != null ? !leftSemi$.equals(joinType6) : joinType6 != null)) {
                                        bl = true;
                                    } else {
                                        LeftAnti$ leftAnti$ = LeftAnti$.MODULE$;
                                        JoinType joinType7 = joinType2;
                                        bl = !(leftAnti$ != null ? !leftAnti$.equals(joinType7) : joinType7 != null);
                                    }
                                }
                                if (bl) {
                                    if (right.isStreaming()) {
                                        throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Left outer/semi/anti joins with a streaming DataFrame/Dataset on the right is not supported", subPlan);
                                    }
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    RightOuter$ rightOuter$ = RightOuter$.MODULE$;
                                    JoinType joinType8 = joinType2;
                                    if (!(rightOuter$ != null ? !rightOuter$.equals(joinType8) : joinType8 != null)) {
                                        if (left.isStreaming()) {
                                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Right outer join with a streaming DataFrame/Dataset on the left is not supported", subPlan);
                                        }
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    } else {
                                        boolean bl2 = joinType2 instanceof NaturalJoin ? true : joinType2 instanceof UsingJoin;
                                        if (!bl2) throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Join type ", " is not supported with streaming DataFrame/Dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinType})), subPlan);
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    }
                                }
                            }
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    } else {
                        ReturnAnswer returnAnswer;
                        LogicalPlan child;
                        Window window;
                        LogicalPlan child2;
                        Sample sample2;
                        LogicalPlan child3;
                        GroupingSets groupingSets;
                        LogicalPlan child4;
                        Except except;
                        LogicalPlan right;
                        Union union;
                        CoGroup coGroup;
                        if (logicalPlan instanceof CoGroup && (coGroup = (CoGroup)logicalPlan).children().exists((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$1) {
                                return x$1.isStreaming();
                            }
                        })) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("CoGrouping with a streaming DataFrame/Dataset is not supported", subPlan);
                        }
                        if (logicalPlan instanceof Union && ((SeqLike)((SeqLike)(union = (Union)logicalPlan).children().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$2) {
                                return x$2.isStreaming();
                            }
                        }, Seq$.MODULE$.canBuildFrom())).distinct()).size() == 2) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Union between streaming and batch DataFrames/Datasets is not supported", subPlan);
                        }
                        if (logicalPlan instanceof Except && (right = (except = (Except)logicalPlan).right()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Except with a streaming DataFrame/Dataset on the right is not supported", subPlan);
                        }
                        if (logicalPlan instanceof Intersect) {
                            Intersect intersect = (Intersect)logicalPlan;
                            LogicalPlan left = intersect.left();
                            LogicalPlan right2 = intersect.right();
                            if (left.isStreaming() && right2.isStreaming()) {
                                throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Intersect between two streaming DataFrames/Datasets is not supported", subPlan);
                            }
                        }
                        if (logicalPlan instanceof GroupingSets && (child4 = (groupingSets = (GroupingSets)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("GroupingSets is not supported on streaming DataFrames/Datasets", subPlan);
                        }
                        boolean bl = logicalPlan instanceof GlobalLimit ? true : logicalPlan instanceof LocalLimit;
                        if (bl && subPlan.children().forall((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(LogicalPlan x$3) {
                                return x$3.isStreaming();
                            }
                        })) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Limits are not supported on streaming DataFrames/Datasets", subPlan);
                        }
                        boolean bl3 = logicalPlan instanceof Sort ? true : logicalPlan instanceof SortPartitions;
                        if (bl3 && !UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$containsCompleteData$1(subPlan, this.plan$1, this.outputMode$1)) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Sorting is not supported on streaming DataFrames/Datasets, unless it is onaggregated DataFrame/Dataset in Complete mode", subPlan);
                        }
                        if (logicalPlan instanceof Sample && (child3 = (sample2 = (Sample)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Sampling is not supported on streaming DataFrames/Datasets", subPlan);
                        }
                        if (logicalPlan instanceof Window && (child2 = (window = (Window)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Non-time-based windows are not supported on streaming DataFrames/Datasets", subPlan);
                        }
                        if (logicalPlan instanceof ReturnAnswer && (child = (returnAnswer = (ReturnAnswer)logicalPlan).child()).isStreaming()) {
                            throw UnsupportedOperationChecker$.MODULE$.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Cannot return immediate result on streaming DataFrames/Dataset. Queries with streaming DataFrames/Datasets must be executed with writeStream.start().", subPlan);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
                {
                    this.plan$1 = plan$1;
                    this.outputMode$1 = outputMode$1;
                }
            });
            return;
        }
        throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError("Queries without streaming sources cannot be executed with writeStream.start()", plan2);
    }

    private void throwErrorIf(boolean condition, String msg, LogicalPlan operator) {
        if (condition) {
            throw this.org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(msg, operator);
        }
    }

    public Nothing$ org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$throwError(String msg, LogicalPlan operator) {
        throw new AnalysisException(msg, operator.origin().line(), operator.origin().startPosition(), (Option<LogicalPlan>)new Some((Object)operator), AnalysisException$.MODULE$.$lessinit$greater$default$5());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean org$apache$spark$sql$catalyst$analysis$UnsupportedOperationChecker$$containsCompleteData$1(LogicalPlan subplan, LogicalPlan plan$1, OutputMode outputMode$1) {
        Seq aggs = plan$1.collect(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Aggregate aggregate;
                A1 A1 = x2;
                Object object = A1 instanceof Aggregate && (aggregate = (Aggregate)A1).isStreaming() ? aggregate : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x2) {
                Aggregate aggregate;
                LogicalPlan logicalPlan = x2;
                boolean bl = logicalPlan instanceof Aggregate && (aggregate = (Aggregate)logicalPlan).isStreaming();
                return bl;
            }
        });
        if (!subplan.isStreaming()) return true;
        if (!aggs.nonEmpty()) return false;
        OutputMode outputMode = outputMode$1;
        InternalOutputModes$Complete$ internalOutputModes$Complete$ = InternalOutputModes$Complete$.MODULE$;
        if (outputMode == null) {
            if (internalOutputModes$Complete$ == null) return true;
            return false;
        } else if (outputMode.equals(internalOutputModes$Complete$)) return true;
        return false;
    }

    private UnsupportedOperationChecker$() {
        MODULE$ = this;
    }
}

