/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.util.Arrays;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MutableRow;
import org.apache.spark.sql.catalyst.expressions.XxHash64Function$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the estimated cardinality by HyperLogLog++.\n    _FUNC_(expr, relativeSD=0.05) - Returns the estimated cardinality by HyperLogLog++\n      with relativeSD, the maximum estimation error allowed.\n    ")
@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001B\u0001\u0003\u0001F\u00111\u0003S=qKJdun\u001a'pOBcWo\u001d)mkNT!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003-)\u0007\u0010\u001d:fgNLwN\\:\u000b\u0005\u001dA\u0011\u0001C2bi\u0006d\u0017p\u001d;\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0011b\u0003\b\t\u0003'Qi\u0011AA\u0005\u0003+\t\u00111#S7qKJ\fG/\u001b<f\u0003\u001e<'/Z4bi\u0016\u0004\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002\u0018;%\u0011a\u0004\u0007\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tA\u0001\u0011)\u001a!C\u0001C\u0005)1\r[5mIV\t!\u0005\u0005\u0002$I5\tA!\u0003\u0002&\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u001d\u0002!\u0011#Q\u0001\n\t\naa\u00195jY\u0012\u0004\u0003\u0002C\u0015\u0001\u0005+\u0007I\u0011\u0001\u0016\u0002\u0015I,G.\u0019;jm\u0016\u001cF)F\u0001,!\t9B&\u0003\u0002.1\t1Ai\\;cY\u0016D\u0001b\f\u0001\u0003\u0012\u0003\u0006IaK\u0001\fe\u0016d\u0017\r^5wKN#\u0005\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$X#A\u001a\u0011\u0005]!\u0014BA\u001b\u0019\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0012)A\u0005g\u00059R.\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\t\u0005\ts\u0001\u0011)\u001a!C\u0001e\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0001b\u000f\u0001\u0003\u0012\u0003\u0006IaM\u0001\u0016S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q)q\bQ!C\u0007B\u00111\u0003\u0001\u0005\u0006Aq\u0002\rA\t\u0005\bSq\u0002\n\u00111\u0001,\u0011\u001d\tD\b%AA\u0002MBq!\u000f\u001f\u0011\u0002\u0003\u00071\u0007C\u0003>\u0001\u0011\u0005Q\t\u0006\u0002@\r\")\u0001\u0005\u0012a\u0001E!)Q\b\u0001C\u0001\u0011R\u0019q(\u0013&\t\u000b\u0001:\u0005\u0019\u0001\u0012\t\u000b%:\u0005\u0019\u0001\u0012\t\u000b1\u0003A\u0011I'\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001O!\ty%K\u0004\u0002\u0018!&\u0011\u0011\u000bG\u0001\u0007!J,G-\u001a4\n\u0005M#&AB*ue&twM\u0003\u0002R1!)a\u000b\u0001C!/\u0006ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0002\u00131\")\u0011,\u0016a\u0001g\u0005Ib.Z<NkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3u\u0011\u0015Y\u0006\u0001\"\u0011]\u0003m9\u0018\u000e\u001e5OK^Le\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fiR\u0011!#\u0018\u0005\u0006=j\u0003\raM\u0001\u0018]\u0016<\u0018J\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKRD\u0011\u0002\u0019\u0001\u0003\u0002\u0003\u0005\u000b\u0011A\u001a\u0002\u0015>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]9mI\r\fG/\u00197zgR$S\r\u001f9sKN\u001c\u0018n\u001c8tI\u0005<wM]3hCR,G\u0005S=qKJdun\u001a'pOBcWo\u001d)mkN$C\u0005\u001d\u0005\u0007E\u0002\u0001\u000b\u0011B\u001a\u0002\u0011%$\u0007p\u00155jMRDa\u0001\u001a\u0001!\u0002\u0013)\u0017\u0001C<QC\u0012$\u0017N\\4\u0011\u0005]1\u0017BA4\u0019\u0005\u0011auN\\4\t\u0013%\u0004!\u0011!A!\u0002\u0003\u0019\u0014AS8sO\u0012\n\u0007/Y2iK\u0012\u001a\b/\u0019:lIM\fH\u000eJ2bi\u0006d\u0017p\u001d;%Kb\u0004(/Z:tS>t7\u000fJ1hOJ,w-\u0019;fI!K\b/\u001a:M_\u001edun\u001a)mkN\u0004F.^:%I5D\u0011b\u001b\u0001\u0003\u0002\u0003\u0005\u000b\u0011A\u0016\u0002!>\u0014x\rJ1qC\u000eDW\rJ:qCJ\\Ge]9mI\r\fG/\u00197zgR$S\r\u001f9sKN\u001c\u0018n\u001c8tI\u0005<wM]3hCR,G\u0005S=qKJdun\u001a'pOBcWo\u001d)mkN$C%\u00197qQ\u0006l%\u0007\u0003\u0004n\u0001\u0001\u0006IaM\u0001\t]Vlwk\u001c:eg\")q\u000e\u0001C!a\u0006A1\r[5mIJ,g.F\u0001r!\r\u0011(P\t\b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e\t\u0002\rq\u0012xn\u001c;?\u0013\u0005I\u0012BA=\u0019\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0007M+\u0017O\u0003\u0002z1!)a\u0010\u0001C!\u007f\u0006Aa.\u001e7mC\ndW-\u0006\u0002\u0002\u0002A\u0019q#a\u0001\n\u0007\u0005\u0015\u0001DA\u0004C_>dW-\u00198\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f\u0005AA-\u0019;b)f\u0004X-\u0006\u0002\u0002\u000eA!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014!\tQ\u0001^=qKNLA!a\u0006\u0002\u0012\tAA)\u0019;b)f\u0004X\rC\u0004\u0002\u001c\u0001!\t%!\b\u0002\u0015%t\u0007/\u001e;UsB,7/\u0006\u0002\u0002 A!!O_A\u0011!\u0011\ty!a\t\n\t\u0005\u0015\u0012\u0011\u0003\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016Dq!!\u000b\u0001\t\u0003\nY#A\bbO\u001e\u0014UO\u001a4feN\u001b\u0007.Z7b+\t\ti\u0003\u0005\u0003\u0002\u0010\u0005=\u0012\u0002BA\u0019\u0003#\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011%\t)\u0004\u0001b\u0001\n\u0003\n9$A\nbO\u001e\u0014UO\u001a4fe\u0006#HO]5ckR,7/\u0006\u0002\u0002:A!!O_A\u001e!\r\u0019\u0013QH\u0005\u0004\u0003\u007f!!AE!uiJL'-\u001e;f%\u00164WM]3oG\u0016D\u0001\"a\u0011\u0001A\u0003%\u0011\u0011H\u0001\u0015C\u001e<')\u001e4gKJ\fE\u000f\u001e:jEV$Xm\u001d\u0011\t\u0013\u0005\u001d\u0003A1A\u0005B\u0005]\u0012\u0001G5oaV$\u0018iZ4Ck\u001a4WM]!uiJL'-\u001e;fg\"A\u00111\n\u0001!\u0002\u0013\tI$A\rj]B,H/Q4h\u0005V4g-\u001a:BiR\u0014\u0018NY;uKN\u0004\u0003bBA(\u0001\u0011\u0005\u0013\u0011K\u0001\u000bS:LG/[1mSj,G\u0003BA*\u00033\u00022aFA+\u0013\r\t9\u0006\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u0002\\\u00055\u0003\u0019AA/\u0003\u0019\u0011WO\u001a4feB\u00191%a\u0018\n\u0007\u0005\u0005DA\u0001\u0006NkR\f'\r\\3S_^Dq!!\u001a\u0001\t\u0003\n9'\u0001\u0004va\u0012\fG/\u001a\u000b\u0007\u0003'\nI'a\u001b\t\u0011\u0005m\u00131\ra\u0001\u0003;B\u0001\"!\u001c\u0002d\u0001\u0007\u0011qN\u0001\u0006S:\u0004X\u000f\u001e\t\u0005\u0003c\n\u0019(D\u0001\u0007\u0013\r\t)H\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0004\u0002z\u0001!\t%a\u001f\u0002\u000b5,'oZ3\u0015\r\u0005M\u0013QPAA\u0011!\ty(a\u001eA\u0002\u0005u\u0013a\u00022vM\u001a,'/\r\u0005\t\u0003\u0007\u000b9\b1\u0001\u0002p\u00059!-\u001e4gKJ\u0014\u0004bBAD\u0001\u0011\u0005\u0011\u0011R\u0001\rKN$\u0018.\\1uK\nK\u0017m\u001d\u000b\u0004W\u0005-\u0005bBAG\u0003\u000b\u0003\raK\u0001\u0002K\"9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0015\u0001B3wC2$B!!&\u0002\u001cB\u0019q#a&\n\u0007\u0005e\u0005DA\u0002B]fD!\"a\u0017\u0002\u0010B\u0005\t\u0019AA8\u0011\u0019\ty\n\u0001C\u0001U\u00059AO];f%N$\u0007\"CAR\u0001\u0005\u0005I\u0011AAS\u0003\u0011\u0019w\u000e]=\u0015\u0013}\n9+!+\u0002,\u00065\u0006\u0002\u0003\u0011\u0002\"B\u0005\t\u0019\u0001\u0012\t\u0011%\n\t\u000b%AA\u0002-B\u0001\"MAQ!\u0003\u0005\ra\r\u0005\ts\u0005\u0005\u0006\u0013!a\u0001g!I\u0011\u0011\u0017\u0001\u0012\u0002\u0013\u0005\u00111W\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t)LK\u0002#\u0003o[#!!/\u0011\t\u0005m\u0016QY\u0007\u0003\u0003{SA!a0\u0002B\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007D\u0012AC1o]>$\u0018\r^5p]&!\u0011qYA_\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u0017\u0004\u0011\u0013!C\u0001\u0003\u001b\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P*\u001a1&a.\t\u0013\u0005M\u0007!%A\u0005\u0002\u0005U\u0017AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0003/T3aMA\\\u0011%\tY\u000eAI\u0001\n\u0003\t).\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005}\u0007!!A\u0005B\u0005\u0005\u0018!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002dB!\u0011Q]Ax\u001b\t\t9O\u0003\u0003\u0002j\u0006-\u0018\u0001\u00027b]\u001eT!!!<\u0002\t)\fg/Y\u0005\u0004'\u0006\u001d\b\u0002CAz\u0001\u0005\u0005I\u0011\u0001\u001a\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005]\b!!A\u0005\u0002\u0005e\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003+\u000bY\u0010C\u0005\u0002~\u0006U\u0018\u0011!a\u0001g\u0005\u0019\u0001\u0010J\u0019\t\u0013\t\u0005\u0001!!A\u0005B\t\r\u0011a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0015\u0001C\u0002B\u0004\u0005\u001b\t)*\u0004\u0002\u0003\n)\u0019!1\u0002\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u0010\t%!\u0001C%uKJ\fGo\u001c:\t\u0013\tM\u0001!!A\u0005\u0002\tU\u0011\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u0005!q\u0003\u0005\u000b\u0003{\u0014\t\"!AA\u0002\u0005U\u0005\"\u0003B\u000e\u0001\u0005\u0005I\u0011\tB\u000f\u0003\u0019)\u0017/^1mgR!\u0011\u0011\u0001B\u0010\u0011)\tiP!\u0007\u0002\u0002\u0003\u0007\u0011Q\u0013\u0015\b\u0001\t\r\"\u0011\u0006B\u0016!\r\u0019#QE\u0005\u0004\u0005O!!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0005[\t\u0011qW0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007%Z:uS6\fG/\u001a3!G\u0006\u0014H-\u001b8bY&$\u0018\u0010\t2zA!K\b/\u001a:M_\u001edunZ\u0016,])\u0001\u0003\u0005\t\u0011`\rVs5i\u0018\u0015fqB\u0014H\u0006\t:fY\u0006$\u0018N^3T\tv\u0002d\u0006M\u001b*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015\u001cH/[7bi\u0016$\u0007eY1sI&t\u0017\r\\5us\u0002\u0012\u0017\u0010\t%za\u0016\u0014Hj\\4M_\u001e\\3F\u0003\u0011!A\u0001\u0002\u0003e^5uQ\u0002\u0012X\r\\1uSZ,7\u000b\u0012\u0017!i\",\u0007%\\1yS6,X\u000eI3ti&l\u0017\r^5p]\u0002*'O]8sA\u0005dGn\\<fI:R\u0001\u0005\t\u0011!\u000f\u001d\u0011\tD\u0001E\u0001\u0005g\t1\u0003S=qKJdun\u001a'pOBcWo\u001d)mkN\u00042a\u0005B\u001b\r\u0019\t!\u0001#\u0001\u00038M)!Q\u0007B\u001d9A\u0019qCa\u000f\n\u0007\tu\u0002D\u0001\u0004B]f\u0014VM\u001a\u0005\b{\tUB\u0011\u0001B!)\t\u0011\u0019\u0004C\u0005\u0003F\tU\"\u0019!C\u0001e\u0005Iqk\u0014*E?NK%,\u0012\u0005\t\u0005\u0013\u0012)\u0004)A\u0005g\u0005Qqk\u0014*E?NK%,\u0012\u0011\t\u0013\t5#Q\u0007b\u0001\n\u0003\u0011\u0014!\u0004*F\u000f&\u001bF+\u0012*`'&SV\t\u0003\u0005\u0003R\tU\u0002\u0015!\u00034\u00039\u0011ViR%T)\u0016\u0013vlU%[\u000b\u0002B!B!\u0016\u00036\t\u0007I\u0011\u0001B,\u0003I\u0011ViR%T)\u0016\u0013vlV(S\t~k\u0015iU&\u0016\u0003\u0015D\u0001Ba\u0017\u00036\u0001\u0006I!Z\u0001\u0014%\u0016;\u0015j\u0015+F%~;vJ\u0015#`\u001b\u0006\u001b6\n\t\u0005\n\u0005?\u0012)D1A\u0005\u0002I\n!CU#H\u0013N#VIU*`!\u0016\u0013vlV(S\t\"A!1\rB\u001bA\u0003%1'A\nS\u000b\u001eK5\u000bV#S'~\u0003VIU0X\u001fJ#\u0005\u0005C\u0005\u0003h\tU\"\u0019!C\u0001e\u0005\t1\n\u0003\u0005\u0003l\tU\u0002\u0015!\u00034\u0003\tY\u0005\u0005\u0003\u0006\u0003p\tU\"\u0019!C\u0001\u0005c\n!\u0002\u0016%S\u000bNCu\n\u0014#T+\t\u0011\u0019\b\u0005\u0003\u0018\u0005kZ\u0013b\u0001B<1\t)\u0011I\u001d:bs\"I!1\u0010B\u001bA\u0003%!1O\u0001\f)\"\u0013Vi\u0015%P\u0019\u0012\u001b\u0006\u0005\u0003\u0006\u0003\u0000\tU\"\u0019!C\u0001\u0005\u0003\u000b\u0011CU!X?\u0016\u001bF+S'B)\u0016{F)\u0011+B+\t\u0011\u0019\tE\u0003\u0018\u0005k\u0012\u0019\bC\u0005\u0003\b\nU\u0002\u0015!\u0003\u0003\u0004\u0006\u0011\"+Q,`\u000bN#\u0016*T!U\u000b~#\u0015\tV!!\u0011)\u0011YI!\u000eC\u0002\u0013\u0005!\u0011Q\u0001\n\u0005&\u000b5k\u0018#B)\u0006C\u0011Ba$\u00036\u0001\u0006IAa!\u0002\u0015\tK\u0015iU0E\u0003R\u000b\u0005\u0005\u0003\u0005\u0003\u0014\nUB\u0011\u0002BK\u0003U1\u0018\r\\5eCR,Gi\\;cY\u0016d\u0015\u000e^3sC2$2a\u000bBL\u0011\u001d\u0011IJ!%A\u0002\t\n1!\u001a=q\u0011)\u0011iJ!\u000e\u0002\u0002\u0013\u0005%qT\u0001\u0006CB\u0004H.\u001f\u000b\n\u007f\t\u0005&1\u0015BS\u0005OCa\u0001\tBN\u0001\u0004\u0011\u0003\u0002C\u0015\u0003\u001cB\u0005\t\u0019A\u0016\t\u0011E\u0012Y\n%AA\u0002MB\u0001\"\u000fBN!\u0003\u0005\ra\r\u0005\u000b\u0005W\u0013)$!A\u0005\u0002\n5\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0005_\u0013Y\fE\u0003\u0018\u0005c\u0013),C\u0002\u00034b\u0011aa\u00149uS>t\u0007cB\f\u00038\nZ3gM\u0005\u0004\u0005sC\"A\u0002+va2,G\u0007C\u0005\u0003>\n%\u0016\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010\n\u0019\t\u0015\t\u0005'QGI\u0001\n\u0003\ti-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00133\u0011)\u0011)M!\u000e\u0012\u0002\u0013\u0005\u0011Q[\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g!Q!\u0011\u001aB\u001b#\u0003%\t!!6\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIQB!B!4\u00036E\u0005I\u0011AAg\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e!Q!\u0011\u001bB\u001b#\u0003%\t!!6\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0011)N!\u000e\u0012\u0002\u0013\u0005\u0011Q[\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\t\u0015\te'QGA\u0001\n\u0013\u0011Y.A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bo!\u0011\t)Oa8\n\t\t\u0005\u0018q\u001d\u0002\u0007\u001f\nTWm\u0019;")
public class HyperLogLogPlusPlus
extends ImperativeAggregate
implements Serializable {
    private final Expression child;
    private final double relativeSD;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
    private final int idxShift;
    private final long wPadding;
    public final int org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
    public final double org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2;
    private final int numWords;
    private final Seq<AttributeReference> aggBufferAttributes;
    private final Seq<AttributeReference> inputAggBufferAttributes;

    public static int $lessinit$greater$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$4();
    }

    public static int $lessinit$greater$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$3();
    }

    public static double $lessinit$greater$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.$lessinit$greater$default$2();
    }

    public static int apply$default$4() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$4();
    }

    public static int apply$default$3() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return HyperLogLogPlusPlus$.MODULE$.apply$default$2();
    }

    public static double[][] BIAS_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.BIAS_DATA();
    }

    public static double[][] RAW_ESTIMATE_DATA() {
        return HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA();
    }

    public static double[] THRESHOLDS() {
        return HyperLogLogPlusPlus$.MODULE$.THRESHOLDS();
    }

    public static int K() {
        return HyperLogLogPlusPlus$.MODULE$.K();
    }

    public static int REGISTERS_PER_WORD() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
    }

    public static long REGISTER_WORD_MASK() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
    }

    public static int REGISTER_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
    }

    public static int WORD_SIZE() {
        return HyperLogLogPlusPlus$.MODULE$.WORD_SIZE();
    }

    public Expression child() {
        return this.child;
    }

    public double relativeSD() {
        return this.relativeSD;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    @Override
    public String prettyName() {
        return "approx_count_distinct";
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$2 = newMutableAggBufferOffset;
        Expression x$3 = this.copy$default$1();
        double x$4 = this.copy$default$2();
        int x$5 = this.copy$default$4();
        return this.copy(x$3, x$4, x$2, x$5);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$6 = newInputAggBufferOffset;
        Expression x$7 = this.copy$default$1();
        double x$8 = this.copy$default$2();
        int x$9 = this.copy$default$3();
        return this.copy(x$7, x$8, x$9, x$6);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AnyDataType$[]{AnyDataType$.MODULE$}));
    }

    @Override
    public StructType aggBufferSchema() {
        return StructType$.MODULE$.fromAttributes(this.aggBufferAttributes());
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> inputAggBufferAttributes() {
        return this.inputAggBufferAttributes;
    }

    @Override
    public void initialize(MutableRow buffer) {
        for (int word = 0; word < this.numWords; ++word) {
            buffer.setLong(this.mutableAggBufferOffset() + word, 0L);
        }
    }

    @Override
    public void update(MutableRow buffer, InternalRow input) {
        Object v = this.child().eval(input);
        if (v != null) {
            long x = XxHash64Function$.MODULE$.hash(v, this.child().dataType(), 42L);
            int idx = (int)(x >>> this.idxShift);
            long pw = (long)Long.numberOfLeadingZeros(x << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p | this.wPadding) + 1L;
            int wordOffset = idx / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD();
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE() * (idx - wordOffset * HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD());
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK() << shift;
            long Midx = (word & mask) >>> shift;
            if (pw > Midx) {
                buffer.setLong(this.mutableAggBufferOffset() + wordOffset, word & (mask ^ 0xFFFFFFFFFFFFFFFFL) | pw << shift);
            }
        }
    }

    @Override
    public void merge(MutableRow buffer1, InternalRow buffer2) {
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word1 = buffer1.getLong(this.mutableAggBufferOffset() + wordOffset);
            long word2 = buffer2.getLong(this.inputAggBufferOffset() + wordOffset);
            long word = 0L;
            long mask = HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                word |= Math.max(word1 & mask, word2 & mask);
                mask <<= HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
            buffer1.setLong(this.mutableAggBufferOffset() + wordOffset, word);
        }
    }

    public double estimateBias(double e) {
        int high;
        double[] estimates = HyperLogLogPlusPlus$.MODULE$.RAW_ESTIMATE_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        int numEstimates = estimates.length;
        int n = Arrays.binarySearch(estimates, 0, numEstimates, e);
        switch (n) {
            default: 
        }
        int nearestEstimateIndex = n < 0 ? -(n + 1) : n;
        int low = package$.MODULE$.max(nearestEstimateIndex - HyperLogLogPlusPlus$.MODULE$.K() + 1, 0);
        for (high = package$.MODULE$.min(low + HyperLogLogPlusPlus$.MODULE$.K(), numEstimates); high < numEstimates && this.distance$1(high, e, estimates) < this.distance$1(low, e, estimates); ++high) {
            ++low;
        }
        double[] biases = HyperLogLogPlusPlus$.MODULE$.BIAS_DATA()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4];
        double biasSum = 0.0;
        for (int i = low; i < high; ++i) {
            biasSum += biases[i];
        }
        return biasSum / (double)(high - low);
    }

    @Override
    public Object eval(InternalRow buffer) {
        double H;
        DoubleRef zInverse = new DoubleRef(0.0);
        double V = 0.0;
        int idx = 0;
        for (int wordOffset = 0; wordOffset < this.numWords; ++wordOffset) {
            long word = buffer.getLong(this.mutableAggBufferOffset() + wordOffset);
            int shift = 0;
            for (int i = 0; idx < this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m && i < HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD(); ++i, ++idx) {
                long Midx = word >>> shift & HyperLogLogPlusPlus$.MODULE$.REGISTER_WORD_MASK();
                zInverse.elem += 1.0 / (double)(1L << (int)Midx);
                if (Midx == 0L) {
                    V += 1.0;
                }
                shift += HyperLogLogPlusPlus$.MODULE$.REGISTER_SIZE();
            }
        }
        double estimate = V > 0.0 ? ((H = (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * Math.log((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / V)) <= HyperLogLogPlusPlus$.MODULE$.THRESHOLDS()[this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 4] ? H : this.EBiasCorrected$1(zInverse)) : this.EBiasCorrected$1(zInverse);
        return BoxesRunTime.boxToLong((long)Math.round(estimate));
    }

    public double trueRsd() {
        return 1.04 / package$.MODULE$.sqrt((double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m);
    }

    public HyperLogLogPlusPlus copy(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new HyperLogLogPlusPlus(child, relativeSD, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public double copy$default$2() {
        return this.relativeSD();
    }

    public int copy$default$3() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$4() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "HyperLogLogPlusPlus";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.relativeSD());
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HyperLogLogPlusPlus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HyperLogLogPlusPlus)) return false;
        boolean bl = true;
        if (!bl) return false;
        HyperLogLogPlusPlus hyperLogLogPlusPlus = (HyperLogLogPlusPlus)x$1;
        Expression expression = this.child();
        Expression expression2 = hyperLogLogPlusPlus.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.relativeSD() != hyperLogLogPlusPlus.relativeSD()) return false;
        if (this.mutableAggBufferOffset() != hyperLogLogPlusPlus.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != hyperLogLogPlusPlus.inputAggBufferOffset()) return false;
        if (!hyperLogLogPlusPlus.canEqual(this)) return false;
        return true;
    }

    private final double distance$1(int i, double e$1, double[] estimates$1) {
        double diff = e$1 - estimates$1[i];
        return diff * diff;
    }

    private final double EBiasCorrected$1(DoubleRef zInverse$1) {
        double d = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2 / zInverse$1.elem;
        double d2 = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p < 19 && d < 5.0 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m ? d - this.estimateBias(d) : d;
        return d2;
    }

    public HyperLogLogPlusPlus(Expression child, double relativeSD, int mutableAggBufferOffset, int inputAggBufferOffset) {
        double d;
        this.child = child;
        this.relativeSD = relativeSD;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p = (int)Math.ceil(2.0 * Math.log(1.106 / relativeSD) / Math.log(2.0));
        Predef$.MODULE$.require(this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p >= 4, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "HLL++ requires at least 4 bits for addressing. Use a lower error, at most 27%.";
            }
        });
        this.idxShift = 64 - this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        this.wPadding = 1L << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p - 1;
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m = 1 << this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        int n = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$p;
        switch (n) {
            default: {
                d = 0.7213 / (1.0 + 1.079 / (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m) * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 6: {
                d = 0.709 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 5: {
                d = 0.697 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
                break;
            }
            case 4: {
                d = 0.673 * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m * (double)this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m;
            }
        }
        this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$alphaM2 = d;
        this.numWords = this.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$m / HyperLogLogPlusPlus$.MODULE$.REGISTERS_PER_WORD() + 1;
        this.aggBufferAttributes = (Seq)Seq$.MODULE$.tabulate(this.numWords, (Function1)new $anonfun$2(this));
        this.inputAggBufferAttributes = (Seq)this.aggBufferAttributes().map((Function1)new $anonfun$3(this), Seq$.MODULE$.canBuildFrom());
    }

    public HyperLogLogPlusPlus(Expression child) {
        this(child, 0.05, 0, 0);
    }

    public HyperLogLogPlusPlus(Expression child, Expression relativeSD) {
        this(child, HyperLogLogPlusPlus$.MODULE$.org$apache$spark$sql$catalyst$expressions$aggregate$HyperLogLogPlusPlus$$validateDoubleLiteral(relativeSD), 0, 0);
    }
}

