/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.CacheEntry;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]d!B\u0001\u0003\u0001\u0019a!!H\"mS\u0016tG\u000fR5tiJL'-\u001e;fI\u000e\u000b7\r[3NC:\fw-\u001a:\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7c\u0001\u0001\u000e'A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0004\u0002\u0011%tG/\u001a:oC2L!\u0001G\u000b\u0003\u000f1{wmZ5oO\")!\u0004\u0001C\u00019\u00051A(\u001b8jiz\u001a\u0001\u0001F\u0001\u001e!\tq\u0002!D\u0001\u0003\u0011\u001d\u0001\u0003A1A\u0005\n\u0005\n\u0001\u0003Z5ti\u000e\u000b7\r[3F]R\u0014\u0018.Z:\u0016\u0003\t\u00022a\t\u0015+\u001b\u0005!#BA\u0013'\u0003\u001diW\u000f^1cY\u0016T!aJ\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002*I\tQA*[:u\u0005V4g-\u001a:\u0011\u0005yY\u0013B\u0001\u0017\u0003\u0005)\u0019\u0015m\u00195f\u000b:$(/\u001f\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\u0012\u0002#\u0011L7\u000f^\"bG\",WI\u001c;sS\u0016\u001c\b\u0005C\u00031\u0001\u0011\u0005\u0011'A\u0006bI\u0012\u0014Vm]8ve\u000e,G#\u0003\u001a6}\u0015Su\f\u001a4w!\tq1'\u0003\u00025\u001f\t!QK\\5u\u0011\u00151t\u00061\u00018\u0003\t17\u000f\u0005\u00029y5\t\u0011H\u0003\u00027u)\u00111\bC\u0001\u0007Q\u0006$wn\u001c9\n\u0005uJ$A\u0003$jY\u0016\u001c\u0016p\u001d;f[\")qh\fa\u0001\u0001\u0006!1m\u001c8g!\t\t5)D\u0001C\u0015\ty$(\u0003\u0002E\u0005\ni1i\u001c8gS\u001e,(/\u0019;j_:DQAR\u0018A\u0002\u001d\u000b\u0001\u0002Z3tiB\u000bG\u000f\u001b\t\u0003q!K!!S\u001d\u0003\tA\u000bG\u000f\u001b\u0005\u0006\u0017>\u0002\r\u0001T\u0001\u000fY>\u001c\u0017\r\u001c*fg>,(oY3t!\u0011\u0019Sj\u0014,\n\u00059##a\u0002%bg\"l\u0015\r\u001d\t\u0003!Ns!AD)\n\u0005I{\u0011A\u0002)sK\u0012,g-\u0003\u0002U+\n11\u000b\u001e:j]\u001eT!AU\b\u0011\u0005]kV\"\u0001-\u000b\u0005eS\u0016a\u0002:fG>\u0014Hm\u001d\u0006\u00037r\u000b1!\u00199j\u0015\t\u0019!(\u0003\u0002_1\niAj\\2bYJ+7o\\;sG\u0016DQ\u0001Y\u0018A\u0002\u0005\fAB]3t_V\u00148-\u001a+za\u0016\u0004\"a\u00162\n\u0005\rD&!\u0005'pG\u0006d'+Z:pkJ\u001cW\rV=qK\")Qm\fa\u0001\u001f\u0006!A.\u001b8l\u0011\u00159w\u00061\u0001i\u0003%\u0019H/\u0019;DC\u000eDW\r\u0005\u0003$S.\u001c\u0018B\u00016%\u0005\ri\u0015\r\u001d\t\u0003YFl\u0011!\u001c\u0006\u0003]>\f1A\\3u\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0007U\u0013\u0016\n\u0005\u00029i&\u0011Q/\u000f\u0002\u000b\r&dWm\u0015;biV\u001c\bbB<0!\u0003\u0005\r\u0001_\u0001\u000eCB\u0004X*Y:uKJ|e\u000e\\=\u0011\u00059I\u0018B\u0001>\u0010\u0005\u001d\u0011un\u001c7fC:DQ\u0001 \u0001\u0005\u0002u\f1#\u001e9eCR,7i\u001c8gS\u001e,(/\u0019;j_:$\"A\r@\t\u000b}Z\b\u0019A@\u0011\t\u0005\u0005\u00111A\u0007\u0002\r%\u0019\u0011Q\u0001\u0004\u0003\u0013M\u0003\u0018M]6D_:4\u0007\u0002CA\u0005\u0001\u0011\u0005!!a\u0003\u0002\u001b\u001d,GOV5tS\nLG.\u001b;z)!\ti!a\u0005\u0002\u0016\u0005e\u0001cA,\u0002\u0010%\u0019\u0011\u0011\u0003-\u0003/1{7-\u00197SKN|WO]2f-&\u001c\u0018NY5mSRL\bBB \u0002\b\u0001\u0007\u0001\tC\u0004\u0002\u0018\u0005\u001d\u0001\u0019A6\u0002\u0007U\u0014\u0018\u000e\u0003\u0004h\u0003\u000f\u0001\r\u0001\u001b\u0005\b\u0003;\u0001A\u0011BA\u0010\u0003!I7\u000fU;cY&\u001cGc\u0002=\u0002\"\u0005\r\u0012Q\u0005\u0005\u0007\u007f\u0005m\u0001\u0019\u0001!\t\u000f\u0005]\u00111\u0004a\u0001W\"1q-a\u0007A\u0002!Dq!!\u000b\u0001\t\u0013\tY#A\u0010b]\u000e,7\u000f^8sg\"\u000bg/Z#yK\u000e,H/\u001a)fe6L7o]5p]N$r\u0001_A\u0017\u0003_\t\u0019\u0004\u0003\u00047\u0003O\u0001\ra\u000e\u0005\b\u0003c\t9\u00031\u0001H\u0003\u0011\u0001\u0018\r\u001e5\t\r\u001d\f9\u00031\u0001i\u0011\u001d\t9\u0004\u0001C\u0005\u0003s\tac\u00195fG.\u0004VM]7jgNLwN\\(g\u001fRDWM\u001d\u000b\nq\u0006m\u0012QHA \u0003\u001fBaANA\u001b\u0001\u00049\u0004bBA\u0019\u0003k\u0001\ra\u0012\u0005\t\u0003\u0003\n)\u00041\u0001\u0002D\u00051\u0011m\u0019;j_:\u0004B!!\u0012\u0002L5\u0011\u0011q\t\u0006\u0004\u0003\u0013J\u0014A\u00039fe6L7o]5p]&!\u0011QJA$\u0005!15/Q2uS>t\u0007BB4\u00026\u0001\u0007\u0001\u000e\u0003\u0005\u0002T\u0001!\tAAA+\u000359W\r\u001e$jY\u0016\u001cF/\u0019;vgR91/a\u0016\u0002Z\u0005m\u0003B\u0002\u001c\u0002R\u0001\u0007q\u0007C\u0004\u0002\u0018\u0005E\u0003\u0019A6\t\r\u001d\f\t\u00061\u0001i\u0011%\ty\u0006AI\u0001\n\u0003\t\t'A\u000bbI\u0012\u0014Vm]8ve\u000e,G\u0005Z3gCVdG\u000f\n\u001d\u0016\u0005\u0005\r$f\u0001=\u0002f-\u0012\u0011q\r\t\u0005\u0003S\n\u0019(\u0004\u0002\u0002l)!\u0011QNA8\u0003%)hn\u00195fG.,GMC\u0002\u0002r=\t!\"\u00198o_R\fG/[8o\u0013\u0011\t)(a\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class ClientDistributedCacheManager
implements Logging {
    private final ListBuffer<CacheEntry> distCacheEntries;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    private ListBuffer<CacheEntry> distCacheEntries() {
        return this.distCacheEntries;
    }

    public void addResource(FileSystem fs, Configuration conf, Path destPath, HashMap<String, LocalResource> localResources, LocalResourceType resourceType, String link, Map<URI, FileStatus> statCache, boolean appMasterOnly) {
        FileStatus destStatus = fs.getFileStatus(destPath);
        LocalResource amJarRsrc = (LocalResource)Records.newRecord(LocalResource.class);
        amJarRsrc.setType(resourceType);
        LocalResourceVisibility visibility = this.getVisibility(conf, destPath.toUri(), statCache);
        amJarRsrc.setVisibility(visibility);
        amJarRsrc.setResource(ConverterUtils.getYarnUrlFromPath((Path)destPath));
        amJarRsrc.setTimestamp(destStatus.getModificationTime());
        amJarRsrc.setSize(destStatus.getLen());
        Predef$.MODULE$.require(link != null && new StringOps(Predef$.MODULE$.augmentString(link)).nonEmpty(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "You must specify a valid link name.";
            }
        });
        localResources.update((Object)link, (Object)amJarRsrc);
        if (!appMasterOnly) {
            URI uri = destPath.toUri();
            URI pathURI = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, link);
            this.distCacheEntries().$plus$eq((Object)new CacheEntry(pathURI, destStatus.getLen(), destStatus.getModificationTime(), visibility, resourceType));
        }
    }

    public boolean addResource$default$8() {
        return false;
    }

    public void updateConfiguration(SparkConf conf) {
        conf.set(package$.MODULE$.CACHED_FILES(), this.distCacheEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CacheEntry x$1) {
                return x$1.uri().toString();
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_SIZES(), this.distCacheEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(CacheEntry x$2) {
                return x$2.size();
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TIMESTAMPS(), this.distCacheEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(CacheEntry x$3) {
                return x$3.modTime();
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_VISIBILITIES(), this.distCacheEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CacheEntry x$4) {
                return x$4.visibility().name();
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
        conf.set(package$.MODULE$.CACHED_FILES_TYPES(), this.distCacheEntries().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(CacheEntry x$5) {
                return x$5.resType().name();
            }
        }, ListBuffer$.MODULE$.canBuildFrom()));
    }

    public LocalResourceVisibility getVisibility(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        return this.isPublic(conf, uri, statCache) ? LocalResourceVisibility.PUBLIC : LocalResourceVisibility.PRIVATE;
    }

    private boolean isPublic(Configuration conf, URI uri, Map<URI, FileStatus> statCache) {
        Path current;
        FileSystem fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (this.checkPermissionOfOther(fs, current = new Path(uri.getPath()), FsAction.READ, statCache)) {
            return this.ancestorsHaveExecutePermissions(fs, current.getParent(), statCache);
        }
        return false;
    }

    private boolean ancestorsHaveExecutePermissions(FileSystem fs, Path path, Map<URI, FileStatus> statCache) {
        Path current = path;
        while (true) {
            Path path2;
            if (current == null) {
                return true;
            }
            if (!this.checkPermissionOfOther(fs, path2, FsAction.EXECUTE, statCache)) break;
            path2 = path2.getParent();
        }
        return false;
    }

    private boolean checkPermissionOfOther(FileSystem fs, Path path, FsAction action, Map<URI, FileStatus> statCache) {
        FileStatus status = this.getFileStatus(fs, path.toUri(), statCache);
        FsPermission perms = status.getPermission();
        FsAction otherAction = perms.getOtherAction();
        return otherAction.implies(action);
    }

    public FileStatus getFileStatus(FileSystem fs, URI uri, Map<URI, FileStatus> statCache) {
        Option option;
        block4: {
            FileStatus fileStatus;
            block3: {
                block2: {
                    FileStatus existstat;
                    option = statCache.get((Object)uri);
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    fileStatus = existstat = (FileStatus)some.x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                FileStatus newStat = fs.getFileStatus(new Path(uri));
                statCache.put((Object)uri, (Object)newStat);
                fileStatus = newStat;
            }
            FileStatus stat = fileStatus;
            return stat;
        }
        throw new MatchError((Object)option);
    }

    public ClientDistributedCacheManager() {
        Logging.class.$init$((Logging)this);
        this.distCacheEntries = new ListBuffer();
    }
}

