/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.yarn;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.ContainerLocalityPreferences;
import org.apache.spark.deploy.yarn.LocalityPreferredContainerPlacementStrategy$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!B\u0001\u0003\u0001\ta!a\u000b'pG\u0006d\u0017\u000e^=Qe\u00164WM\u001d:fI\u000e{g\u000e^1j]\u0016\u0014\b\u000b\\1dK6,g\u000e^*ue\u0006$XmZ=\u000b\u0005\r!\u0011\u0001B=be:T!!\u0002\u0004\u0002\r\u0011,\u0007\u000f\\8z\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\u0005\u0001\u0012!B:dC2\f\u0017B\u0001\n\u0010\u0005\u0019\te.\u001f*fM\"AA\u0003\u0001BC\u0002\u0013\u0005a#A\u0005ta\u0006\u00148nQ8oM\u000e\u0001Q#A\f\u0011\u0005aIR\"\u0001\u0004\n\u0005i1!!C*qCJ\\7i\u001c8g\u0011!a\u0002A!A!\u0002\u00139\u0012AC:qCJ\\7i\u001c8gA!Aa\u0004\u0001BC\u0002\u0013\u0005q$\u0001\u0005zCJt7i\u001c8g+\u0005\u0001\u0003CA\u0011'\u001b\u0005\u0011#BA\u0012%\u0003\u0011\u0019wN\u001c4\u000b\u0005\u0015B\u0011A\u00025bI>|\u0007/\u0003\u0002(E\ti1i\u001c8gS\u001e,(/\u0019;j_:D\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\ns\u0006\u0014hnQ8oM\u0002B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001L\u0001\te\u0016\u001cx.\u001e:dKV\tQ\u0006\u0005\u0002/i5\tqF\u0003\u00021c\u00059!/Z2pe\u0012\u001c(B\u0001\u001a4\u0003\r\t\u0007/\u001b\u0006\u0003\u0007\u0011J!!N\u0018\u0003\u0011I+7o\\;sG\u0016D\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I!L\u0001\ne\u0016\u001cx.\u001e:dK\u0002BQ!\u000f\u0001\u0005\u0002i\na\u0001P5oSRtD\u0003B\u001e>}}\u0002\"\u0001\u0010\u0001\u000e\u0003\tAQ\u0001\u0006\u001dA\u0002]AQA\b\u001dA\u0002\u0001BQa\u000b\u001dA\u00025BQ!\u0011\u0001\u0005\u0002\t\u000bQ\u0004\\8dC2LG/_(g%\u0016\fX/Z:uK\u0012\u001cuN\u001c;bS:,'o\u001d\u000b\u0007\u0007&s\u0005\u000b\u00187\u0011\u00079!e)\u0003\u0002F\u001f\t)\u0011I\u001d:bsB\u0011AhR\u0005\u0003\u0011\n\u0011AdQ8oi\u0006Lg.\u001a:M_\u000e\fG.\u001b;z!J,g-\u001a:f]\u000e,7\u000fC\u0003K\u0001\u0002\u00071*\u0001\u0007ok6\u001cuN\u001c;bS:,'\u000f\u0005\u0002\u000f\u0019&\u0011Qj\u0004\u0002\u0004\u0013:$\b\"B(A\u0001\u0004Y\u0015!\u00068v[2{7-\u00197jif\fu/\u0019:f)\u0006\u001c8n\u001d\u0005\u0006#\u0002\u0003\rAU\u0001\u0015Q>\u001cH\u000fV8M_\u000e\fG\u000eV1tW\u000e{WO\u001c;\u0011\tM3\u0016l\u0013\b\u0003\u001dQK!!V\b\u0002\rA\u0013X\rZ3g\u0013\t9\u0006LA\u0002NCBT!!V\b\u0011\u0005MS\u0016BA.Y\u0005\u0019\u0019FO]5oO\")Q\f\u0011a\u0001=\u0006a\u0012\r\u001c7pG\u0006$X\r\u001a%pgR$vnQ8oi\u0006Lg.\u001a:t\u001b\u0006\u0004\b\u0003B0e3\u001al\u0011\u0001\u0019\u0006\u0003C\n\fq!\\;uC\ndWM\u0003\u0002d\u001f\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0015\u0004'a\u0002%bg\"l\u0015\r\u001d\t\u0004?\u001eL\u0017B\u00015a\u0005\r\u0019V\r\u001e\t\u0003])L!a[\u0018\u0003\u0017\r{g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\u0006[\u0002\u0003\rA\\\u0001\"Y>\u001c\u0017\r\\5us6\u000bGo\u00195fIB+g\u000eZ5oO\u0006cGn\\2bi&|gn\u001d\t\u0004_^ThB\u00019v\u001d\t\tH/D\u0001s\u0015\t\u0019X#\u0001\u0004=e>|GOP\u0005\u0002!%\u0011aoD\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0018PA\u0002TKFT!A^\b\u0011\u0007m\fYBD\u0002}\u0003+q1!`A\t\u001d\rq\u0018Q\u0002\b\u0004\u007f\u0006-a\u0002BA\u0001\u0003\u0013qA!a\u0001\u0002\b9\u0019\u0011/!\u0002\n\u0003-I!!\u0003\u0006\n\u0005\u0015B\u0011BA\u0002%\u0013\r\tyaM\u0001\u0007G2LWM\u001c;\n\u0007I\n\u0019BC\u0002\u0002\u0010MJA!a\u0006\u0002\u001a\u0005Q\u0011)\u0014*N\u00072LWM\u001c;\u000b\u0007I\n\u0019\"\u0003\u0003\u0002\u001e\u0005}!\u0001E\"p]R\f\u0017N\\3s%\u0016\fX/Z:u\u0015\u0011\t9\"!\u0007\t\u000f\u0005\r\u0002\u0001\"\u0003\u0002&\u0005\u0019b.^7Fq\u0016\u001cW\u000f^8sgB+g\u000eZ5oOR\u00191*a\n\t\u000f\u0005%\u0012\u0011\u0005a\u0001\u0017\u0006ya.^7UCN\\7\u000fU3oI&tw\rC\u0004\u0002.\u0001!I!a\f\u00029\u0015D\b/Z2uK\u0012Dun\u001d;U_\u000e{g\u000e^1j]\u0016\u00148i\\;oiRI!+!\r\u00026\u0005]\u0012\u0011\b\u0005\b\u0003g\tY\u00031\u0001L\u0003IawnY1mSRL\u0018i^1sKR\u000b7o[:\t\rE\u000bY\u00031\u0001S\u0011\u0019i\u00161\u0006a\u0001=\"1Q.a\u000bA\u00029Dq!!\u0010\u0001\t\u0013\ty$A\u000eqK:$\u0017N\\4I_N$Hk\\\"p]R\f\u0017N\\3s\u0007>,h\u000e\u001e\u000b\u0005\u0003\u0003\nI\u0005E\u0003T-f\u000b\u0019\u0005E\u0002\u000f\u0003\u000bJ1!a\u0012\u0010\u0005\u0019!u.\u001e2mK\"1Q.a\u000fA\u00029\u0004")
public class LocalityPreferredContainerPlacementStrategy {
    private final SparkConf sparkConf;
    private final Configuration yarnConf;
    private final Resource resource;

    public SparkConf sparkConf() {
        return this.sparkConf;
    }

    public Configuration yarnConf() {
        return this.yarnConf;
    }

    public Resource resource() {
        return this.resource;
    }

    public ContainerLocalityPreferences[] localityOfRequestedContainers(int numContainer, int numLocalityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        Map<String, Object> updatedHostToContainerCount = this.expectedHostToContainerCount(numLocalityAwareTasks, hostToLocalTaskCount, allocatedHostToContainersMap, localityMatchedPendingAllocations);
        int updatedLocalityAwareContainerNum = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int requiredLocalityFreeContainerNum = package$.MODULE$.max(0, numContainer - updatedLocalityAwareContainerNum);
        int requiredLocalityAwareContainerNum = numContainer - requiredLocalityFreeContainerNum;
        ArrayBuffer containerLocalityPreferences = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (requiredLocalityFreeContainerNum > 0) {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityFreeContainerNum).foreach((Function1)new Serializable(this, containerLocalityPreferences){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer containerLocalityPreferences$1;

                public final ArrayBuffer<ContainerLocalityPreferences> apply(int i) {
                    return this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(null, null));
                }
                {
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                }
            });
        }
        if (requiredLocalityAwareContainerNum > 0) {
            int largestRatio = BoxesRunTime.unboxToInt((Object)updatedHostToContainerCount.values().max((Ordering)Ordering.Int$.MODULE$));
            ObjectRef preferredLocalityRatio = new ObjectRef((Object)updatedHostToContainerCount.mapValues((Function1)new Serializable(this, requiredLocalityAwareContainerNum, largestRatio){
                public static final long serialVersionUID = 0L;
                private final int requiredLocalityAwareContainerNum$1;
                private final int largestRatio$1;

                public final int apply(int ratio) {
                    return this.apply$mcII$sp(ratio);
                }

                public int apply$mcII$sp(int ratio) {
                    double adjustedRatio = (double)ratio * (double)this.requiredLocalityAwareContainerNum$1 / (double)this.largestRatio$1;
                    return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(adjustedRatio));
                }
                {
                    this.requiredLocalityAwareContainerNum$1 = requiredLocalityAwareContainerNum$1;
                    this.largestRatio$1 = largestRatio$1;
                }
            }));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), requiredLocalityAwareContainerNum).foreach$mVc$sp((Function1)new Serializable(this, containerLocalityPreferences, preferredLocalityRatio){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
                private final ArrayBuffer containerLocalityPreferences$1;
                private final ObjectRef preferredLocalityRatio$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    String[] hosts = (String[])((MapLike)((Map)this.preferredLocalityRatio$1.elem).filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(Tuple2<String, Object> x$1) {
                            return x$1._2$mcI$sp() > 0;
                        }
                    })).keys().toArray(ClassTag$.MODULE$.apply(String.class));
                    scala.collection.immutable.Set racks = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hosts).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$localityOfRequestedContainers$1 $outer;

                        public final String apply(String h) {
                            return RackResolver.resolve((Configuration)this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer().yarnConf(), (String)h).getNetworkLocation();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
                    this.containerLocalityPreferences$1.$plus$eq((Object)new ContainerLocalityPreferences(hosts, (String[])racks.toArray(ClassTag$.MODULE$.apply(String.class))));
                    this.preferredLocalityRatio$1.elem = ((Map)this.preferredLocalityRatio$1.elem).mapValues((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(int x$2) {
                            return this.apply$mcII$sp(x$2);
                        }

                        public int apply$mcII$sp(int x$2) {
                            return x$2 - 1;
                        }
                    });
                }

                public /* synthetic */ LocalityPreferredContainerPlacementStrategy org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.containerLocalityPreferences$1 = containerLocalityPreferences$1;
                    this.preferredLocalityRatio$1 = preferredLocalityRatio$1;
                }
            });
        }
        return (ContainerLocalityPreferences[])containerLocalityPreferences.toArray(ClassTag$.MODULE$.apply(ContainerLocalityPreferences.class));
    }

    public int org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(int numTasksPending) {
        int coresPerExecutor = this.resource().getVirtualCores();
        return (numTasksPending * BoxesRunTime.unboxToInt((Object)this.sparkConf().get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK())) + coresPerExecutor - 1) / coresPerExecutor;
    }

    private Map<String, Object> expectedHostToContainerCount(int localityAwareTasks, Map<String, Object> hostToLocalTaskCount, HashMap<String, Set<ContainerId>> allocatedHostToContainersMap, Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        int totalLocalTaskNum = BoxesRunTime.unboxToInt((Object)hostToLocalTaskCount.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Map<String, Object> pendingHostToContainersMap = this.pendingHostToContainerCount(localityMatchedPendingAllocations);
        return (Map)hostToLocalTaskCount.map((Function1)new Serializable(this, localityAwareTasks, allocatedHostToContainersMap, totalLocalTaskNum, pendingHostToContainersMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LocalityPreferredContainerPlacementStrategy $outer;
            private final int localityAwareTasks$1;
            private final HashMap allocatedHostToContainersMap$1;
            private final int totalLocalTaskNum$1;
            private final Map pendingHostToContainersMap$1;

            public final Tuple2<String, Object> apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String host = (String)tuple2._1();
                    int count = tuple2._2$mcI$sp();
                    double expectedCount = (double)count * (double)this.$outer.org$apache$spark$deploy$yarn$LocalityPreferredContainerPlacementStrategy$$numExecutorsPending(this.localityAwareTasks$1) / (double)this.totalLocalTaskNum$1;
                    double existedCount = (double)BoxesRunTime.unboxToInt((Object)this.allocatedHostToContainersMap$1.get((Object)host).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply(Set<ContainerId> x$3) {
                            return x$3.size();
                        }
                    }).getOrElse((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return 0;
                        }
                    })) + BoxesRunTime.unboxToDouble((Object)this.pendingHostToContainersMap$1.getOrElse((Object)host, (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 0.0;
                        }
                    }));
                    Tuple2 tuple22 = new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)package$.MODULE$.max(0, (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(expectedCount - existedCount)))));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.localityAwareTasks$1 = localityAwareTasks$1;
                this.allocatedHostToContainersMap$1 = allocatedHostToContainersMap$1;
                this.totalLocalTaskNum$1 = totalLocalTaskNum$1;
                this.pendingHostToContainersMap$1 = pendingHostToContainersMap$1;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    private Map<String, Object> pendingHostToContainerCount(Seq<AMRMClient.ContainerRequest> localityMatchedPendingAllocations) {
        HashMap pendingHostToContainerCount2 = new HashMap();
        localityMatchedPendingAllocations.foreach((Function1)new Serializable(this, pendingHostToContainerCount2){
            public static final long serialVersionUID = 0L;
            public final HashMap pendingHostToContainerCount$1;

            public final void apply(AMRMClient.ContainerRequest cr) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(cr.getNodes()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$pendingHostToContainerCount$2 $outer;

                    public final void apply(String n) {
                        int count = BoxesRunTime.unboxToInt((Object)this.$outer.pendingHostToContainerCount$1.getOrElse((Object)n, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final int apply() {
                                return this.apply$mcI$sp();
                            }

                            public int apply$mcI$sp() {
                                return 0;
                            }
                        })) + 1;
                        this.$outer.pendingHostToContainerCount$1.update((Object)n, (Object)BoxesRunTime.boxToInteger((int)count));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.pendingHostToContainerCount$1 = pendingHostToContainerCount$1;
            }
        });
        int possibleTotalContainerNum = BoxesRunTime.unboxToInt((Object)pendingHostToContainerCount2.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        double localityMatchedPendingNum = localityMatchedPendingAllocations.size();
        return pendingHostToContainerCount2.mapValues((Function1)new Serializable(this, possibleTotalContainerNum, localityMatchedPendingNum){
            public static final long serialVersionUID = 0L;
            private final int possibleTotalContainerNum$1;
            private final double localityMatchedPendingNum$1;

            public final double apply(int x$4) {
                return this.apply$mcDI$sp(x$4);
            }

            public double apply$mcDI$sp(int x$4) {
                return (double)x$4 * this.localityMatchedPendingNum$1 / (double)this.possibleTotalContainerNum$1;
            }
            {
                this.possibleTotalContainerNum$1 = possibleTotalContainerNum$1;
                this.localityMatchedPendingNum$1 = localityMatchedPendingNum$1;
            }
        }).toMap(Predef$.MODULE$.conforms());
    }

    public LocalityPreferredContainerPlacementStrategy(SparkConf sparkConf, Configuration yarnConf, Resource resource) {
        this.sparkConf = sparkConf;
        this.yarnConf = yarnConf;
        this.resource = resource;
    }
}

