/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ConcurrentDateFormat;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractResource
implements WebResource {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.webresources");
    private final WebResourceRoot root;
    private final String webAppPath;
    private String mimeType = null;
    private volatile String weakETag;

    protected AbstractResource(WebResourceRoot root, String webAppPath) {
        this.root = root;
        this.webAppPath = webAppPath;
    }

    @Override
    public final WebResourceRoot getWebResourceRoot() {
        return this.root;
    }

    @Override
    public final String getWebappPath() {
        return this.webAppPath;
    }

    @Override
    public final String getLastModifiedHttp() {
        return ConcurrentDateFormat.formatRfc1123(new Date(this.getLastModified()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getETag() {
        if (this.weakETag == null) {
            AbstractResource abstractResource = this;
            synchronized (abstractResource) {
                if (this.weakETag == null) {
                    long contentLength = this.getContentLength();
                    long lastModified = this.getLastModified();
                    if (contentLength >= 0L || lastModified >= 0L) {
                        this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                }
            }
        }
        return this.weakETag;
    }

    @Override
    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public final String getMimeType() {
        return this.mimeType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final byte[] getContent() {
        long len = this.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("abstractResource.getContentTooLarge", new Object[]{this.getWebappPath(), len}));
        }
        int size = (int)len;
        byte[] result = new byte[size];
        int pos = 0;
        try (InputStream is = this.getInputStream();){
            if (is == null) {
                byte[] byArray = null;
                return byArray;
            }
            while (pos < size) {
                int n = is.read(result, pos, size - pos);
                if (n < 0) {
                    return result;
                }
                pos += n;
            }
            return result;
        }
        catch (IOException ioe) {
            if (!this.getLog().isDebugEnabled()) return result;
            this.getLog().debug((Object)sm.getString("abstractResource.getContentFail", new Object[]{this.getWebappPath()}), (Throwable)ioe);
        }
        return result;
    }

    protected abstract Log getLog();
}

