/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.apache.tomcat.util.buf.AbstractChunk;
import org.apache.tomcat.util.buf.Ascii;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.StringCache;

public final class ByteChunk
extends AbstractChunk {
    private static final long serialVersionUID = 1L;
    public static final Charset DEFAULT_CHARSET = B2CConverter.ISO_8859_1;
    private transient Charset charset;
    private byte[] buff;
    private transient ByteInputChannel in = null;
    private transient ByteOutputChannel out = null;
    private boolean optimizedWrite = true;

    public ByteChunk() {
    }

    public ByteChunk(int initial) {
        this.allocate(initial, -1);
    }

    @Deprecated
    public ByteChunk getClone() {
        try {
            return (ByteChunk)this.clone();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeUTF(this.getCharset().name());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.charset = Charset.forName(ois.readUTF());
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.charset = null;
    }

    public void reset() {
        this.buff = null;
    }

    public void allocate(int initial, int limit) {
        if (this.buff == null || this.buff.length < initial) {
            this.buff = new byte[initial];
        }
        this.setLimit(limit);
        this.start = 0;
        this.end = 0;
        this.isSet = true;
        this.hasHashCode = false;
    }

    public void setBytes(byte[] b, int off, int len) {
        this.buff = b;
        this.start = off;
        this.end = this.start + len;
        this.isSet = true;
        this.hasHashCode = false;
    }

    @Deprecated
    public void setOptimizedWrite(boolean optimizedWrite) {
        this.optimizedWrite = optimizedWrite;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public Charset getCharset() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        return this.charset;
    }

    public byte[] getBytes() {
        return this.getBuffer();
    }

    public byte[] getBuffer() {
        return this.buff;
    }

    public void setByteInputChannel(ByteInputChannel in) {
        this.in = in;
    }

    public void setByteOutputChannel(ByteOutputChannel out) {
        this.out = out;
    }

    @Deprecated
    public void append(char c) throws IOException {
        this.append((byte)c);
    }

    public void append(byte b) throws IOException {
        this.makeSpace(1);
        int limit = this.getLimitInternal();
        if (this.end >= limit) {
            this.flushBuffer();
        }
        this.buff[this.end++] = b;
    }

    public void append(ByteChunk src) throws IOException {
        this.append(src.getBytes(), src.getStart(), src.getLength());
    }

    public void append(byte[] src, int off, int len) throws IOException {
        int remain;
        this.makeSpace(len);
        int limit = this.getLimitInternal();
        if (this.optimizedWrite && len == limit && this.end == this.start && this.out != null) {
            this.out.realWriteBytes(src, off, len);
            return;
        }
        if (len <= limit - this.end) {
            System.arraycopy(src, off, this.buff, this.end, len);
            this.end += len;
            return;
        }
        int avail = limit - this.end;
        System.arraycopy(src, off, this.buff, this.end, avail);
        this.end += avail;
        this.flushBuffer();
        for (remain = len - avail; remain > limit - this.end; remain -= limit - this.end) {
            this.out.realWriteBytes(src, off + len - remain, limit - this.end);
        }
        System.arraycopy(src, off + len - remain, this.buff, this.end, remain);
        this.end += remain;
    }

    public int substract() throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        return this.buff[this.start++] & 0xFF;
    }

    @Deprecated
    public int substract(ByteChunk src) throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return -1;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return -1;
            }
        }
        int len = this.getLength();
        src.append(this.buff, this.start, len);
        this.start = this.end;
        return len;
    }

    public byte substractB() throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        return this.buff[this.start++];
    }

    public int substract(byte[] dest, int off, int len) throws IOException {
        if (this.checkEof()) {
            return -1;
        }
        int n = len;
        if (len > this.getLength()) {
            n = this.getLength();
        }
        System.arraycopy(this.buff, this.start, dest, off, n);
        this.start += n;
        return n;
    }

    private boolean checkEof() throws IOException {
        if (this.end - this.start == 0) {
            if (this.in == null) {
                return true;
            }
            int n = this.in.realReadBytes(this.buff, 0, this.buff.length);
            if (n < 0) {
                return true;
            }
        }
        return false;
    }

    public void flushBuffer() throws IOException {
        if (this.out == null) {
            throw new IOException("Buffer overflow, no sink " + this.getLimit() + " " + this.buff.length);
        }
        this.out.realWriteBytes(this.buff, this.start, this.end - this.start);
        this.end = this.start;
    }

    public void makeSpace(int count) {
        byte[] tmp = null;
        long desiredSize = this.end + count;
        int limit = this.getLimitInternal();
        if (desiredSize > (long)limit) {
            desiredSize = limit;
        }
        if (this.buff == null) {
            if (desiredSize < 256L) {
                desiredSize = 256L;
            }
            this.buff = new byte[(int)desiredSize];
        }
        if (desiredSize <= (long)this.buff.length) {
            return;
        }
        long newSize = desiredSize < 2L * (long)this.buff.length ? (long)this.buff.length * 2L : (long)this.buff.length * 2L + (long)count;
        if (newSize > (long)limit) {
            newSize = limit;
        }
        tmp = new byte[(int)newSize];
        System.arraycopy(this.buff, this.start, tmp, 0, this.end - this.start);
        this.buff = tmp;
        tmp = null;
        this.end -= this.start;
        this.start = 0;
    }

    public String toString() {
        if (null == this.buff) {
            return null;
        }
        if (this.end - this.start == 0) {
            return "";
        }
        return StringCache.toString(this);
    }

    public String toStringInternal() {
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
        CharBuffer cb = this.charset.decode(ByteBuffer.wrap(this.buff, this.start, this.end - this.start));
        return new String(cb.array(), cb.arrayOffset(), cb.length());
    }

    @Deprecated
    public int getInt() {
        return Ascii.parseInt(this.buff, this.start, this.end - this.start);
    }

    public long getLong() {
        return Ascii.parseLong(this.buff, this.start, this.end - this.start);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ByteChunk) {
            return this.equals((ByteChunk)obj);
        }
        return false;
    }

    public boolean equals(String s) {
        byte[] b = this.buff;
        int len = this.end - this.start;
        if (b == null || len != s.length()) {
            return false;
        }
        int off = this.start;
        for (int i = 0; i < len; ++i) {
            if (b[off++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String s) {
        byte[] b = this.buff;
        int len = this.end - this.start;
        if (b == null || len != s.length()) {
            return false;
        }
        int off = this.start;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(b[off++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public boolean equals(ByteChunk bb) {
        return this.equals(bb.getBytes(), bb.getStart(), bb.getLength());
    }

    public boolean equals(byte[] b2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (len != len2 || b1 == null || b2 == null) {
            return false;
        }
        int off1 = this.start;
        while (len-- > 0) {
            if (b1[off1++] == b2[off2++]) continue;
            return false;
        }
        return true;
    }

    public boolean equals(CharChunk cc) {
        return this.equals(cc.getChars(), cc.getStart(), cc.getLength());
    }

    public boolean equals(char[] c2, int off2, int len2) {
        byte[] b1 = this.buff;
        if (c2 == null && b1 == null) {
            return true;
        }
        if (b1 == null || c2 == null || this.end - this.start != len2) {
            return false;
        }
        int off1 = this.start;
        int len = this.end - this.start;
        while (len-- > 0) {
            if ((char)b1[off1++] == c2[off2++]) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean startsWith(String s) {
        byte[] b = this.buff;
        int blen = s.length();
        if (b == null || blen > this.end - this.start) {
            return false;
        }
        int boff = this.start;
        for (int i = 0; i < blen; ++i) {
            if (b[boff++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public boolean startsWith(byte[] b2) {
        byte[] b1 = this.buff;
        if (b1 == null && b2 == null) {
            return true;
        }
        int len = this.end - this.start;
        if (b1 == null || b2 == null || b2.length > len) {
            return false;
        }
        int i = this.start;
        int j = 0;
        while (i < this.end && j < b2.length) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s, int pos) {
        byte[] b = this.buff;
        int len = s.length();
        if (b == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (b[off++] == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWithIgnoreCase(String s, int pos) {
        byte[] b = this.buff;
        int len = s.length();
        if (b == null || len + pos > this.end - this.start) {
            return false;
        }
        int off = this.start + pos;
        for (int i = 0; i < len; ++i) {
            if (Ascii.toLower(b[off++]) == Ascii.toLower(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getBufferElement(int index) {
        return this.buff[index];
    }

    @Deprecated
    public int hashIgnoreCase() {
        return ByteChunk.hashBytesIC(this.buff, this.start, this.end - this.start);
    }

    private static int hashBytesIC(byte[] bytes, int start, int bytesLen) {
        int max = start + bytesLen;
        byte[] bb = bytes;
        int code = 0;
        for (int i = start; i < max; ++i) {
            code = code * 37 + Ascii.toLower(bb[i]);
        }
        return code;
    }

    public int indexOf(char c, int starting) {
        int ret = ByteChunk.indexOf(this.buff, this.start + starting, this.end, c);
        return ret >= this.start ? ret - this.start : -1;
    }

    public static int indexOf(byte[] bytes, int start, int end, char s) {
        for (int offset = start; offset < end; ++offset) {
            byte b = bytes[offset];
            if (b != s) continue;
            return offset;
        }
        return -1;
    }

    public static int findByte(byte[] bytes, int start, int end, byte b) {
        for (int offset = start; offset < end; ++offset) {
            if (bytes[offset] != b) continue;
            return offset;
        }
        return -1;
    }

    public static int findBytes(byte[] bytes, int start, int end, byte[] b) {
        int blen = b.length;
        for (int offset = start; offset < end; ++offset) {
            for (int i = 0; i < blen; ++i) {
                if (bytes[offset] != b[i]) continue;
                return offset;
            }
        }
        return -1;
    }

    @Deprecated
    public static int findNotBytes(byte[] bytes, int start, int end, byte[] b) {
        int blen = b.length;
        for (int offset = start; offset < end; ++offset) {
            boolean found = true;
            for (int i = 0; i < blen; ++i) {
                if (bytes[offset] != b[i]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return offset;
        }
        return -1;
    }

    public static final byte[] convertToBytes(String value) {
        byte[] result = new byte[value.length()];
        for (int i = 0; i < value.length(); ++i) {
            result[i] = (byte)value.charAt(i);
        }
        return result;
    }

    public static interface ByteOutputChannel {
        public void realWriteBytes(byte[] var1, int var2, int var3) throws IOException;
    }

    public static interface ByteInputChannel {
        public int realReadBytes(byte[] var1, int var2, int var3) throws IOException;
    }
}

