/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.maven.log;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.asciidoctor.log.LogHandler;
import org.asciidoctor.log.LogRecord;
import org.asciidoctor.log.Severity;
import org.asciidoctor.maven.log.LogRecordHelper;

public class MemoryLogHandler
implements LogHandler {
    final List<LogRecord> records = new ArrayList<LogRecord>();
    private final Boolean outputToConsole;
    private final File sourceDirectory;
    private final Log log;

    public MemoryLogHandler(Boolean outputToConsole, File sourceDirectory, Log log) {
        this.outputToConsole = outputToConsole == null ? Boolean.FALSE : outputToConsole;
        this.sourceDirectory = sourceDirectory;
        this.log = log;
    }

    public void log(LogRecord logRecord) {
        this.records.add(logRecord);
        if (this.outputToConsole.booleanValue()) {
            this.log.info((CharSequence)LogRecordHelper.format(logRecord, this.sourceDirectory));
        }
    }

    public void clear() {
        this.records.clear();
    }

    public List<LogRecord> filter(Severity severity) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (record.getSeverity().getRubyId() < severity.getRubyId()) continue;
            records.add(record);
        }
        return records;
    }

    public List<LogRecord> filter(String text) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (!record.getMessage().contains(text)) continue;
            records.add(record);
        }
        return records;
    }

    public List<LogRecord> filter(Severity severity, String text) {
        ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        for (LogRecord record : this.records) {
            if (record.getSeverity().getRubyId() < severity.getRubyId() || !record.getMessage().contains(text)) continue;
            records.add(record);
        }
        return records;
    }
}

