/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module.util;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.ballerinalang.cli.module.util.ErrorUtil;

public class Utils {
    public static Proxy getProxy(String proxyHost, int proxyPort, final String proxyUsername, final String proxyPassword) {
        if (!"".equals(proxyHost)) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxyHost, proxyPort);
            if (!"".equals(proxyUsername) && "".equals(proxyPassword)) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUsername, proxyPassword.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            return new Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }

    public static URL convertToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    public static HttpsURLConnection createHttpsUrlConnection(URL url, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) {
        try {
            Proxy proxy = Utils.getProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
            if (proxy == null) {
                return (HttpsURLConnection)url.openConnection();
            }
            return (HttpsURLConnection)url.openConnection(proxy);
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    public static void setRequestMethod(HttpsURLConnection conn, RequestMethod method) {
        try {
            conn.setRequestMethod(Utils.getRequestMethodAsString(method));
        }
        catch (ProtocolException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    private static String getRequestMethodAsString(RequestMethod method) {
        switch (method) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "POST";
            }
        }
        throw ErrorUtil.createCommandException("invalid request method:" + (Object)((Object)method));
    }

    public static int getStatusCode(HttpsURLConnection conn) {
        try {
            return conn.getResponseCode();
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException("connection to the remote repository host failed: " + e.getMessage());
        }
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

