/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Authenticator;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.net.ssl.HttpsURLConnection;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.ballerinalang.cli.module.util.ErrorUtil;
import org.ballerinalang.cli.module.util.Utils;
import org.ballerinalang.jvm.JSONParser;
import org.ballerinalang.jvm.values.MapValue;

public class Push {
    private static PrintStream errStream = System.err;
    private static PrintStream outStream = System.out;
    private static final int NO_OF_BYTES = 64;
    private static final int BUFFER_SIZE = 65536;

    private Push() {
    }

    public static void execute(String url, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String accessToken, String orgName, String moduleName, String version, Path baloPath) {
        HttpsURLConnection conn = Utils.createHttpsUrlConnection(Utils.convertToUrl(url), proxyHost, proxyPort, proxyUsername, proxyPassword);
        conn.setInstanceFollowRedirects(false);
        Utils.setRequestMethod(conn, Utils.RequestMethod.POST);
        conn.setRequestProperty("Authorization", "Bearer " + accessToken);
        conn.setRequestProperty("Push-Organization", orgName);
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(65536);
        try (DataOutputStream outputStream = new DataOutputStream(conn.getOutputStream());){
            byte[] buffer = new byte[65536];
            try (ProgressBar progressBar = new ProgressBar(orgName + "/" + moduleName + ":" + version + " [project repo -> central]", Push.getTotalFileSizeInKB(baloPath), 1000, outStream, ProgressBarStyle.ASCII, " KB", 1L);
                 FileInputStream fis = new FileInputStream(baloPath.toFile());){
                int count;
                while ((count = fis.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, count);
                    outputStream.flush();
                    progressBar.stepBy(64L);
                }
            }
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException("error occurred while uploading balo to central: " + e.getMessage());
        }
        Push.handleResponse(conn, orgName, moduleName, version);
        Authenticator.setDefault(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleResponse(HttpsURLConnection conn, String orgName, String moduleName, String version) {
        block22: {
            try {
                int statusCode = Utils.getStatusCode(conn);
                if (statusCode == 200) {
                    outStream.println(orgName + "/" + moduleName + ":" + version + " pushed to central successfully");
                    break block22;
                }
                if (statusCode == 401) {
                    errStream.println("unauthorized access token for organization: " + orgName);
                    break block22;
                }
                if (statusCode == 400) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));){
                        String line;
                        StringBuilder result = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            result.append(line);
                        }
                        MapValue payload = (MapValue)JSONParser.parse((String)result.toString());
                        String message = payload.getStringValue("message");
                        if (message.contains("module md file cannot be empty")) {
                            errStream.println(message);
                            break block22;
                        }
                        throw ErrorUtil.createCommandException(message);
                    }
                    catch (IOException e) {
                        throw ErrorUtil.createCommandException("failed to push the module '" + orgName + "/" + moduleName + ":" + version + "' to the remote repository '" + conn.getURL() + "'");
                    }
                }
                throw ErrorUtil.createCommandException("failed to push the module '" + orgName + "/" + moduleName + ":" + version + "' to the remote repository '" + conn.getURL() + "'");
            }
            finally {
                conn.disconnect();
            }
        }
    }

    private static long getTotalFileSizeInKB(Path filePath) {
        try {
            byte[] baloContent = Files.readAllBytes(filePath);
            return baloContent.length / 1024;
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException("cannot read the balo content");
        }
    }
}

