/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module.util;

import java.io.IOException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.ballerinalang.cli.module.util.ErrorUtil;

public class Utils {
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static Proxy getProxy(String proxyHost, int proxyPort, final String proxyUsername, final String proxyPassword) {
        if (!"".equals(proxyHost)) {
            InetSocketAddress proxyInet = new InetSocketAddress(proxyHost, proxyPort);
            if (!"".equals(proxyUsername) && "".equals(proxyPassword)) {
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(proxyUsername, proxyPassword.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            return new Proxy(Proxy.Type.HTTP, proxyInet);
        }
        return null;
    }

    public static URL convertToUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    public static void initializeSsl() {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw ErrorUtil.createCommandException("initializing SSL failed: " + e.getMessage());
        }
    }

    public static HttpURLConnection createHttpUrlConnection(URL url, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword) {
        try {
            Proxy proxy = Utils.getProxy(proxyHost, proxyPort, proxyUsername, proxyPassword);
            if (proxy == null) {
                return (HttpURLConnection)url.openConnection();
            }
            return (HttpURLConnection)url.openConnection(proxy);
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    public static void setRequestMethod(HttpURLConnection conn, RequestMethod method) {
        try {
            conn.setRequestMethod(Utils.getRequestMethodAsString(method));
        }
        catch (ProtocolException e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
    }

    private static String getRequestMethodAsString(RequestMethod method) {
        switch (method) {
            case GET: {
                return "GET";
            }
            case POST: {
                return "POST";
            }
        }
        throw ErrorUtil.createCommandException("invalid request method:" + (Object)((Object)method));
    }

    public static int getStatusCode(HttpURLConnection conn) {
        try {
            return conn.getResponseCode();
        }
        catch (IOException e) {
            throw ErrorUtil.createCommandException("connection to the remote repository host failed: " + e.getMessage());
        }
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

