/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre;

import java.util.Map;
import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.WorkerData;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.natives.exceptions.ArgumentOutOfRangeException;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.exceptions.BLangNullReferenceException;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.LocalTransactionInfo;

public class NativeCallContext
implements Context {
    private WorkerExecutionContext parentCtx;
    private CallableUnitInfo callableUnitInfo;
    private WorkerData workerLocal;
    private BValue[] returnValues;

    public NativeCallContext(WorkerExecutionContext parentCtx, CallableUnitInfo callableUnitInfo, WorkerData workerLocal) {
        this.parentCtx = parentCtx;
        this.callableUnitInfo = callableUnitInfo;
        this.workerLocal = workerLocal;
    }

    @Override
    public WorkerExecutionContext getParentWorkerExecutionContext() {
        return this.parentCtx;
    }

    @Override
    public CallableUnitInfo getCallableUnitInfo() {
        return this.callableUnitInfo;
    }

    @Override
    public WorkerData getLocalWorkerData() {
        return this.workerLocal;
    }

    @Override
    public DebugContext getDebugContext() {
        return null;
    }

    @Override
    public void setDebugContext(DebugContext debugContext) {
    }

    @Override
    public Object getProperty(String key) {
        return this.parentCtx.globalProps.get(key);
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.parentCtx.globalProps;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.parentCtx.globalProps.put(key, value);
    }

    @Override
    public ServiceInfo getServiceInfo() {
        return BLangVMUtils.getServiceInfo(this.parentCtx);
    }

    @Override
    public void setServiceInfo(ServiceInfo serviceInfo) {
        BLangVMUtils.setServiceInfo(this.parentCtx, serviceInfo);
    }

    @Override
    public boolean isInTransaction() {
        return this.parentCtx.isInTransaction();
    }

    @Override
    public BStruct getError() {
        return this.parentCtx.getError();
    }

    @Override
    public void setError(BStruct error) {
        this.parentCtx.setError(error);
    }

    @Override
    public ProgramFile getProgramFile() {
        return this.parentCtx.programFile;
    }

    @Override
    public long getIntArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.workerLocal.longRegs[index];
    }

    @Override
    public String getStringArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        String str = this.workerLocal.stringRegs[index];
        if (str == null) {
            throw new BLangNullReferenceException();
        }
        return str;
    }

    @Override
    public String getNullableStringArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.workerLocal.stringRegs[index];
    }

    @Override
    public double getFloatArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.workerLocal.doubleRegs[index];
    }

    @Override
    public boolean getBooleanArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.workerLocal.intRegs[index] == 1;
    }

    @Override
    public byte[] getBlobArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        byte[] result = this.workerLocal.byteRegs[index];
        if (result == null) {
            throw new BallerinaException("argument " + index + " is null");
        }
        return result;
    }

    @Override
    public BValue getRefArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        BRefType<?> result = this.workerLocal.refRegs[index];
        if (result == null) {
            throw new BallerinaException("argument " + index + " is null");
        }
        return result;
    }

    @Override
    public BValue getNullableRefArgument(int index) {
        if (index < 0) {
            throw new ArgumentOutOfRangeException(index);
        }
        return this.workerLocal.refRegs[index];
    }

    @Override
    public BValue[] getReturnValues() {
        return this.returnValues;
    }

    @Override
    public void setReturnValues(BValue ... values) {
        this.returnValues = values;
    }

    @Override
    public LocalTransactionInfo getLocalTransactionInfo() {
        return this.parentCtx.getLocalTransactionInfo();
    }
}

