/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BConnector;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.StructureType;
import org.ballerinalang.util.codegen.ConnectorInfo;
import org.ballerinalang.util.codegen.LocalVariableInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.LocalVariableAttributeInfo;

public class BLangVMStructs {
    public static BStruct createBStruct(StructInfo structInfo, Object ... values) {
        BStructType structType = structInfo.getType();
        BStruct bStruct = new BStruct(structType);
        int[] indexes = new int[]{-1, -1, -1, -1, -1, -1};
        BStructType.StructField[] structFields = structType.getStructFields();
        for (int i = 0; i < structFields.length && values.length >= i + 1; ++i) {
            BType paramType = structFields[i].getFieldType();
            BLangVMStructs.setValue(bStruct, indexes, paramType.getTag(), values[i]);
        }
        return bStruct;
    }

    public static BConnector createBConnector(ConnectorInfo connectorInfo, Object ... values) {
        BConnector bConnector = new BConnector(connectorInfo.getType());
        LocalVariableAttributeInfo localVar = (LocalVariableAttributeInfo)connectorInfo.getAttributeInfo(AttributeInfo.Kind.LOCAL_VARIABLES_ATTRIBUTE);
        int i = 0;
        int[] indexes = new int[]{-1, -1, -1, -1, -1, -1};
        for (LocalVariableInfo variableInfo : localVar.getLocalVariables()) {
            if (values.length < i + 1) break;
            BType varType = variableInfo.getVariableType();
            BLangVMStructs.setValue(bConnector, indexes, varType.getTag(), values[i]);
        }
        return bConnector;
    }

    private static void setValue(StructureType structureType, int[] regIndexes, int typeTag, Object value) {
        switch (typeTag) {
            case 1: {
                int index = regIndexes[0] = regIndexes[0] + 1;
                if (value == null) break;
                if (value instanceof Integer) {
                    structureType.setIntField(index, ((Integer)value).intValue());
                    break;
                }
                if (value instanceof Long) {
                    structureType.setIntField(index, (Long)value);
                    break;
                }
                if (!(value instanceof BInteger)) break;
                structureType.setIntField(index, ((BInteger)value).intValue());
                break;
            }
            case 2: {
                int index = regIndexes[1] = regIndexes[1] + 1;
                if (value == null) break;
                if (value instanceof Float) {
                    structureType.setFloatField(index, ((Float)value).floatValue());
                    break;
                }
                if (value instanceof Double) {
                    structureType.setFloatField(index, (Double)value);
                    break;
                }
                if (!(value instanceof BFloat)) break;
                structureType.setFloatField(index, ((BFloat)value).floatValue());
                break;
            }
            case 3: {
                int index = regIndexes[2] = regIndexes[2] + 1;
                if (value == null) break;
                if (value instanceof String) {
                    structureType.setStringField(index, (String)value);
                    break;
                }
                if (!(value instanceof BValue)) break;
                structureType.setStringField(index, ((BValue)value).stringValue());
                break;
            }
            case 4: {
                int index = regIndexes[3] = regIndexes[3] + 1;
                if (value == null) break;
                if (value instanceof Boolean) {
                    structureType.setBooleanField(index, (Boolean)value != false ? 1 : 0);
                    break;
                }
                if (!(value instanceof BBoolean)) break;
                structureType.setBooleanField(index, ((BBoolean)value).booleanValue() ? 1 : 0);
                break;
            }
            case 5: {
                int index = regIndexes[4] = regIndexes[4] + 1;
                if (value == null || !(value instanceof BBlob)) break;
                structureType.setBlobField(index, ((BBlob)value).blobValue());
                break;
            }
            default: {
                int index = regIndexes[5] = regIndexes[5] + 1;
                if (value == null || !(value instanceof BRefType)) break;
                structureType.setRefField(index, (BRefType)value);
            }
        }
    }
}

