/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import org.apache.commons.lang3.StringEscapeUtils;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.BLangVMErrors;
import org.ballerinalang.bre.bvm.SignalType;
import org.ballerinalang.bre.bvm.WorkerData;
import org.ballerinalang.bre.bvm.WorkerDataChannel;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.bre.bvm.WorkerResponseContext;
import org.ballerinalang.bre.bvm.WorkerSignal;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BConnectorType;
import org.ballerinalang.model.types.BEnumType;
import org.ballerinalang.model.types.BFunctionType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.Flags;
import org.ballerinalang.model.util.JSONUtils;
import org.ballerinalang.model.util.JsonNode;
import org.ballerinalang.model.util.StringUtils;
import org.ballerinalang.model.util.XMLUtils;
import org.ballerinalang.model.values.BBlob;
import org.ballerinalang.model.values.BBlobArray;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BBooleanArray;
import org.ballerinalang.model.values.BClosure;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BConnector;
import org.ballerinalang.model.values.BFloat;
import org.ballerinalang.model.values.BFloatArray;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BFuture;
import org.ballerinalang.model.values.BIntArray;
import org.ballerinalang.model.values.BIntRange;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BJSON;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BStream;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BStringArray;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BTable;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLAttributes;
import org.ballerinalang.model.values.BXMLQName;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.model.values.StructureType;
import org.ballerinalang.util.BLangConstants;
import org.ballerinalang.util.TransactionStatus;
import org.ballerinalang.util.codegen.ActionInfo;
import org.ballerinalang.util.codegen.AttachedFunctionInfo;
import org.ballerinalang.util.codegen.ConnectorInfo;
import org.ballerinalang.util.codegen.ErrorTableEntry;
import org.ballerinalang.util.codegen.ForkjoinInfo;
import org.ballerinalang.util.codegen.FunctionInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.LineNumberInfo;
import org.ballerinalang.util.codegen.StructFieldInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.codegen.WorkerDataChannelInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfo;
import org.ballerinalang.util.codegen.attributes.AttributeInfoPool;
import org.ballerinalang.util.codegen.attributes.CodeAttributeInfo;
import org.ballerinalang.util.codegen.attributes.DefaultValueAttributeInfo;
import org.ballerinalang.util.codegen.cpentries.FloatCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionCallCPEntry;
import org.ballerinalang.util.codegen.cpentries.FunctionRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.IntegerCPEntry;
import org.ballerinalang.util.codegen.cpentries.StringCPEntry;
import org.ballerinalang.util.codegen.cpentries.StructureRefCPEntry;
import org.ballerinalang.util.codegen.cpentries.TypeRefCPEntry;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.debugger.Debugger;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;
import org.ballerinalang.util.program.BLangFunctions;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.LocalTransactionInfo;
import org.ballerinalang.util.transactions.TransactionResourceManager;
import org.ballerinalang.util.transactions.TransactionUtils;

public class CPU {
    public static void traceCode(Instruction[] code) {
        PrintStream printStream = System.out;
        for (int i = 0; i < code.length; ++i) {
            printStream.println(i + ": " + code[i].toString());
        }
    }

    private static WorkerExecutionContext handleHalt(WorkerExecutionContext ctx) {
        BLangScheduler.workerDone(ctx);
        return ctx.respCtx.signal(new WorkerSignal(ctx, SignalType.HALT, null));
    }

    public static void exec(WorkerExecutionContext ctx) {
        while (ctx != null && !ctx.isRootContext()) {
            try {
                CPU.tryExec(ctx);
                break;
            }
            catch (HandleErrorException e) {
                ctx = e.ctx;
            }
        }
    }

    private static void tryExec(WorkerExecutionContext ctx) {
        BLangScheduler.workerRunning(ctx);
        boolean debugEnabled = ctx.programFile.getDebugger().isDebugEnabled();
        block74: while (ctx.ip >= 0) {
            try {
                if (ctx.stop) {
                    BLangScheduler.workerDone(ctx);
                    return;
                }
                if (debugEnabled && CPU.debug(ctx)) {
                    return;
                }
                Instruction instruction = ctx.code[ctx.ip];
                int opcode = instruction.getOpcode();
                int[] operands = instruction.getOperands();
                ++ctx.ip;
                WorkerData sf = ctx.workerLocal;
                switch (opcode) {
                    case 2: {
                        int cpIndex = operands[0];
                        int i = operands[1];
                        sf.longRegs[i] = ((IntegerCPEntry)ctx.constPool[cpIndex]).getValue();
                        continue block74;
                    }
                    case 3: {
                        int cpIndex = operands[0];
                        int i = operands[1];
                        sf.doubleRegs[i] = ((FloatCPEntry)ctx.constPool[cpIndex]).getValue();
                        continue block74;
                    }
                    case 4: {
                        int cpIndex = operands[0];
                        int i = operands[1];
                        sf.stringRegs[i] = ((StringCPEntry)ctx.constPool[cpIndex]).getValue();
                        continue block74;
                    }
                    case 5: {
                        int i = operands[0];
                        sf.longRegs[i] = 0L;
                        continue block74;
                    }
                    case 6: {
                        int i = operands[0];
                        sf.longRegs[i] = 1L;
                        continue block74;
                    }
                    case 7: {
                        int i = operands[0];
                        sf.longRegs[i] = 2L;
                        continue block74;
                    }
                    case 8: {
                        int i = operands[0];
                        sf.longRegs[i] = 3L;
                        continue block74;
                    }
                    case 9: {
                        int i = operands[0];
                        sf.longRegs[i] = 4L;
                        continue block74;
                    }
                    case 10: {
                        int i = operands[0];
                        sf.longRegs[i] = 5L;
                        continue block74;
                    }
                    case 11: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 0.0;
                        continue block74;
                    }
                    case 12: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 1.0;
                        continue block74;
                    }
                    case 13: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 2.0;
                        continue block74;
                    }
                    case 14: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 3.0;
                        continue block74;
                    }
                    case 15: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 4.0;
                        continue block74;
                    }
                    case 16: {
                        int i = operands[0];
                        sf.doubleRegs[i] = 5.0;
                        continue block74;
                    }
                    case 17: {
                        int i = operands[0];
                        sf.intRegs[i] = 0;
                        continue block74;
                    }
                    case 18: {
                        int i = operands[0];
                        sf.intRegs[i] = 1;
                        continue block74;
                    }
                    case 19: {
                        int i = operands[0];
                        sf.refRegs[i] = null;
                        continue block74;
                    }
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: 
                    case 48: {
                        CPU.execLoadOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 71: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: {
                        CPU.execStoreOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 76: 
                    case 77: 
                    case 78: 
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 96: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 104: 
                    case 253: 
                    case 254: {
                        CPU.execBinaryOpCodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 208: {
                        CPU.calculateLength(ctx, operands, sf);
                        continue block74;
                    }
                    case 252: {
                        int cpIndex = operands[0];
                        int j = operands[1];
                        TypeRefCPEntry typeEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        sf.refRegs[j] = new BTypeDescValue(typeEntry.getType());
                        continue block74;
                    }
                    case 251: {
                        int i = operands[0];
                        int j = operands[1];
                        if (sf.refRegs[i] == null) {
                            sf.refRegs[j] = new BTypeDescValue(BTypes.typeNull);
                            continue block74;
                        }
                        sf.refRegs[j] = new BTypeDescValue(sf.refRegs[i].getType());
                        continue block74;
                    }
                    case 118: {
                        if ((ctx = CPU.handleHalt(ctx)) != null) continue block74;
                        return;
                    }
                    case 105: 
                    case 106: 
                    case 107: 
                    case 108: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 128: 
                    case 129: {
                        CPU.execCmpAndBranchOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 119: {
                        int i = operands[0];
                        int j = operands[1];
                        int l = operands[2];
                        CPU.retryTransaction(ctx, i, j, l);
                        continue block74;
                    }
                    case 120: {
                        Instruction.InstructionCALL callIns = (Instruction.InstructionCALL)instruction;
                        if ((ctx = BLangFunctions.invokeCallable(callIns.functionInfo, ctx, callIns.argRegs, callIns.retRegs, false, callIns.flags)) != null) continue block74;
                        return;
                    }
                    case 121: {
                        Instruction.InstructionVCALL vcallIns = (Instruction.InstructionVCALL)instruction;
                        if ((ctx = CPU.invokeVirtualFunction(ctx, vcallIns.receiverRegIndex, vcallIns.functionInfo, vcallIns.argRegs, vcallIns.retRegs, vcallIns.flags)) != null) continue block74;
                        return;
                    }
                    case 122: {
                        Instruction.InstructionACALL acallIns = (Instruction.InstructionACALL)instruction;
                        if ((ctx = CPU.invokeAction(ctx, acallIns.actionName, acallIns.argRegs, acallIns.retRegs, acallIns.flags)) != null) continue block74;
                        return;
                    }
                    case 127: {
                        Instruction.InstructionTCALL tcallIns = (Instruction.InstructionTCALL)instruction;
                        if ((ctx = BLangFunctions.invokeCallable(tcallIns.transformerInfo, ctx, tcallIns.argRegs, tcallIns.retRegs, false, tcallIns.flags)) != null) continue block74;
                        return;
                    }
                    case 188: {
                        int i = operands[0];
                        int j = operands[1];
                        int k = operands[2];
                        int h = operands[3];
                        CPU.beginTransaction(ctx, i, j, k, h);
                        continue block74;
                    }
                    case 189: {
                        int i = operands[0];
                        int j = operands[1];
                        CPU.endTransaction(ctx, i, j);
                        continue block74;
                    }
                    case 190: {
                        Instruction.InstructionWRKSendReceive wrkSendIns = (Instruction.InstructionWRKSendReceive)instruction;
                        CPU.handleWorkerSend(ctx, wrkSendIns.dataChannelInfo, wrkSendIns.type, wrkSendIns.reg);
                        continue block74;
                    }
                    case 191: {
                        Instruction.InstructionWRKSendReceive wrkReceiveIns = (Instruction.InstructionWRKSendReceive)instruction;
                        if (CPU.handleWorkerReceive(ctx, wrkReceiveIns.dataChannelInfo, wrkReceiveIns.type, wrkReceiveIns.reg)) continue block74;
                        return;
                    }
                    case 192: {
                        Instruction.InstructionFORKJOIN forkJoinIns = (Instruction.InstructionFORKJOIN)instruction;
                        if ((ctx = CPU.invokeForkJoin(ctx, forkJoinIns)) != null) continue block74;
                        return;
                    }
                    case 123: {
                        int i = operands[0];
                        if (i >= 0) {
                            BStruct error = (BStruct)sf.refRegs[i];
                            if (error == null) {
                                CPU.handleNullRefError(ctx);
                                continue block74;
                            }
                            BLangVMErrors.attachStackFrame(error, ctx);
                            ctx.setError(error);
                        }
                        CPU.handleError(ctx);
                        continue block74;
                    }
                    case 124: {
                        int i = operands[0];
                        sf.refRegs[i] = ctx.getError();
                        ctx.setError(null);
                        continue block74;
                    }
                    case 125: {
                        int i = operands[0];
                        if (sf.refRegs[i] == null) {
                            CPU.handleNullRefError(ctx);
                            continue block74;
                        }
                        int cpIndex = operands[1];
                        FunctionCallCPEntry funcCallCPEntry = (FunctionCallCPEntry)ctx.constPool[cpIndex];
                        FunctionRefCPEntry funcRefCPEntry = ((BFunctionPointer)sf.refRegs[i]).value();
                        FunctionInfo functionInfo = funcRefCPEntry.getFunctionInfo();
                        if ((ctx = CPU.invokeCallable(ctx, (BFunctionPointer)sf.refRegs[i], funcCallCPEntry, functionInfo, sf)) != null) continue block74;
                        return;
                    }
                    case 126: {
                        BFunctionPointer functionPointer;
                        int i = operands[0];
                        int j = operands[1];
                        FunctionRefCPEntry funcRefCPEntry = (FunctionRefCPEntry)ctx.constPool[i];
                        sf.refRegs[j] = functionPointer = new BFunctionPointer(funcRefCPEntry);
                        CPU.findAndAddClosureVarRegIndexes(ctx, operands, functionPointer);
                        continue block74;
                    }
                    case 145: 
                    case 146: 
                    case 147: 
                    case 148: 
                    case 149: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: 
                    case 165: 
                    case 166: 
                    case 167: 
                    case 168: 
                    case 169: 
                    case 170: 
                    case 171: 
                    case 172: 
                    case 174: 
                    case 177: 
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: 
                    case 182: 
                    case 184: 
                    case 196: 
                    case 197: {
                        CPU.execTypeCastOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 158: 
                    case 159: 
                    case 175: 
                    case 183: 
                    case 237: {
                        CPU.execTypeConversionOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 200: {
                        int i = operands[0];
                        sf.refRegs[i] = new BIntArray();
                        continue block74;
                    }
                    case 207: {
                        int i = operands[0];
                        int j = operands[1];
                        BRefType<?> value = sf.refRegs[i];
                        if (value == null) {
                            CPU.handleNullRefError(ctx);
                            continue block74;
                        }
                        if (value.getType().getTag() == 9) {
                            sf.longRegs[j] = ((BJSON)value).value().size();
                            continue block74;
                        }
                        sf.longRegs[j] = ((BNewArray)value).size();
                        continue block74;
                    }
                    case 201: {
                        int i = operands[0];
                        sf.refRegs[i] = new BFloatArray();
                        continue block74;
                    }
                    case 202: {
                        int i = operands[0];
                        sf.refRegs[i] = new BStringArray();
                        continue block74;
                    }
                    case 203: {
                        int i = operands[0];
                        sf.refRegs[i] = new BBooleanArray();
                        continue block74;
                    }
                    case 204: {
                        int i = operands[0];
                        sf.refRegs[i] = new BBlobArray();
                        continue block74;
                    }
                    case 205: {
                        int i = operands[0];
                        int cpIndex = operands[1];
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        sf.refRegs[i] = new BRefValueArray(typeRefCPEntry.getType());
                        continue block74;
                    }
                    case 206: {
                        int i = operands[0];
                        int j = operands[1];
                        StringJoiner stringJoiner = new StringJoiner(",", "[", "]");
                        int index = 0;
                        while ((long)index < sf.longRegs[j]) {
                            stringJoiner.add(null);
                            ++index;
                        }
                        sf.refRegs[i] = new BJSON(stringJoiner.toString());
                        continue block74;
                    }
                    case 210: {
                        CPU.createNewStruct(ctx, operands, sf);
                        continue block74;
                    }
                    case 211: {
                        CPU.createNewConnector(ctx, operands, sf);
                        continue block74;
                    }
                    case 212: {
                        int i = operands[0];
                        int cpIndex = operands[1];
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        BMapType mapType = (BMapType)typeRefCPEntry.getType();
                        sf.refRegs[i] = new BMap(mapType);
                        continue block74;
                    }
                    case 213: {
                        int i = operands[0];
                        int cpIndex = operands[1];
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        sf.refRegs[i] = new BJSON("{}", typeRefCPEntry.getType());
                        continue block74;
                    }
                    case 215: {
                        int i = operands[0];
                        int cpIndex = operands[1];
                        int j = operands[2];
                        BStruct configStruct = (BStruct)sf.refRegs[j];
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        sf.refRegs[i] = new BTable(typeRefCPEntry.getType(), configStruct);
                        continue block74;
                    }
                    case 217: {
                        BStream stream;
                        int i = operands[0];
                        int cpIndex = operands[1];
                        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                        StringCPEntry name = (StringCPEntry)ctx.constPool[operands[2]];
                        sf.refRegs[i] = stream = new BStream(typeRefCPEntry.getType(), name.getValue());
                        continue block74;
                    }
                    case 219: {
                        CPU.createNewIntRange(operands, sf);
                        continue block74;
                    }
                    case 229: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.longRegs[callersRetRegIndex] = currentSF.longRegs[j];
                        continue block74;
                    }
                    case 230: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.doubleRegs[callersRetRegIndex] = currentSF.doubleRegs[j];
                        continue block74;
                    }
                    case 231: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.stringRegs[callersRetRegIndex] = currentSF.stringRegs[j];
                        continue block74;
                    }
                    case 232: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.intRegs[callersRetRegIndex] = currentSF.intRegs[j];
                        continue block74;
                    }
                    case 233: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.byteRegs[callersRetRegIndex] = currentSF.byteRegs[j];
                        continue block74;
                    }
                    case 234: {
                        int i = operands[0];
                        int j = operands[1];
                        WorkerData currentSF = ctx.workerLocal;
                        WorkerData callersSF = ctx.workerResult;
                        int callersRetRegIndex = ctx.retRegIndexes[i];
                        callersSF.refRegs[callersRetRegIndex] = currentSF.refRegs[j];
                        continue block74;
                    }
                    case 235: {
                        if ((ctx = CPU.handleReturn(ctx)) != null) continue block74;
                        return;
                    }
                    case 236: 
                    case 238: 
                    case 239: 
                    case 240: 
                    case 241: 
                    case 242: 
                    case 243: 
                    case 244: 
                    case 245: 
                    case 246: 
                    case 247: 
                    case 248: 
                    case 249: 
                    case 250: {
                        CPU.execXMLOpcodes(ctx, sf, opcode, operands);
                        continue block74;
                    }
                    case 220: 
                    case 221: 
                    case 222: {
                        CPU.execIteratorOperation(ctx, sf, instruction);
                        continue block74;
                    }
                    case 185: {
                        Instruction.InstructionLock instructionLock = (Instruction.InstructionLock)instruction;
                        if (CPU.handleVariableLock(ctx, instructionLock.types, instructionLock.varRegs)) continue block74;
                        return;
                    }
                    case 186: {
                        Instruction.InstructionLock instructionUnLock = (Instruction.InstructionLock)instruction;
                        CPU.handleVariableUnlock(ctx, instructionUnLock.types, instructionUnLock.varRegs);
                        continue block74;
                    }
                    case 193: {
                        if ((ctx = CPU.execAwait(ctx, operands)) != null) continue block74;
                        return;
                    }
                }
                throw new UnsupportedOperationException();
            }
            catch (HandleErrorException e) {
                throw e;
            }
            catch (Throwable e) {
                BLangVMUtils.log("fatal error: " + e.getMessage());
                ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                CPU.handleError(ctx);
            }
        }
    }

    private static WorkerExecutionContext invokeCallable(WorkerExecutionContext ctx, BFunctionPointer fp, FunctionCallCPEntry funcCallCPEntry, FunctionInfo functionInfo, WorkerData sf) {
        List<BClosure> closureVars = fp.getClosureVars();
        int[] argRegs = funcCallCPEntry.getArgRegs();
        if (closureVars.isEmpty()) {
            return BLangFunctions.invokeCallable(functionInfo, ctx, argRegs, funcCallCPEntry.getRetRegs(), false);
        }
        int[] newArgRegs = new int[argRegs.length + closureVars.size()];
        System.arraycopy(argRegs, 0, newArgRegs, closureVars.size(), argRegs.length);
        int argRegIndex = 0;
        int longIndex = CPU.expandLongRegs(sf, fp);
        int doubleIndex = CPU.expandDoubleRegs(sf, fp);
        int intIndex = CPU.expandIntRegs(sf, fp);
        int stringIndex = CPU.expandStringRegs(sf, fp);
        int byteIndex = CPU.expandByteRegs(sf, fp);
        int refIndex = CPU.expandRefRegs(sf, fp);
        block7: for (BClosure closure : closureVars) {
            switch (closure.getType().getTag()) {
                case 1: {
                    sf.longRegs[longIndex] = ((BInteger)closure.value()).intValue();
                    newArgRegs[argRegIndex++] = longIndex++;
                    continue block7;
                }
                case 2: {
                    sf.doubleRegs[doubleIndex] = ((BFloat)closure.value()).floatValue();
                    newArgRegs[argRegIndex++] = doubleIndex++;
                    continue block7;
                }
                case 4: {
                    sf.intRegs[intIndex] = ((BBoolean)closure.value()).booleanValue() ? 1 : 0;
                    newArgRegs[argRegIndex++] = intIndex++;
                    continue block7;
                }
                case 3: {
                    sf.stringRegs[stringIndex] = closure.value().stringValue();
                    newArgRegs[argRegIndex++] = stringIndex++;
                    continue block7;
                }
                case 5: {
                    sf.byteRegs[byteIndex] = ((BBlob)closure.value()).blobValue();
                    newArgRegs[argRegIndex++] = byteIndex++;
                    continue block7;
                }
            }
            sf.refRegs[refIndex] = (BRefType)closure.value();
            newArgRegs[argRegIndex++] = refIndex++;
        }
        return BLangFunctions.invokeCallable(functionInfo, ctx, newArgRegs, funcCallCPEntry.getRetRegs(), false);
    }

    private static int expandLongRegs(WorkerData sf, BFunctionPointer fp) {
        int longIndex = 0;
        if (sf.longRegs != null && fp.getAdditionalIndexCount(BTypes.typeInt.getTag()) > 0) {
            long[] newLongRegs = new long[sf.longRegs.length + fp.getAdditionalIndexCount(BTypes.typeInt.getTag())];
            System.arraycopy(sf.longRegs, 0, newLongRegs, 0, sf.longRegs.length);
            longIndex = sf.longRegs.length;
            sf.longRegs = newLongRegs;
        }
        return longIndex;
    }

    private static int expandIntRegs(WorkerData sf, BFunctionPointer fp) {
        int intIndex = 0;
        if (sf.intRegs != null && fp.getAdditionalIndexCount(BTypes.typeBoolean.getTag()) > 0) {
            int[] newIntRegs = new int[sf.intRegs.length + fp.getAdditionalIndexCount(BTypes.typeBoolean.getTag())];
            System.arraycopy(sf.intRegs, 0, newIntRegs, 0, sf.intRegs.length);
            intIndex = sf.intRegs.length;
            sf.intRegs = newIntRegs;
        }
        return intIndex;
    }

    private static int expandDoubleRegs(WorkerData sf, BFunctionPointer fp) {
        int doubleIndex = 0;
        if (sf.doubleRegs != null && fp.getAdditionalIndexCount(BTypes.typeFloat.getTag()) > 0) {
            double[] newDoubleRegs = new double[sf.doubleRegs.length + fp.getAdditionalIndexCount(BTypes.typeFloat.getTag())];
            System.arraycopy(sf.doubleRegs, 0, newDoubleRegs, 0, sf.doubleRegs.length);
            doubleIndex = sf.intRegs.length;
            sf.doubleRegs = newDoubleRegs;
        }
        return doubleIndex;
    }

    private static int expandStringRegs(WorkerData sf, BFunctionPointer fp) {
        int stringIndex = 0;
        if (sf.stringRegs != null && fp.getAdditionalIndexCount(BTypes.typeString.getTag()) > 0) {
            String[] newStringRegs = new String[sf.stringRegs.length + fp.getAdditionalIndexCount(BTypes.typeString.getTag())];
            System.arraycopy(sf.stringRegs, 0, newStringRegs, 0, sf.stringRegs.length);
            stringIndex = sf.stringRegs.length;
            sf.stringRegs = newStringRegs;
        }
        return stringIndex;
    }

    private static int expandByteRegs(WorkerData sf, BFunctionPointer fp) {
        int byteIndex = 0;
        if (sf.byteRegs != null && fp.getAdditionalIndexCount(BTypes.typeBlob.getTag()) > 0) {
            byte[][] newByteRegs = new byte[sf.byteRegs.length + fp.getAdditionalIndexCount(BTypes.typeBlob.getTag())][];
            System.arraycopy(sf.byteRegs, 0, newByteRegs, 0, sf.byteRegs.length);
            byteIndex = sf.byteRegs.length;
            sf.byteRegs = newByteRegs;
        }
        return byteIndex;
    }

    private static int expandRefRegs(WorkerData sf, BFunctionPointer fp) {
        int refIndex = 0;
        if (sf.refRegs != null && fp.getAdditionalIndexCount(BTypes.typeAny.getTag()) > 0) {
            BRefType[] newRefRegs = new BRefType[sf.refRegs.length + fp.getAdditionalIndexCount(BTypes.typeAny.getTag())];
            System.arraycopy(sf.refRegs, 0, newRefRegs, 0, sf.refRegs.length);
            refIndex = sf.refRegs.length;
            sf.refRegs = newRefRegs;
        }
        return refIndex;
    }

    private static void findAndAddClosureVarRegIndexes(WorkerExecutionContext ctx, int[] operands, BFunctionPointer fp) {
        int h = operands[2];
        if (h == 0) {
            return;
        }
        block7: for (int i = 0; i < h; ++i) {
            int operandIndex = i * 2 + 3;
            int type = operands[operandIndex];
            int index = operands[++operandIndex];
            switch (type) {
                case 1: {
                    fp.addClosureVar(new BClosure(new BInteger(ctx.workerLocal.longRegs[index])));
                    continue block7;
                }
                case 2: {
                    fp.addClosureVar(new BClosure(new BFloat(ctx.workerLocal.doubleRegs[index])));
                    continue block7;
                }
                case 4: {
                    fp.addClosureVar(new BClosure(new BBoolean(ctx.workerLocal.intRegs[index] == 1)));
                    continue block7;
                }
                case 3: {
                    fp.addClosureVar(new BClosure(new BString(ctx.workerLocal.stringRegs[index])));
                    continue block7;
                }
                case 5: {
                    fp.addClosureVar(new BClosure(new BBlob(ctx.workerLocal.byteRegs[index])));
                    continue block7;
                }
                default: {
                    fp.addClosureVar(new BClosure(ctx.workerLocal.refRegs[index]));
                }
            }
        }
    }

    private static void execCmpAndBranchOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 105: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] > sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 106: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] > sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 107: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] >= sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 108: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] >= sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 109: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] < sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 110: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] < sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 111: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] <= sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 112: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] <= sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 113: {
                int i = operands[0];
                int j = operands[1];
                if (sf.refRegs[i] == null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 114: {
                int i = operands[0];
                int j = operands[1];
                if (sf.refRegs[i] != null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 128: {
                int i = operands[0];
                int j = operands[1];
                if (sf.stringRegs[i] == null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 129: {
                int i = operands[0];
                int j = operands[1];
                if (sf.stringRegs[i] != null) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 115: {
                int i = operands[0];
                int j = operands[1];
                if (sf.intRegs[i] != 1) break;
                ctx.ip = j;
                break;
            }
            case 116: {
                int i = operands[0];
                int j = operands[1];
                if (sf.intRegs[i] != 0) break;
                ctx.ip = j;
                break;
            }
            case 117: {
                int i;
                ctx.ip = i = operands[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execLoadOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 21: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.longRegs[i] = sf.longRegs[lvIndex];
                break;
            }
            case 22: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.doubleRegs[i] = sf.doubleRegs[lvIndex];
                break;
            }
            case 23: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.stringRegs[i] = sf.stringRegs[lvIndex];
                break;
            }
            case 24: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.intRegs[i] = sf.intRegs[lvIndex];
                break;
            }
            case 25: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.byteRegs[i] = sf.byteRegs[lvIndex];
                break;
            }
            case 26: {
                int lvIndex = operands[0];
                int i = operands[1];
                sf.refRegs[i] = sf.refRegs[lvIndex];
                break;
            }
            case 27: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BIntArray bIntArray = (BIntArray)sf.refRegs[i];
                if (bIntArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.longRegs[k] = bIntArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 28: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BFloatArray bFloatArray = (BFloatArray)sf.refRegs[i];
                if (bFloatArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.doubleRegs[k] = bFloatArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 29: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BStringArray bStringArray = (BStringArray)sf.refRegs[i];
                if (bStringArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.stringRegs[k] = bStringArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 30: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BBooleanArray bBooleanArray = (BBooleanArray)sf.refRegs[i];
                if (bBooleanArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.intRegs[k] = bBooleanArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 31: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BBlobArray bBlobArray = (BBlobArray)sf.refRegs[i];
                if (bBlobArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.byteRegs[k] = bBlobArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 32: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BRefValueArray bArray = (BRefValueArray)sf.refRegs[i];
                if (bArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.refRegs[k] = bArray.get(sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 33: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BJSON jsonVal = (BJSON)sf.refRegs[i];
                if (jsonVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.refRegs[k] = JSONUtils.getArrayElement(jsonVal, sf.longRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 34: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = ctx.programFile.getGlobalMemoryBlock().getIntField(i);
                break;
            }
            case 35: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = ctx.programFile.getGlobalMemoryBlock().getFloatField(i);
                break;
            }
            case 36: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = ctx.programFile.getGlobalMemoryBlock().getStringField(i);
                break;
            }
            case 37: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = ctx.programFile.getGlobalMemoryBlock().getBooleanField(i);
                break;
            }
            case 38: {
                int i = operands[0];
                int j = operands[1];
                sf.byteRegs[j] = ctx.programFile.getGlobalMemoryBlock().getBlobField(i);
                break;
            }
            case 39: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = ctx.programFile.getGlobalMemoryBlock().getRefField(i);
                break;
            }
            case 40: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.longRegs[j] = structureType.getIntField(fieldIndex);
                break;
            }
            case 41: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.doubleRegs[j] = structureType.getFloatField(fieldIndex);
                break;
            }
            case 42: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.stringRegs[j] = structureType.getStringField(fieldIndex);
                break;
            }
            case 43: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.intRegs[j] = structureType.getBooleanField(fieldIndex);
                break;
            }
            case 44: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.byteRegs[j] = structureType.getBlobField(fieldIndex);
                break;
            }
            case 45: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.refRegs[j] = structureType.getRefField(fieldIndex);
                break;
            }
            case 46: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BMap bMap = (BMap)sf.refRegs[i];
                if (bMap == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.refRegs[k] = (BRefType)bMap.get(sf.stringRegs[j]);
                break;
            }
            case 47: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BJSON jsonVal = (BJSON)sf.refRegs[i];
                if (jsonVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.refRegs[k] = JSONUtils.getElement(jsonVal, sf.stringRegs[j]);
                break;
            }
            case 48: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[i];
                BEnumType enumType = (BEnumType)typeRefCPEntry.getType();
                sf.refRegs[k] = enumType.getEnumerator(j);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execStoreOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 55: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BIntArray bIntArray = (BIntArray)sf.refRegs[i];
                if (bIntArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bIntArray.add(sf.longRegs[j], sf.longRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 56: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BFloatArray bFloatArray = (BFloatArray)sf.refRegs[i];
                if (bFloatArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bFloatArray.add(sf.longRegs[j], sf.doubleRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 57: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BStringArray bStringArray = (BStringArray)sf.refRegs[i];
                if (bStringArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bStringArray.add(sf.longRegs[j], sf.stringRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 58: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BBooleanArray bBooleanArray = (BBooleanArray)sf.refRegs[i];
                if (bBooleanArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bBooleanArray.add(sf.longRegs[j], sf.intRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 59: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BBlobArray bBlobArray = (BBlobArray)sf.refRegs[i];
                if (bBlobArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bBlobArray.add(sf.longRegs[j], sf.byteRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 60: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BRefValueArray bArray = (BRefValueArray)sf.refRegs[i];
                if (bArray == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    bArray.add(sf.longRegs[j], sf.refRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 61: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BJSON jsonVal = (BJSON)sf.refRegs[i];
                if (jsonVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    JSONUtils.setArrayElement(jsonVal, sf.longRegs[j], (BJSON)sf.refRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 62: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setIntField(j, sf.longRegs[i]);
                break;
            }
            case 63: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setFloatField(j, sf.doubleRegs[i]);
                break;
            }
            case 64: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setStringField(j, sf.stringRegs[i]);
                break;
            }
            case 65: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setBooleanField(j, sf.intRegs[i]);
                break;
            }
            case 66: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setBlobField(j, sf.byteRegs[i]);
                break;
            }
            case 67: {
                int i = operands[0];
                int j = operands[1];
                ctx.programFile.getGlobalMemoryBlock().setRefField(j, sf.refRegs[i]);
                break;
            }
            case 68: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setIntField(fieldIndex, sf.longRegs[j]);
                break;
            }
            case 69: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setFloatField(fieldIndex, sf.doubleRegs[j]);
                break;
            }
            case 70: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setStringField(fieldIndex, sf.stringRegs[j]);
                break;
            }
            case 71: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setBooleanField(fieldIndex, sf.intRegs[j]);
                break;
            }
            case 72: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setBlobField(fieldIndex, sf.byteRegs[j]);
                break;
            }
            case 73: {
                int i = operands[0];
                int fieldIndex = operands[1];
                int j = operands[2];
                StructureType structureType = (StructureType)((Object)sf.refRegs[i]);
                if (structureType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                structureType.setRefField(fieldIndex, sf.refRegs[j]);
                break;
            }
            case 74: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BMap bMap = (BMap)sf.refRegs[i];
                if (bMap == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                BMapType mapType = (BMapType)bMap.getType();
                if (sf.refRegs[k] == null) {
                    bMap.put(sf.stringRegs[j], sf.refRegs[k]);
                    break;
                }
                if (mapType.getConstrainedType() == BTypes.typeAny || mapType.getConstrainedType().equals(sf.refRegs[k].getType())) {
                    bMap.put(sf.stringRegs[j], sf.refRegs[k]);
                    break;
                }
                if (sf.refRegs[k].getType().getTag() == 15 && mapType.getConstrainedType().getTag() == 15 && CPU.checkStructEquivalency((BStructType)sf.refRegs[k].getType(), (BStructType)mapType.getConstrainedType())) {
                    bMap.put(sf.stringRegs[j], sf.refRegs[k]);
                    break;
                }
                ctx.setError(BLangVMErrors.createError(ctx, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, mapType.getConstrainedType(), sf.refRegs[k].getType())));
                CPU.handleError(ctx);
                break;
            }
            case 75: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BJSON jsonVal = (BJSON)sf.refRegs[i];
                if (jsonVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                JSONUtils.setElement(jsonVal, sf.stringRegs[j], (BJSON)sf.refRegs[k]);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execBinaryOpCodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 76: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] + sf.longRegs[j];
                break;
            }
            case 77: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] + sf.doubleRegs[j];
                break;
            }
            case 78: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.stringRegs[k] = sf.stringRegs[i] + sf.stringRegs[j];
                break;
            }
            case 81: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML lhsXMLVal = (BXML)sf.refRegs[i];
                BXML rhsXMLVal = (BXML)sf.refRegs[j];
                if (lhsXMLVal == null || rhsXMLVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.refRegs[k] = XMLUtils.concatenate(lhsXMLVal, rhsXMLVal);
                break;
            }
            case 82: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] - sf.longRegs[j];
                break;
            }
            case 83: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] - sf.doubleRegs[j];
                break;
            }
            case 84: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.longRegs[k] = sf.longRegs[i] * sf.longRegs[j];
                break;
            }
            case 85: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.doubleRegs[k] = sf.doubleRegs[i] * sf.doubleRegs[j];
                break;
            }
            case 86: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.longRegs[j] == 0L) {
                    ctx.setError(BLangVMErrors.createError(ctx, " / by zero"));
                    CPU.handleError(ctx);
                    break;
                }
                sf.longRegs[k] = sf.longRegs[i] / sf.longRegs[j];
                break;
            }
            case 87: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.doubleRegs[j] == 0.0) {
                    ctx.setError(BLangVMErrors.createError(ctx, " / by zero"));
                    CPU.handleError(ctx);
                    break;
                }
                sf.doubleRegs[k] = sf.doubleRegs[i] / sf.doubleRegs[j];
                break;
            }
            case 88: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.longRegs[j] == 0L) {
                    ctx.setError(BLangVMErrors.createError(ctx, " / by zero"));
                    CPU.handleError(ctx);
                    break;
                }
                sf.longRegs[k] = sf.longRegs[i] % sf.longRegs[j];
                break;
            }
            case 89: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.doubleRegs[j] == 0.0) {
                    ctx.setError(BLangVMErrors.createError(ctx, " / by zero"));
                    CPU.handleError(ctx);
                    break;
                }
                sf.doubleRegs[k] = sf.doubleRegs[i] % sf.doubleRegs[j];
                break;
            }
            case 90: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = -sf.longRegs[i];
                break;
            }
            case 91: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = -sf.doubleRegs[i];
                break;
            }
            case 92: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.intRegs[i] == 0 ? 1 : 0;
                break;
            }
            case 93: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] == sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 94: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] == sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 95: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = StringUtils.isEqual(sf.stringRegs[i], sf.stringRegs[j]) ? 1 : 0;
                break;
            }
            case 96: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.intRegs[i] == sf.intRegs[j] ? 1 : 0;
                break;
            }
            case 98: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.refRegs[i] == sf.refRegs[j] ? 1 : 0;
                break;
            }
            case 253: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null || sf.refRegs[j] == null) {
                    CPU.handleNullRefError(ctx);
                }
                sf.intRegs[k] = sf.refRegs[i].equals(sf.refRegs[j]) ? 1 : 0;
                break;
            }
            case 99: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.longRegs[i] != sf.longRegs[j] ? 1 : 0;
                break;
            }
            case 100: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.doubleRegs[i] != sf.doubleRegs[j] ? 1 : 0;
                break;
            }
            case 101: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = !StringUtils.isEqual(sf.stringRegs[i], sf.stringRegs[j]) ? 1 : 0;
                break;
            }
            case 102: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.intRegs[i] != sf.intRegs[j] ? 1 : 0;
                break;
            }
            case 104: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                sf.intRegs[k] = sf.refRegs[i] != sf.refRegs[j] ? 1 : 0;
                break;
            }
            case 254: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                if (sf.refRegs[i] == null || sf.refRegs[j] == null) {
                    CPU.handleNullRefError(ctx);
                }
                sf.intRegs[k] = !sf.refRegs[i].equals(sf.refRegs[j]) ? 1 : 0;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execXMLOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 239: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                BXMLQName xmlQName = (BXMLQName)sf.refRegs[j];
                if (xmlQName == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                xmlVal.setAttribute(xmlQName.getLocalName(), xmlQName.getUri(), xmlQName.getPrefix(), sf.stringRegs[k]);
                break;
            }
            case 238: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                BXMLQName xmlQName = (BXMLQName)sf.refRegs[j];
                if (xmlQName == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.stringRegs[k] = xmlVal.getAttribute(xmlQName.getLocalName(), xmlQName.getUri(), xmlQName.getPrefix());
                break;
            }
            case 236: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    sf.refRegs[j] = null;
                    break;
                }
                sf.refRegs[j] = new BXMLAttributes(xmlVal);
                break;
            }
            case 240: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                String qNameStr = sf.stringRegs[i];
                int parenEndIndex = qNameStr.indexOf(125);
                if (qNameStr.startsWith("{") && parenEndIndex > 0) {
                    sf.stringRegs[j] = qNameStr.substring(parenEndIndex + 1, qNameStr.length());
                    sf.stringRegs[k] = qNameStr.substring(1, parenEndIndex);
                    break;
                }
                sf.stringRegs[j] = qNameStr;
                sf.stringRegs[k] = BLangConstants.STRING_NULL_VALUE;
                break;
            }
            case 241: {
                int localNameIndex = operands[0];
                int uriIndex = operands[1];
                int prefixIndex = operands[2];
                int i = operands[3];
                String localname = sf.stringRegs[localNameIndex];
                localname = StringEscapeUtils.escapeXml11((String)localname);
                String prefix = sf.stringRegs[prefixIndex];
                prefix = StringEscapeUtils.escapeXml11((String)prefix);
                sf.refRegs[i] = new BXMLQName(localname, sf.stringRegs[uriIndex], prefix);
                break;
            }
            case 247: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                long index = sf.longRegs[j];
                sf.refRegs[k] = xmlVal.getItem(index);
                break;
            }
            case 248: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                String qname = sf.stringRegs[j];
                sf.refRegs[k] = xmlVal.children(qname);
                break;
            }
            case 249: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = (BXML)sf.refRegs[i];
                if (xmlVal == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                sf.refRegs[j] = xmlVal.children();
                break;
            }
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 250: {
                CPU.execXMLCreationOpcodes(ctx, sf, opcode, operands);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execTypeCastOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 160: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BInteger(sf.longRegs[i]);
                break;
            }
            case 161: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BFloat(sf.doubleRegs[i]);
                break;
            }
            case 162: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BString(sf.stringRegs[i]);
                break;
            }
            case 163: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BBoolean(sf.intRegs[i] == 1);
                break;
            }
            case 164: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BBlob(sf.byteRegs[i]);
                break;
            }
            case 165: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = ((BInteger)sf.refRegs[i]).intValue();
                break;
            }
            case 166: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = ((BFloat)sf.refRegs[i]).floatValue();
                break;
            }
            case 167: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.refRegs[i].stringValue();
                break;
            }
            case 168: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = ((BBoolean)sf.refRegs[i]).booleanValue() ? 1 : 0;
                break;
            }
            case 169: {
                int i = operands[0];
                int j = operands[1];
                sf.byteRegs[j] = ((BBlob)sf.refRegs[i]).blobValue();
                break;
            }
            case 170: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeJSON);
                break;
            }
            case 171: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeXML);
                break;
            }
            case 172: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeMap);
                break;
            }
            case 182: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeDesc);
                break;
            }
            case 174: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeTable);
                break;
            }
            case 173: {
                CPU.handleAnyToRefTypeCast(ctx, sf, operands, BTypes.typeStream);
                break;
            }
            case 177: 
            case 178: 
            case 179: 
            case 180: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                if (CPU.checkCast(bRefTypeValue, typeRefCPEntry.getType())) {
                    sf.refRegs[j] = sf.refRegs[i];
                    break;
                }
                CPU.handleTypeCastError(ctx, sf, j, bRefTypeValue != null ? bRefTypeValue.getType() : BTypes.typeNull, typeRefCPEntry.getType());
                break;
            }
            case 196: {
                int i = operands[0];
                int cpIndex = operands[1];
                int j = operands[2];
                TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                if (CPU.isAssignable(bRefTypeValue, typeRefCPEntry.getType())) {
                    sf.intRegs[j] = 1;
                    break;
                }
                sf.intRegs[j] = 0;
                break;
            }
            case 181: {
                int j = operands[1];
                sf.refRegs[j] = new BJSON("null");
                break;
            }
            case 145: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BJSON(sf.intRegs[i] == 1 ? "true" : "false");
                break;
            }
            case 146: {
                CPU.castJSONToInt(ctx, operands, sf);
                break;
            }
            case 147: {
                CPU.castJSONToFloat(ctx, operands, sf);
                break;
            }
            case 148: {
                CPU.castJSONToString(ctx, operands, sf);
                break;
            }
            case 149: {
                CPU.castJSONToBoolean(ctx, operands, sf);
                break;
            }
            case 184: {
                int j = operands[1];
                sf.stringRegs[j] = null;
                break;
            }
            case 197: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefTypeValue = sf.refRegs[i];
                sf.refRegs[j] = JSONUtils.convertUnionTypeToJSON(bRefTypeValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execTypeConversionOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 130: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = sf.longRegs[i];
                break;
            }
            case 131: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = Long.toString(sf.longRegs[i]);
                break;
            }
            case 132: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.longRegs[i] != 0L ? 1 : 0;
                break;
            }
            case 133: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BJSON(Long.toString(sf.longRegs[i]));
                break;
            }
            case 134: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = (long)sf.doubleRegs[i];
                break;
            }
            case 135: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = Double.toString(sf.doubleRegs[i]);
                break;
            }
            case 136: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = sf.doubleRegs[i] != 0.0 ? 1 : 0;
                break;
            }
            case 137: {
                int i = operands[0];
                int j = operands[1];
                sf.refRegs[j] = new BJSON(Double.toString(sf.doubleRegs[i]));
                break;
            }
            case 138: {
                int i = operands[0];
                int j = operands[1];
                String str = sf.stringRegs[i];
                if (str == null) {
                    CPU.handleTypeConversionError(ctx, sf, j, null, "int");
                    break;
                }
                try {
                    sf.refRegs[j] = new BInteger(Long.parseLong(str));
                }
                catch (NumberFormatException e) {
                    CPU.handleTypeConversionError(ctx, sf, j, "string", "int");
                }
                break;
            }
            case 139: {
                int i = operands[0];
                int j = operands[1];
                String str = sf.stringRegs[i];
                if (str == null) {
                    CPU.handleTypeConversionError(ctx, sf, j, null, "float");
                    break;
                }
                try {
                    sf.refRegs[j] = new BFloat(Double.parseDouble(str));
                }
                catch (NumberFormatException e) {
                    CPU.handleTypeConversionError(ctx, sf, j, "string", "float");
                }
                break;
            }
            case 140: {
                int i = operands[0];
                int j = operands[1];
                sf.intRegs[j] = Boolean.parseBoolean(sf.stringRegs[i]) ? 1 : 0;
                break;
            }
            case 141: {
                int i = operands[0];
                int j = operands[1];
                String str = StringEscapeUtils.escapeJson((String)sf.stringRegs[i]);
                sf.refRegs[j] = str == null ? null : new BJSON("\"" + str + "\"");
                break;
            }
            case 142: {
                int i = operands[0];
                int j = operands[1];
                sf.longRegs[j] = sf.intRegs[i];
                break;
            }
            case 143: {
                int i = operands[0];
                int j = operands[1];
                sf.doubleRegs[j] = sf.intRegs[i];
                break;
            }
            case 144: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.intRegs[i] == 1 ? "true" : "false";
                break;
            }
            case 151: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.refRegs[j] = XMLUtils.tableToXML((BTable)bRefType, ctx.isInTransaction());
                }
                catch (Exception e) {
                    sf.refRegs[j] = null;
                    CPU.handleTypeConversionError(ctx, sf, j, "table", "xml");
                }
                break;
            }
            case 150: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    CPU.handleNullRefError(ctx);
                    break;
                }
                try {
                    sf.refRegs[j] = JSONUtils.toJSON((BTable)bRefType, ctx.isInTransaction());
                }
                catch (Exception e) {
                    CPU.handleTypeConversionError(ctx, sf, j, "table", "xml");
                }
                break;
            }
            case 152: {
                CPU.convertStructToMap(ctx, operands, sf);
                break;
            }
            case 153: {
                CPU.convertStructToJSON(ctx, operands, sf);
                break;
            }
            case 154: {
                CPU.convertMapToStruct(ctx, operands, sf);
                break;
            }
            case 155: {
                CPU.convertJSONToStruct(ctx, operands, sf);
                break;
            }
            case 237: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    sf.refRegs[j] = null;
                    break;
                }
                sf.refRegs[j] = ((BXMLAttributes)sf.refRegs[i]).value();
                break;
            }
            case 158: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                String str = sf.stringRegs[i];
                if (str == null) {
                    sf.refRegs[j] = null;
                    sf.refRegs[k] = null;
                    break;
                }
                try {
                    sf.refRegs[j] = XMLUtils.parse(str);
                    sf.refRegs[k] = null;
                }
                catch (BallerinaException e) {
                    sf.refRegs[j] = null;
                    CPU.handleTypeConversionError(ctx, sf, k, e.getMessage());
                }
                break;
            }
            case 183: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                String str = sf.stringRegs[i];
                try {
                    sf.refRegs[j] = str == null ? null : new BJSON(str);
                    sf.refRegs[k] = null;
                }
                catch (BallerinaException e) {
                    sf.refRegs[j] = null;
                    CPU.handleTypeConversionError(ctx, sf, k, e.getMessage());
                }
                break;
            }
            case 159: {
                int i = operands[0];
                int j = operands[1];
                sf.stringRegs[j] = sf.refRegs[i].stringValue();
                break;
            }
            case 175: {
                int i = operands[0];
                int j = operands[1];
                BRefType<?> bRefType = sf.refRegs[i];
                if (bRefType == null) {
                    sf.stringRegs[j] = BLangConstants.STRING_NULL_VALUE;
                    break;
                }
                sf.stringRegs[j] = bRefType.stringValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void execIteratorOperation(WorkerExecutionContext ctx, WorkerData sf, Instruction instruction) {
        switch (instruction.getOpcode()) {
            case 220: {
                int i = instruction.getOperands()[0];
                int j = instruction.getOperands()[1];
                BCollection collection = (BCollection)((Object)sf.refRegs[i]);
                if (collection == null) {
                    CPU.handleNullRefError(ctx);
                    return;
                }
                sf.refRegs[j] = collection.newIterator();
                break;
            }
            case 221: {
                int i = instruction.getOperands()[0];
                int j = instruction.getOperands()[1];
                BIterator iterator = (BIterator)sf.refRegs[i];
                if (iterator == null) {
                    sf.intRegs[j] = 0;
                    return;
                }
                sf.intRegs[j] = iterator.hasNext() ? 1 : 0;
                break;
            }
            case 222: {
                Instruction.InstructionIteratorNext nextInstruction = (Instruction.InstructionIteratorNext)instruction;
                BIterator iterator = (BIterator)sf.refRegs[nextInstruction.iteratorIndex];
                if (iterator == null) {
                    return;
                }
                BValue[] values = iterator.getNext(nextInstruction.arity);
                CPU.copyValuesToRegistries(nextInstruction.typeTags, nextInstruction.retRegs, values, sf);
            }
        }
    }

    private static void copyValuesToRegistries(int[] typeTags, int[] targetReg, BValue[] values, WorkerData sf) {
        block7: for (int i = 0; i < typeTags.length; ++i) {
            BValue source = values[i];
            int target = targetReg[i];
            switch (typeTags[i]) {
                case 1: {
                    sf.longRegs[target] = ((BInteger)source).intValue();
                    continue block7;
                }
                case 2: {
                    sf.doubleRegs[target] = ((BFloat)source).floatValue();
                    continue block7;
                }
                case 3: {
                    sf.stringRegs[target] = source.stringValue();
                    continue block7;
                }
                case 4: {
                    sf.intRegs[target] = ((BBoolean)source).booleanValue() ? 1 : 0;
                    continue block7;
                }
                case 5: {
                    sf.byteRegs[target] = ((BBlob)source).blobValue();
                    continue block7;
                }
                default: {
                    sf.refRegs[target] = (BRefType)source;
                }
            }
        }
    }

    private static void execXMLCreationOpcodes(WorkerExecutionContext ctx, WorkerData sf, int opcode, int[] operands) {
        switch (opcode) {
            case 242: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                int l = operands[3];
                BXMLQName startTagName = (BXMLQName)sf.refRegs[j];
                BXMLQName endTagName = (BXMLQName)sf.refRegs[k];
                try {
                    sf.refRegs[i] = XMLUtils.createXMLElement(startTagName, endTagName, sf.stringRegs[l]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 243: {
                int i = operands[0];
                int j = operands[1];
                try {
                    sf.refRegs[i] = XMLUtils.createXMLComment(sf.stringRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 244: {
                int i = operands[0];
                int j = operands[1];
                try {
                    sf.refRegs[i] = XMLUtils.createXMLText(sf.stringRegs[j]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 245: {
                int i = operands[0];
                int j = operands[1];
                int k = operands[2];
                try {
                    sf.refRegs[i] = XMLUtils.createXMLProcessingInstruction(sf.stringRegs[j], sf.stringRegs[k]);
                }
                catch (Exception e) {
                    ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
                    CPU.handleError(ctx);
                }
                break;
            }
            case 246: {
                int i = operands[0];
                int j = operands[1];
                BXML xmlVal = (BXML)sf.refRegs[i];
                BXML child = (BXML)sf.refRegs[j];
                xmlVal.addChildren(child);
                break;
            }
            case 250: {
                int i = operands[0];
                sf.refRegs[i] = new BXMLSequence();
            }
        }
    }

    private static boolean handleVariableLock(WorkerExecutionContext ctx, BType[] types, int[] varRegs) {
        boolean lockAcquired = true;
        block7: for (int i = 0; i < varRegs.length && lockAcquired; ++i) {
            BType paramType = types[i];
            int regIndex = varRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockIntField(ctx, regIndex);
                    continue block7;
                }
                case 2: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockFloatField(ctx, regIndex);
                    continue block7;
                }
                case 3: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockStringField(ctx, regIndex);
                    continue block7;
                }
                case 4: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockBooleanField(ctx, regIndex);
                    continue block7;
                }
                case 5: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockBlobField(ctx, regIndex);
                    continue block7;
                }
                default: {
                    lockAcquired = ctx.programFile.getGlobalMemoryBlock().lockRefField(ctx, regIndex);
                }
            }
        }
        return lockAcquired;
    }

    private static void handleVariableUnlock(WorkerExecutionContext ctx, BType[] types, int[] varRegs) {
        block7: for (int i = varRegs.length - 1; i > -1; --i) {
            BType paramType = types[i];
            int regIndex = varRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    ctx.programFile.getGlobalMemoryBlock().unlockIntField(regIndex);
                    continue block7;
                }
                case 2: {
                    ctx.programFile.getGlobalMemoryBlock().unlockFloatField(regIndex);
                    continue block7;
                }
                case 3: {
                    ctx.programFile.getGlobalMemoryBlock().unlockStringField(regIndex);
                    continue block7;
                }
                case 4: {
                    ctx.programFile.getGlobalMemoryBlock().unlockBooleanField(regIndex);
                    continue block7;
                }
                case 5: {
                    ctx.programFile.getGlobalMemoryBlock().unlockBlobField(regIndex);
                    continue block7;
                }
                default: {
                    ctx.programFile.getGlobalMemoryBlock().unlockRefField(regIndex);
                }
            }
        }
    }

    private static boolean debug(WorkerExecutionContext ctx) {
        Debugger debugger = ctx.programFile.getDebugger();
        if (!debugger.isClientSessionActive()) {
            return false;
        }
        DebugContext debugContext = ctx.getDebugContext();
        if (debugContext.isWorkerPaused()) {
            debugContext.setWorkerPaused(false);
            return false;
        }
        LineNumberInfo currentExecLine = debugger.getLineNumber(ctx.callableUnitInfo.getPackageInfo().getPkgPath(), ctx.ip);
        if (currentExecLine.equals(debugContext.getLastLine())) {
            return false;
        }
        if (CPU.debugPointCheck(ctx, currentExecLine, debugger)) {
            return true;
        }
        switch (debugContext.getCurrentCommand()) {
            case RESUME: {
                debugContext.clearLastDebugLine();
                break;
            }
            case STEP_IN: 
            case STEP_OVER: {
                CPU.debugHit(ctx, currentExecLine, debugger);
                return true;
            }
            case STEP_OUT: {
                break;
            }
            default: {
                debugger.notifyExit();
                debugger.stopDebugging();
            }
        }
        return false;
    }

    private static boolean debugPointCheck(WorkerExecutionContext ctx, LineNumberInfo currentExecLine, Debugger debugger) {
        if (!currentExecLine.isDebugPoint()) {
            return false;
        }
        CPU.debugHit(ctx, currentExecLine, debugger);
        return true;
    }

    private static void debugHit(WorkerExecutionContext ctx, LineNumberInfo currentExecLine, Debugger debugger) {
        ctx.getDebugContext().setLastLine(currentExecLine);
        debugger.pauseWorker(ctx);
        debugger.notifyDebugHit(ctx, currentExecLine, ctx.getDebugContext().getWorkerId());
    }

    private static void handleAnyToRefTypeCast(WorkerExecutionContext ctx, WorkerData sf, int[] operands, BType targetType) {
        int i = operands[0];
        int j = operands[1];
        BRefType<?> bRefType = sf.refRegs[i];
        if (bRefType == null) {
            sf.refRegs[j] = null;
        } else if (bRefType.getType() == targetType) {
            sf.refRegs[j] = bRefType;
        } else {
            CPU.handleTypeCastError(ctx, sf, j, bRefType.getType(), targetType);
        }
    }

    private static void handleTypeCastError(WorkerExecutionContext ctx, WorkerData sf, int errorRegIndex, BType sourceType, BType targetType) {
        CPU.handleTypeCastError(ctx, sf, errorRegIndex, sourceType.toString(), targetType.toString());
    }

    private static void handleTypeCastError(WorkerExecutionContext ctx, WorkerData sf, int errorRegIndex, String sourceType, String targetType) {
        BStruct errorVal;
        sf.refRegs[errorRegIndex] = errorVal = BLangVMErrors.createTypeCastError(ctx, sourceType, targetType);
    }

    private static void handleTypeConversionError(WorkerExecutionContext ctx, WorkerData sf, int errorRegIndex, String sourceTypeName, String targetTypeName) {
        String errorMsg = "'" + sourceTypeName + "' cannot be converted to '" + targetTypeName + "'";
        CPU.handleTypeConversionError(ctx, sf, errorRegIndex, errorMsg);
    }

    private static void handleTypeConversionError(WorkerExecutionContext ctx, WorkerData sf, int errorRegIndex, String errorMessage) {
        BStruct errorVal = BLangVMErrors.createTypeConversionError(ctx, errorMessage);
        if (errorRegIndex == -1) {
            ctx.setError(errorVal);
            CPU.handleError(ctx);
            return;
        }
        sf.refRegs[errorRegIndex] = errorVal;
    }

    private static void createNewIntRange(int[] operands, WorkerData sf) {
        long startValue = sf.longRegs[operands[0]];
        long endValue = sf.longRegs[operands[1]];
        sf.refRegs[operands[2]] = new BIntRange(startValue, endValue);
    }

    private static void createNewConnector(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        BConnector bConnector;
        int cpIndex = operands[0];
        int i = operands[1];
        StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)ctx.constPool[cpIndex];
        ConnectorInfo connectorInfo = (ConnectorInfo)structureRefCPEntry.getStructureTypeInfo();
        sf.refRegs[i] = bConnector = new BConnector(connectorInfo.getType());
    }

    private static void createNewStruct(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int cpIndex = operands[0];
        int i = operands[1];
        StructureRefCPEntry structureRefCPEntry = (StructureRefCPEntry)ctx.constPool[cpIndex];
        StructInfo structInfo = (StructInfo)structureRefCPEntry.getStructureTypeInfo();
        sf.refRegs[i] = new BStruct(structInfo.getType());
    }

    private static void beginTransaction(WorkerExecutionContext ctx, int transactionBlockId, int retryCountRegIndex, int committedFuncIndex, int abortedFuncIndex) {
        LocalTransactionInfo localTransactionInfo;
        FunctionRefCPEntry funcRefCPEntry;
        boolean isGlobalTransactionEnabled = ctx.getGlobalTransactionEnabled();
        int retryCount = 3;
        if (retryCountRegIndex != -1 && (retryCount = (int)ctx.workerLocal.longRegs[retryCountRegIndex]) < 0) {
            ctx.setError(BLangVMErrors.createError(ctx, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RETRY_COUNT, new Object[0])));
            CPU.handleError(ctx);
            return;
        }
        if (committedFuncIndex != -1) {
            funcRefCPEntry = (FunctionRefCPEntry)ctx.constPool[committedFuncIndex];
            BFunctionPointer fpCommitted = new BFunctionPointer(funcRefCPEntry);
            TransactionResourceManager.getInstance().registerCommittedFunction(transactionBlockId, fpCommitted);
        }
        if (abortedFuncIndex != -1) {
            funcRefCPEntry = (FunctionRefCPEntry)ctx.constPool[abortedFuncIndex];
            BFunctionPointer fpAborted = new BFunctionPointer(funcRefCPEntry);
            TransactionResourceManager.getInstance().registerAbortedFunction(transactionBlockId, fpAborted);
        }
        if ((localTransactionInfo = ctx.getLocalTransactionInfo()) == null) {
            String globalTransactionId;
            String protocol = null;
            String url = null;
            if (isGlobalTransactionEnabled) {
                BValue[] returns = TransactionUtils.notifyTransactionBegin(ctx, null, null, transactionBlockId, "2pc");
                BStruct txDataStruct = (BStruct)returns[0];
                globalTransactionId = txDataStruct.getStringField(1);
                protocol = txDataStruct.getStringField(2);
                url = txDataStruct.getStringField(3);
            } else {
                globalTransactionId = UUID.randomUUID().toString().replaceAll("-", "");
            }
            localTransactionInfo = new LocalTransactionInfo(globalTransactionId, url, protocol);
            ctx.setLocalTransactionInfo(localTransactionInfo);
        } else if (isGlobalTransactionEnabled) {
            TransactionUtils.notifyTransactionBegin(ctx, localTransactionInfo.getGlobalTransactionId(), localTransactionInfo.getURL(), transactionBlockId, localTransactionInfo.getProtocol());
        }
        localTransactionInfo.beginTransactionBlock(transactionBlockId, retryCount);
    }

    private static void retryTransaction(WorkerExecutionContext ctx, int transactionBlockId, int startOfAbortIP, int startOfNoThrowEndIP) {
        LocalTransactionInfo localTransactionInfo = ctx.getLocalTransactionInfo();
        if (!localTransactionInfo.isRetryPossible(ctx, transactionBlockId)) {
            ctx.ip = ctx.getError() == null ? startOfNoThrowEndIP : ("TransactionError".equals(ctx.getError().getStringField(0)) ? startOfNoThrowEndIP : startOfAbortIP);
        }
        localTransactionInfo.incrementCurrentRetryCount(transactionBlockId);
    }

    private static void endTransaction(WorkerExecutionContext ctx, int transactionBlockId, int status) {
        LocalTransactionInfo localTransactionInfo = ctx.getLocalTransactionInfo();
        boolean isGlobalTransactionEnabled = ctx.getGlobalTransactionEnabled();
        try {
            if (status == TransactionStatus.FAILED.value()) {
                boolean notifyCoordinator = localTransactionInfo.onTransactionFailed(ctx, transactionBlockId);
                if (notifyCoordinator) {
                    if (isGlobalTransactionEnabled) {
                        TransactionUtils.notifyTransactionAbort(ctx, localTransactionInfo.getGlobalTransactionId(), transactionBlockId);
                    } else {
                        TransactionResourceManager.getInstance().notifyAbort(localTransactionInfo.getGlobalTransactionId(), transactionBlockId, false);
                    }
                }
            } else if (status == TransactionStatus.ABORTED.value()) {
                if (isGlobalTransactionEnabled) {
                    TransactionUtils.notifyTransactionAbort(ctx, localTransactionInfo.getGlobalTransactionId(), transactionBlockId);
                } else {
                    TransactionResourceManager.getInstance().notifyAbort(localTransactionInfo.getGlobalTransactionId(), transactionBlockId, false);
                }
            } else if (status == TransactionStatus.SUCCESS.value()) {
                if (!isGlobalTransactionEnabled) {
                    TransactionResourceManager.getInstance().prepare(localTransactionInfo.getGlobalTransactionId(), transactionBlockId);
                    TransactionResourceManager.getInstance().notifyCommit(localTransactionInfo.getGlobalTransactionId(), transactionBlockId);
                }
            } else if (status == TransactionStatus.END.value()) {
                boolean isOuterTx = localTransactionInfo.onTransactionEnd(transactionBlockId);
                if (isGlobalTransactionEnabled) {
                    TransactionUtils.notifyTransactionEnd(ctx, localTransactionInfo.getGlobalTransactionId(), transactionBlockId);
                }
                if (isOuterTx) {
                    BLangVMUtils.removeTransactionInfo(ctx);
                }
            }
        }
        catch (Throwable e) {
            ctx.setError(BLangVMErrors.createError(ctx, e.getMessage()));
            CPU.handleError(ctx);
        }
    }

    private static WorkerExecutionContext invokeVirtualFunction(WorkerExecutionContext ctx, int receiver, FunctionInfo virtualFuncInfo, int[] argRegs, int[] retRegs, int flags) {
        BStruct structVal = (BStruct)ctx.workerLocal.refRegs[receiver];
        if (structVal == null) {
            ctx.setError(BLangVMErrors.createNullRefException(ctx));
            CPU.handleError(ctx);
            return null;
        }
        StructInfo structInfo = structVal.getType().structInfo;
        AttachedFunctionInfo attachedFuncInfo = structInfo.funcInfoEntries.get(virtualFuncInfo.getName());
        FunctionInfo concreteFuncInfo = attachedFuncInfo.functionInfo;
        return BLangFunctions.invokeCallable(concreteFuncInfo, ctx, argRegs, retRegs, false, flags);
    }

    private static WorkerExecutionContext invokeAction(WorkerExecutionContext ctx, String actionName, int[] argRegs, int[] retRegs, int flags) {
        BConnector connector = (BConnector)ctx.workerLocal.refRegs[argRegs[0]];
        if (connector == null) {
            ctx.setError(BLangVMErrors.createNullRefException(ctx));
            CPU.handleError(ctx);
            return null;
        }
        BConnectorType actualCon = (BConnectorType)connector.getConnectorType();
        ActionInfo actionInfo = ctx.programFile.getPackageInfo(actualCon.getPackagePath()).getConnectorInfo(actualCon.getName()).getActionInfo(actionName);
        return BLangFunctions.invokeCallable(actionInfo, ctx, argRegs, retRegs, false, flags);
    }

    private static void handleWorkerSend(WorkerExecutionContext ctx, WorkerDataChannelInfo workerDataChannelInfo, BType type, int reg) {
        BRefType val = CPU.extractValue(ctx.workerLocal, type, reg);
        WorkerDataChannel dataChannel = CPU.getWorkerChannel(ctx, workerDataChannelInfo.getChannelName());
        dataChannel.putData(val);
    }

    private static WorkerDataChannel getWorkerChannel(WorkerExecutionContext ctx, String name) {
        return ctx.respCtx.getWorkerDataChannel(name);
    }

    private static BRefType extractValue(WorkerData data, BType type, int reg) {
        BValueType result;
        switch (type.getTag()) {
            case 1: {
                result = new BInteger(data.longRegs[reg]);
                break;
            }
            case 2: {
                result = new BFloat(data.doubleRegs[reg]);
                break;
            }
            case 3: {
                result = new BString(data.stringRegs[reg]);
                break;
            }
            case 4: {
                result = new BBoolean(data.intRegs[reg] > 0);
                break;
            }
            case 5: {
                result = new BBlob(data.byteRegs[reg]);
                break;
            }
            default: {
                result = data.refRegs[reg];
            }
        }
        return result;
    }

    private static WorkerExecutionContext invokeForkJoin(WorkerExecutionContext ctx, Instruction.InstructionFORKJOIN forkJoinIns) {
        ForkjoinInfo forkjoinInfo = forkJoinIns.forkJoinCPEntry.getForkjoinInfo();
        return BLangFunctions.invokeForkJoin(ctx, forkjoinInfo, forkJoinIns.joinBlockAddr, forkJoinIns.joinVarRegIndex, forkJoinIns.timeoutRegIndex, forkJoinIns.timeoutBlockAddr, forkJoinIns.timeoutVarRegIndex);
    }

    private static boolean handleWorkerReceive(WorkerExecutionContext ctx, WorkerDataChannelInfo workerDataChannelInfo, BType type, int reg) {
        BRefType passedInValue = CPU.getWorkerChannel(ctx, workerDataChannelInfo.getChannelName()).tryTakeData(ctx);
        if (passedInValue != null) {
            WorkerData currentFrame = ctx.workerLocal;
            CPU.copyArgValueForWorkerReceive(currentFrame, reg, type, passedInValue);
            return true;
        }
        return false;
    }

    public static void copyArgValueForWorkerReceive(WorkerData currentSF, int regIndex, BType paramType, BRefType passedInValue) {
        switch (paramType.getTag()) {
            case 1: {
                currentSF.longRegs[regIndex] = ((BInteger)passedInValue).intValue();
                break;
            }
            case 2: {
                currentSF.doubleRegs[regIndex] = ((BFloat)passedInValue).floatValue();
                break;
            }
            case 3: {
                currentSF.stringRegs[regIndex] = passedInValue.stringValue();
                break;
            }
            case 4: {
                currentSF.intRegs[regIndex] = ((BBoolean)passedInValue).booleanValue() ? 1 : 0;
                break;
            }
            case 5: {
                currentSF.byteRegs[regIndex] = ((BBlob)passedInValue).blobValue();
                break;
            }
            default: {
                currentSF.refRegs[regIndex] = passedInValue;
            }
        }
    }

    public static void copyValues(WorkerExecutionContext ctx, WorkerData parent, WorkerData workerSF) {
        CodeAttributeInfo codeInfo = ctx.parent.callableUnitInfo.getDefaultWorkerInfo().getCodeAttributeInfo();
        System.arraycopy(parent.longRegs, 0, workerSF.longRegs, 0, codeInfo.getMaxLongLocalVars());
        System.arraycopy(parent.doubleRegs, 0, workerSF.doubleRegs, 0, codeInfo.getMaxDoubleLocalVars());
        System.arraycopy(parent.intRegs, 0, workerSF.intRegs, 0, codeInfo.getMaxIntLocalVars());
        System.arraycopy(parent.stringRegs, 0, workerSF.stringRegs, 0, codeInfo.getMaxStringLocalVars());
        System.arraycopy(parent.byteRegs, 0, workerSF.byteRegs, 0, codeInfo.getMaxByteLocalVars());
        System.arraycopy(parent.refRegs, 0, workerSF.refRegs, 0, codeInfo.getMaxRefLocalVars());
    }

    public static void copyArgValues(WorkerData callerSF, WorkerData calleeSF, int[] argRegs, BType[] paramTypes) {
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int refRegIndex = -1;
        int blobRegIndex = -1;
        block7: for (int i = 0; i < argRegs.length; ++i) {
            BType paramType = paramTypes[i];
            int argReg = argRegs[i];
            switch (paramType.getTag()) {
                case 1: {
                    calleeSF.longRegs[++longRegIndex] = callerSF.longRegs[argReg];
                    continue block7;
                }
                case 2: {
                    calleeSF.doubleRegs[++doubleRegIndex] = callerSF.doubleRegs[argReg];
                    continue block7;
                }
                case 3: {
                    calleeSF.stringRegs[++stringRegIndex] = callerSF.stringRegs[argReg];
                    continue block7;
                }
                case 4: {
                    calleeSF.intRegs[++booleanRegIndex] = callerSF.intRegs[argReg];
                    continue block7;
                }
                case 5: {
                    calleeSF.byteRegs[++blobRegIndex] = callerSF.byteRegs[argReg];
                    continue block7;
                }
                default: {
                    calleeSF.refRegs[++refRegIndex] = callerSF.refRegs[argReg];
                }
            }
        }
    }

    private static WorkerExecutionContext handleReturn(WorkerExecutionContext ctx) {
        BLangScheduler.workerDone(ctx);
        return ctx.respCtx.signal(new WorkerSignal(ctx, SignalType.RETURN, ctx.workerResult));
    }

    public static boolean isAssignable(BValue rhsValue, BType lhsType) {
        if (rhsValue == null) {
            return false;
        }
        BType rhsType = rhsValue.getType();
        if (rhsType.equals(lhsType)) {
            return true;
        }
        if (rhsType.getTag() == 1 && (lhsType.getTag() == 9 || lhsType.getTag() == 2)) {
            return true;
        }
        if (rhsType.getTag() == 2 && lhsType.getTag() == 9) {
            return true;
        }
        if (rhsType.getTag() == 3 && lhsType.getTag() == 9) {
            return true;
        }
        if (rhsType.getTag() == 4 && lhsType.getTag() == 9) {
            return true;
        }
        if (CPU.getElementType(lhsType).getTag() == 9 && CPU.getElementType(rhsType).getTag() == 9) {
            return CPU.checkJSONCast(((BJSON)rhsValue).value(), rhsType, lhsType);
        }
        if (rhsType.getTag() == 15 && lhsType.getTag() == 15) {
            return CPU.checkStructEquivalency((BStructType)rhsType, (BStructType)lhsType);
        }
        if (lhsType.getTag() == 6) {
            return true;
        }
        if (lhsType.getTag() == 16 || rhsType.getTag() == 16) {
            return CPU.checkArrayCast(rhsType, lhsType);
        }
        if (rhsType.getTag() == 7 && lhsType.getTag() == 7) {
            return CPU.checkMapCast(rhsType, lhsType);
        }
        if (rhsType.getTag() == 11 && lhsType.getTag() == 11) {
            return true;
        }
        if (rhsType.getTag() == 25 && lhsType.getTag() == 25) {
            return true;
        }
        return rhsType.getTag() == 14 && lhsType.getTag() == 14;
    }

    private static boolean checkCast(BValue rhsValue, BType lhsType) {
        BType rhsType = BTypes.typeNull;
        if (rhsValue != null) {
            rhsType = rhsValue.getType();
        }
        if (rhsType.equals(lhsType)) {
            return true;
        }
        if (rhsType.getTag() == 15 && lhsType.getTag() == 15) {
            return CPU.checkStructEquivalency((BStructType)rhsType, (BStructType)lhsType);
        }
        if (lhsType.getTag() == 6) {
            return true;
        }
        if (CPU.getElementType(rhsType).getTag() == 9) {
            return CPU.checkJSONCast(((BJSON)rhsValue).value(), rhsType, lhsType);
        }
        if (lhsType.getTag() == 16 || rhsType.getTag() == 16) {
            return CPU.checkArrayCast(rhsType, lhsType);
        }
        if (rhsType.getTag() == 7 && lhsType.getTag() == 7) {
            return CPU.checkMapCast(rhsType, lhsType);
        }
        return false;
    }

    private static boolean checkMapCast(BType sourceType, BType targetType) {
        BMapType sourceMapType = (BMapType)sourceType;
        BMapType targetMapType = (BMapType)targetType;
        if (sourceMapType.equals(targetMapType)) {
            return true;
        }
        if (sourceMapType.getConstrainedType().getTag() == 15 && targetMapType.getConstrainedType().getTag() == 15) {
            return CPU.checkStructEquivalency((BStructType)sourceMapType.getConstrainedType(), (BStructType)targetMapType.getConstrainedType());
        }
        return false;
    }

    private static boolean checkArrayCast(BType sourceType, BType targetType) {
        if (targetType.getTag() == 16 && sourceType.getTag() == 16) {
            BArrayType sourceArrayType = (BArrayType)sourceType;
            BArrayType targetArrayType = (BArrayType)targetType;
            if (targetArrayType.getDimensions() > sourceArrayType.getDimensions()) {
                return false;
            }
            return CPU.checkArrayCast(sourceArrayType.getElementType(), targetArrayType.getElementType());
        }
        if (sourceType.getTag() == 16) {
            return targetType.getTag() == 6;
        }
        return sourceType.equals(targetType);
    }

    private static BType getElementType(BType type) {
        if (type.getTag() != 16) {
            return type;
        }
        return CPU.getElementType(((BArrayType)type).getElementType());
    }

    public static boolean checkStructEquivalency(BStructType rhsType, BStructType lhsType) {
        int lhsAttachedFunctionCount;
        if (Flags.isFlagOn(lhsType.flags ^ rhsType.flags, 1)) {
            return false;
        }
        if (!Flags.isFlagOn(lhsType.flags, 1) && !rhsType.getPackagePath().equals(lhsType.getPackagePath())) {
            return false;
        }
        int n = lhsAttachedFunctionCount = lhsType.initializer != null ? lhsType.getAttachedFunctions().length - 1 : lhsType.getAttachedFunctions().length;
        if (lhsType.getStructFields().length > rhsType.getStructFields().length || lhsAttachedFunctionCount > rhsType.getAttachedFunctions().length) {
            return false;
        }
        return !Flags.isFlagOn(lhsType.flags, 1) && rhsType.getPackagePath().equals(lhsType.getPackagePath()) ? CPU.checkEquivalencyOfTwoPrivateStructs(lhsType, rhsType) : CPU.checkEquivalencyOfPublicStructs(lhsType, rhsType);
    }

    private static boolean checkEquivalencyOfTwoPrivateStructs(BStructType lhsType, BStructType rhsType) {
        for (int fieldCounter = 0; fieldCounter < lhsType.getStructFields().length; ++fieldCounter) {
            BStructType.StructField lhsField = lhsType.getStructFields()[fieldCounter];
            BStructType.StructField rhsField = rhsType.getStructFields()[fieldCounter];
            if (lhsField.fieldName.equals(rhsField.fieldName) && CPU.isSameType(rhsField.fieldType, lhsField.fieldType)) continue;
            return false;
        }
        BStructType.AttachedFunction[] lhsFuncs = lhsType.getAttachedFunctions();
        BStructType.AttachedFunction[] rhsFuncs = rhsType.getAttachedFunctions();
        for (BStructType.AttachedFunction lhsFunc : lhsFuncs) {
            BStructType.AttachedFunction rhsFunc;
            if (lhsFunc == lhsType.initializer || lhsFunc == lhsType.defaultsValuesInitFunc || (rhsFunc = CPU.getMatchingInvokableType(rhsFuncs, lhsFunc)) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean checkEquivalencyOfPublicStructs(BStructType lhsType, BStructType rhsType) {
        int fieldCounter;
        for (fieldCounter = 0; fieldCounter < lhsType.getStructFields().length; ++fieldCounter) {
            BStructType.StructField lhsField = lhsType.getStructFields()[fieldCounter];
            BStructType.StructField rhsField = rhsType.getStructFields()[fieldCounter];
            if (!Flags.isFlagOn(lhsField.flags, 1) || !Flags.isFlagOn(rhsField.flags, 1)) {
                return false;
            }
            if (lhsField.fieldName.equals(rhsField.fieldName) && CPU.isSameType(rhsField.fieldType, lhsField.fieldType)) continue;
            return false;
        }
        while (fieldCounter < rhsType.getStructFields().length) {
            if (!Flags.isFlagOn(rhsType.getStructFields()[fieldCounter].flags, 1)) {
                return false;
            }
            ++fieldCounter;
        }
        BStructType.AttachedFunction[] lhsFuncs = lhsType.getAttachedFunctions();
        BStructType.AttachedFunction[] rhsFuncs = rhsType.getAttachedFunctions();
        for (BStructType.AttachedFunction lhsFunc : lhsFuncs) {
            if (lhsFunc == lhsType.initializer || lhsFunc == lhsType.defaultsValuesInitFunc) continue;
            if (!Flags.isFlagOn(lhsFunc.flags, 1)) {
                return false;
            }
            BStructType.AttachedFunction rhsFunc = CPU.getMatchingInvokableType(rhsFuncs, lhsFunc);
            if (rhsFunc != null && Flags.isFlagOn(rhsFunc.flags, 1)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFunctionTypeEquality(BFunctionType source, BFunctionType target) {
        int i;
        if (source.paramTypes.length != target.paramTypes.length || source.retParamTypes.length != target.retParamTypes.length) {
            return false;
        }
        for (i = 0; i < source.paramTypes.length; ++i) {
            if (CPU.isSameType(source.paramTypes[i], target.paramTypes[i])) continue;
            return false;
        }
        for (i = 0; i < source.retParamTypes.length; ++i) {
            if (CPU.isSameType(source.retParamTypes[i], target.retParamTypes[i])) continue;
            return false;
        }
        return true;
    }

    private static BStructType.AttachedFunction getMatchingInvokableType(BStructType.AttachedFunction[] rhsFuncs, BStructType.AttachedFunction lhsFunc) {
        return Arrays.stream(rhsFuncs).filter(rhsFunc -> attachedFunction.funcName.equals(rhsFunc.funcName)).filter(rhsFunc -> CPU.checkFunctionTypeEquality(attachedFunction.type, rhsFunc.type)).findFirst().orElse(null);
    }

    private static boolean isSameType(BType rhsType, BType lhsType) {
        if (rhsType == lhsType) {
            return true;
        }
        if (rhsType.getTag() == lhsType.getTag() && rhsType.getTag() == 16) {
            return CPU.checkArrayEquivalent(rhsType, lhsType);
        }
        if (rhsType.getTag() == 7 && lhsType.getTag() == 7) {
            return lhsType.equals(rhsType);
        }
        return false;
    }

    private static boolean checkArrayEquivalent(BType actualType, BType expType) {
        if (expType.getTag() == 16 && actualType.getTag() == 16) {
            BArrayType lhrArrayType = (BArrayType)expType;
            BArrayType rhsArrayType = (BArrayType)actualType;
            return CPU.checkArrayEquivalent(lhrArrayType.getElementType(), rhsArrayType.getElementType());
        }
        return expType == actualType;
    }

    private static void castJSONToInt(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        JsonNode jsonNode;
        int i = operands[0];
        int j = operands[1];
        BJSON jsonValue = (BJSON)sf.refRegs[i];
        if (jsonValue == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            jsonNode = jsonValue.value();
        }
        catch (BallerinaException e) {
            String errorMsg = BLangExceptionHelper.getErrorMessage(RuntimeErrors.CASTING_FAILED_WITH_CAUSE, BTypes.typeJSON, BTypes.typeInt, e.getMessage());
            ctx.setError(BLangVMErrors.createError(ctx, errorMsg));
            CPU.handleError(ctx);
            return;
        }
        if (jsonNode.isLong()) {
            sf.longRegs[j] = jsonNode.longValue();
            return;
        }
        sf.longRegs[j] = 0L;
    }

    private static void castJSONToFloat(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        JsonNode jsonNode;
        int i = operands[0];
        int j = operands[1];
        BJSON jsonValue = (BJSON)sf.refRegs[i];
        if (jsonValue == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            jsonNode = jsonValue.value();
        }
        catch (BallerinaException e) {
            String errorMsg = BLangExceptionHelper.getErrorMessage(RuntimeErrors.CASTING_FAILED_WITH_CAUSE, BTypes.typeJSON, BTypes.typeFloat, e.getMessage());
            ctx.setError(BLangVMErrors.createError(ctx, errorMsg));
            CPU.handleError(ctx);
            return;
        }
        if (jsonNode.isDouble()) {
            sf.doubleRegs[j] = jsonNode.doubleValue();
            return;
        }
        sf.doubleRegs[j] = 0.0;
    }

    private static void castJSONToString(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        JsonNode jsonNode;
        int i = operands[0];
        int j = operands[1];
        BJSON jsonValue = (BJSON)sf.refRegs[i];
        if (jsonValue == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            jsonNode = jsonValue.value();
        }
        catch (BallerinaException e) {
            sf.stringRegs[j] = "";
            String errorMsg = BLangExceptionHelper.getErrorMessage(RuntimeErrors.CASTING_FAILED_WITH_CAUSE, BTypes.typeJSON, BTypes.typeString, e.getMessage());
            ctx.setError(BLangVMErrors.createError(ctx, errorMsg));
            CPU.handleError(ctx);
            return;
        }
        if (jsonNode.isString()) {
            sf.stringRegs[j] = jsonNode.stringValue();
            return;
        }
        sf.stringRegs[j] = BLangConstants.STRING_NULL_VALUE;
    }

    private static void castJSONToBoolean(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        JsonNode jsonNode;
        int i = operands[0];
        int j = operands[1];
        BJSON jsonValue = (BJSON)sf.refRegs[i];
        if (jsonValue == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            jsonNode = jsonValue.value();
        }
        catch (BallerinaException e) {
            String errorMsg = BLangExceptionHelper.getErrorMessage(RuntimeErrors.CASTING_FAILED_WITH_CAUSE, BTypes.typeJSON, BTypes.typeBoolean, e.getMessage());
            ctx.setError(BLangVMErrors.createError(ctx, errorMsg));
            CPU.handleError(ctx);
            return;
        }
        if (jsonNode.isBoolean()) {
            sf.intRegs[j] = jsonNode.booleanValue() ? 1 : 0;
            return;
        }
        sf.intRegs[j] = 0;
    }

    private static boolean checkJSONEquivalency(JsonNode json, BJSONType sourceType, BJSONType targetType) {
        BStructType sourceConstrainedType = (BStructType)sourceType.getConstrainedType();
        BStructType targetConstrainedType = (BStructType)targetType.getConstrainedType();
        if (targetConstrainedType == null) {
            return true;
        }
        if (sourceConstrainedType != null) {
            if (sourceConstrainedType.equals(targetConstrainedType)) {
                return true;
            }
            return CPU.checkStructEquivalency(sourceConstrainedType, targetConstrainedType);
        }
        BStructType.StructField[] tFields = targetConstrainedType.getStructFields();
        for (int i = 0; i < tFields.length; ++i) {
            String fieldName = tFields[i].getFieldName();
            if (!json.has(fieldName)) {
                return false;
            }
            if (CPU.checkJSONCast(json.get(fieldName), sourceType, tFields[i].getFieldType())) continue;
            return false;
        }
        return true;
    }

    private static boolean checkJSONCast(JsonNode json, BType sourceType, BType targetType) {
        switch (targetType.getTag()) {
            case 3: {
                return json.isString();
            }
            case 1: {
                return json.isLong();
            }
            case 2: {
                return json.isDouble();
            }
            case 16: {
                if (!json.isArray()) {
                    return false;
                }
                BArrayType arrayType = (BArrayType)targetType;
                for (int i = 0; i < json.size(); ++i) {
                    BType sourceElementType;
                    BType bType = sourceElementType = sourceType.getTag() == 16 ? ((BArrayType)sourceType).getElementType() : sourceType;
                    if (CPU.checkJSONCast(json.get(i), sourceElementType, arrayType.getElementType())) continue;
                    return false;
                }
                return true;
            }
            case 9: {
                if (sourceType.getTag() != 9) {
                    return false;
                }
                return CPU.checkJSONEquivalency(json, (BJSONType)sourceType, (BJSONType)targetType);
            }
        }
        return false;
    }

    private static void convertStructToMap(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int i = operands[0];
        int j = operands[1];
        BStruct bStruct = (BStruct)sf.refRegs[i];
        if (bStruct == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int blobRegIndex = -1;
        int refRegIndex = -1;
        BStructType.StructField[] structFields = bStruct.getType().getStructFields();
        BMap map = (BMap)BTypes.typeMap.getEmptyValue();
        block7: for (BStructType.StructField structField : structFields) {
            String key = structField.getFieldName();
            BType fieldType = structField.getFieldType();
            switch (fieldType.getTag()) {
                case 1: {
                    map.put(key, new BInteger(bStruct.getIntField(++longRegIndex)));
                    continue block7;
                }
                case 2: {
                    map.put(key, new BFloat(bStruct.getFloatField(++doubleRegIndex)));
                    continue block7;
                }
                case 3: {
                    map.put(key, new BString(bStruct.getStringField(++stringRegIndex)));
                    continue block7;
                }
                case 4: {
                    map.put(key, new BBoolean(bStruct.getBooleanField(++booleanRegIndex) == 1));
                    continue block7;
                }
                case 5: {
                    map.put(key, new BBlob(bStruct.getBlobField(++blobRegIndex)));
                    continue block7;
                }
                default: {
                    BRefType value = bStruct.getRefField(++refRegIndex);
                    map.put(key, value == null ? null : value.copy());
                }
            }
        }
        sf.refRegs[j] = map;
    }

    private static void convertStructToJSON(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        BJSONType targetType = (BJSONType)((TypeRefCPEntry)ctx.constPool[cpIndex]).getType();
        BStruct bStruct = (BStruct)sf.refRegs[i];
        if (bStruct == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            sf.refRegs[j] = JSONUtils.convertStructToJSON(bStruct, targetType);
        }
        catch (Exception e) {
            String errorMsg = "cannot convert '" + bStruct.getType() + "' to type '" + targetType + "': " + e.getMessage();
            CPU.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void convertMapToStruct(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
        BMap bMap = (BMap)sf.refRegs[i];
        if (bMap == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        int longRegIndex = -1;
        int doubleRegIndex = -1;
        int stringRegIndex = -1;
        int booleanRegIndex = -1;
        int blobRegIndex = -1;
        int refRegIndex = -1;
        BStructType structType = (BStructType)typeRefCPEntry.getType();
        BStruct bStruct = new BStruct(structType);
        StructInfo structInfo = ctx.callableUnitInfo.getPackageInfo().getStructInfo(structType.getName());
        Set keys = bMap.keySet();
        block9: for (StructFieldInfo fieldInfo : structInfo.getFieldInfoEntries()) {
            String key = fieldInfo.getName();
            BType fieldType = fieldInfo.getFieldType();
            BValue mapVal = null;
            try {
                boolean containsField = keys.contains(key);
                DefaultValueAttributeInfo defaultValAttrInfo = null;
                if (containsField) {
                    mapVal = (BValue)bMap.get(key);
                    if (mapVal == null && BTypes.isValueType(fieldType)) {
                        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_FIELD_TYPE_FOR_CASTING, key, fieldType, null);
                    }
                    if (mapVal != null && !CPU.checkCast(mapVal, fieldType)) {
                        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_FIELD_TYPE_FOR_CASTING, key, fieldType, mapVal.getType());
                    }
                } else {
                    defaultValAttrInfo = (DefaultValueAttributeInfo)CPU.getAttributeInfo(fieldInfo, AttributeInfo.Kind.DEFAULT_VALUE_ATTRIBUTE);
                }
                switch (fieldType.getTag()) {
                    case 1: {
                        ++longRegIndex;
                        if (containsField) {
                            bStruct.setIntField(longRegIndex, ((BInteger)mapVal).intValue());
                            break;
                        }
                        if (defaultValAttrInfo == null) continue block9;
                        bStruct.setIntField(longRegIndex, defaultValAttrInfo.getDefaultValue().getIntValue());
                        break;
                    }
                    case 2: {
                        ++doubleRegIndex;
                        if (containsField) {
                            bStruct.setFloatField(doubleRegIndex, ((BFloat)mapVal).floatValue());
                            break;
                        }
                        if (defaultValAttrInfo == null) continue block9;
                        bStruct.setFloatField(doubleRegIndex, defaultValAttrInfo.getDefaultValue().getFloatValue());
                        break;
                    }
                    case 3: {
                        ++stringRegIndex;
                        if (containsField) {
                            bStruct.setStringField(stringRegIndex, ((BString)mapVal).stringValue());
                            break;
                        }
                        if (defaultValAttrInfo == null) continue block9;
                        bStruct.setStringField(stringRegIndex, defaultValAttrInfo.getDefaultValue().getStringValue());
                        break;
                    }
                    case 4: {
                        ++booleanRegIndex;
                        if (containsField) {
                            bStruct.setBooleanField(booleanRegIndex, ((BBoolean)mapVal).booleanValue() ? 1 : 0);
                            break;
                        }
                        if (defaultValAttrInfo == null) continue block9;
                        bStruct.setBooleanField(booleanRegIndex, defaultValAttrInfo.getDefaultValue().getBooleanValue() ? 1 : 0);
                        break;
                    }
                    case 5: {
                        ++blobRegIndex;
                        if (!containsField || mapVal == null) continue block9;
                        bStruct.setBlobField(blobRegIndex, ((BBlob)mapVal).blobValue());
                        break;
                    }
                    default: {
                        bStruct.setRefField(++refRegIndex, (BRefType)mapVal);
                        break;
                    }
                }
            }
            catch (BallerinaException e) {
                sf.refRegs[j] = null;
                String errorMsg = "cannot convert '" + bMap.getType() + "' to type '" + structType + ": " + e.getMessage();
                CPU.handleTypeConversionError(ctx, sf, j, errorMsg);
                return;
            }
        }
        sf.refRegs[j] = bStruct;
    }

    private static void convertJSONToStruct(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
        BJSON bjson = (BJSON)sf.refRegs[i];
        if (bjson == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        try {
            sf.refRegs[j] = JSONUtils.convertJSONToStruct(bjson, (BStructType)typeRefCPEntry.getType());
        }
        catch (Exception e) {
            String errorMsg = "cannot convert 'json' to type '" + typeRefCPEntry.getType() + "': " + e.getMessage();
            CPU.handleTypeConversionError(ctx, sf, j, errorMsg);
        }
    }

    private static void handleNullRefError(WorkerExecutionContext ctx) {
        ctx.setError(BLangVMErrors.createNullRefException(ctx));
        CPU.handleError(ctx);
    }

    public static void handleError(WorkerExecutionContext ctx) {
        int ip = ctx.ip;
        ErrorTableEntry match = ErrorTableEntry.getMatch(ctx.callableUnitInfo.getPackageInfo(), --ip, ctx.getError());
        if (match == null) {
            BLangScheduler.workerExcepted(ctx);
            throw new HandleErrorException(ctx.respCtx.signal(new WorkerSignal(ctx, SignalType.ERROR, ctx.workerResult)));
        }
        ctx.ip = match.getIpTarget();
    }

    private static AttributeInfo getAttributeInfo(AttributeInfoPool attrInfoPool, AttributeInfo.Kind attrInfoKind) {
        for (AttributeInfo attributeInfo : attrInfoPool.getAttributeInfoEntries()) {
            if (attributeInfo.getKind() != attrInfoKind) continue;
            return attributeInfo;
        }
        return null;
    }

    private static void calculateLength(WorkerExecutionContext ctx, int[] operands, WorkerData sf) {
        int i = operands[0];
        int cpIndex = operands[1];
        int j = operands[2];
        TypeRefCPEntry typeRefCPEntry = (TypeRefCPEntry)ctx.constPool[cpIndex];
        int typeTag = typeRefCPEntry.getType().getTag();
        if (typeTag == 3) {
            String value = sf.stringRegs[i];
            if (value == null) {
                CPU.handleNullRefError(ctx);
            } else {
                sf.longRegs[j] = value.length();
            }
            return;
        }
        if (typeTag == 5) {
            sf.longRegs[j] = sf.byteRegs[i].length;
            return;
        }
        BRefType<?> entity = sf.refRegs[i];
        if (entity == null) {
            CPU.handleNullRefError(ctx);
            return;
        }
        if (typeTag == 8) {
            sf.longRegs[j] = ((BXML)entity).length();
            return;
        }
        if (entity instanceof BJSON) {
            sf.longRegs[j] = JSONUtils.isJSONArray((BJSON)entity) ? (long)JSONUtils.getJSONArrayLength((BJSON)sf.refRegs[i]) : -1L;
            return;
        }
        if (typeTag == 7) {
            sf.longRegs[j] = ((BMap)entity).size();
            return;
        }
        BNewArray newArray = (BNewArray)entity;
        sf.longRegs[j] = newArray.size();
    }

    private static WorkerExecutionContext execAwait(WorkerExecutionContext ctx, int[] operands) {
        int futureReg = operands[0];
        int retValReg = operands[1];
        BFuture future = (BFuture)ctx.workerLocal.refRegs[futureReg];
        WorkerResponseContext respCtx = (WorkerResponseContext)future.value();
        if (retValReg != -1) {
            return respCtx.joinTargetContextInfo(ctx, new int[]{retValReg});
        }
        return respCtx.joinTargetContextInfo(ctx, new int[0]);
    }

    public static class HandleErrorException
    extends BallerinaException {
        private static final long serialVersionUID = 1L;
        public WorkerExecutionContext ctx;

        public HandleErrorException(WorkerExecutionContext ctx) {
            this.ctx = ctx;
        }
    }
}

