/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.ArrayDeque;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;

public class VarLock {
    private ArrayDeque<WorkerExecutionContext> current = new ArrayDeque();
    private ArrayDeque<WorkerExecutionContext> waitingForLock = new ArrayDeque();

    public synchronized boolean lock(WorkerExecutionContext ctx) {
        if (this.isLockFree() || this.lockedBySameContext(ctx) || this.lockedByParentContext(ctx)) {
            this.current.offerLast(ctx);
            return true;
        }
        this.waitingForLock.offerLast(ctx);
        BLangScheduler.workerWaitForLock(ctx);
        return false;
    }

    public synchronized void unlock() {
        this.current.removeLast();
        if (!this.waitingForLock.isEmpty()) {
            WorkerExecutionContext ctx = this.waitingForLock.removeFirst();
            BLangScheduler.resume(ctx, ctx.ip - 1, false);
        }
    }

    private boolean isLockFree() {
        return this.current.isEmpty();
    }

    private boolean lockedByParentContext(WorkerExecutionContext ctx) {
        return this.current.getLast() == ctx.parent;
    }

    private boolean lockedBySameContext(WorkerExecutionContext ctx) {
        return this.current.getLast() == ctx;
    }
}

