/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.LinkedList;
import java.util.Queue;
import org.ballerinalang.bre.bvm.BLangScheduler;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.model.values.BRefType;

public class WorkerDataChannel {
    private WorkerExecutionContext pendingCtx;
    private Queue<BRefType> channel = new LinkedList<BRefType>();

    public synchronized void putData(BRefType data) {
        if (data != null) {
            this.channel.add(data);
            if (this.pendingCtx != null) {
                BLangScheduler.resume(this.pendingCtx);
                this.pendingCtx = null;
            }
        }
    }

    public synchronized BRefType tryTakeData(WorkerExecutionContext ctx) {
        BRefType data = this.channel.peek();
        if (data != null) {
            this.channel.remove();
            return data;
        }
        this.pendingCtx = ctx;
        --ctx.ip;
        BLangScheduler.workerWaitForResponse(ctx);
        return null;
    }

    public synchronized BRefType tryTakeData() {
        return this.channel.poll();
    }
}

