/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.bre.bvm;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.bre.bvm.WorkerData;
import org.ballerinalang.bre.bvm.WorkerResponseContext;
import org.ballerinalang.bre.bvm.WorkerState;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.util.codegen.CallableUnitInfo;
import org.ballerinalang.util.codegen.Instruction;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.WorkerInfo;
import org.ballerinalang.util.codegen.cpentries.ConstantPoolEntry;
import org.ballerinalang.util.debugger.DebugCommand;
import org.ballerinalang.util.debugger.DebugContext;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.LocalTransactionInfo;

public class WorkerExecutionContext {
    private static final String WORKER_NAME_NATIVE = "native";
    public WorkerExecutionContext parent;
    public WorkerState state = WorkerState.CREATED;
    public Map<String, Object> globalProps;
    public Map<String, Object> localProps;
    public int ip;
    public boolean stop;
    public ProgramFile programFile;
    public ConstantPoolEntry[] constPool;
    public Instruction[] code;
    public WorkerData workerLocal;
    public WorkerData workerResult;
    public int[] retRegIndexes;
    public CallableUnitInfo callableUnitInfo;
    public WorkerInfo workerInfo;
    public WorkerResponseContext respCtx;
    public boolean runInCaller;
    private BStruct error;
    private DebugContext debugContext;

    public WorkerExecutionContext(ProgramFile programFile) {
        this.programFile = programFile;
        this.globalProps = new HashMap<String, Object>();
        this.runInCaller = true;
        this.setGlobalTransactionEnabled(programFile.isDistributedTransactionEnabled());
    }

    public WorkerExecutionContext(BStruct error) {
        this.error = error;
        this.workerInfo = new WorkerInfo(0, WORKER_NAME_NATIVE);
    }

    public WorkerExecutionContext(WorkerExecutionContext parent, WorkerResponseContext respCtx, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerData workerLocal, WorkerData workerResult, int[] retRegIndexes, boolean runInCaller) {
        this.parent = parent;
        this.respCtx = respCtx;
        this.callableUnitInfo = callableUnitInfo;
        this.workerInfo = workerInfo;
        this.programFile = callableUnitInfo.getPackageInfo().getProgramFile();
        this.constPool = callableUnitInfo.getPackageInfo().getConstPoolEntries();
        this.code = callableUnitInfo.getPackageInfo().getInstructions();
        this.workerLocal = workerLocal;
        this.workerResult = workerResult;
        this.retRegIndexes = retRegIndexes;
        this.globalProps = parent.globalProps;
        this.ip = this.workerInfo.getCodeAttributeInfo().getCodeAddrs();
        this.runInCaller = runInCaller;
        this.initDebugger();
    }

    public WorkerExecutionContext(WorkerExecutionContext parent, WorkerResponseContext respCtx, CallableUnitInfo callableUnitInfo, WorkerInfo workerInfo, WorkerData workerLocal, boolean runInCaller) {
        this.parent = parent;
        this.respCtx = respCtx;
        this.callableUnitInfo = callableUnitInfo;
        this.workerInfo = workerInfo;
        this.programFile = callableUnitInfo.getPackageInfo().getProgramFile();
        this.constPool = callableUnitInfo.getPackageInfo().getConstPoolEntries();
        this.code = callableUnitInfo.getPackageInfo().getInstructions();
        this.workerLocal = workerLocal;
        this.globalProps = parent.globalProps;
        this.ip = this.workerInfo.getCodeAttributeInfo().getCodeAddrs();
        this.runInCaller = runInCaller;
        this.initDebugger();
    }

    private void initDebugger() {
        if (!this.programFile.getDebugger().isDebugEnabled()) {
            return;
        }
        if (this.parent == null) {
            this.debugContext = new DebugContext();
            this.programFile.getDebugger().addWorkerContext(this);
            return;
        }
        DebugContext parentCtx = this.parent.getDebugContext();
        if (parentCtx == null || parentCtx.getCurrentCommand() == DebugCommand.RESUME || parentCtx.getCurrentCommand() == DebugCommand.STEP_OVER || parentCtx.getCurrentCommand() == DebugCommand.STEP_OUT) {
            this.debugContext = new DebugContext();
        } else if (parentCtx.getCurrentCommand() == DebugCommand.STEP_IN) {
            this.debugContext = new DebugContext(DebugCommand.STEP_IN);
        }
        this.programFile.getDebugger().addWorkerContext(this);
    }

    public void setError(BStruct error) {
        this.error = error;
    }

    public BStruct getError() {
        return this.error;
    }

    public boolean isInTransaction() {
        return BLangVMUtils.getTransactionInfo(this) != null;
    }

    public void setLocalTransactionInfo(LocalTransactionInfo localTransactionInfo) {
        BLangVMUtils.setTransactionInfo(this, localTransactionInfo);
    }

    public LocalTransactionInfo getLocalTransactionInfo() {
        return BLangVMUtils.getTransactionInfo(this);
    }

    public void setGlobalTransactionEnabled(boolean isGlobalTransactionEnabled) {
        BLangVMUtils.setGlobalTransactionEnabledStatus(this, isGlobalTransactionEnabled);
    }

    public boolean getGlobalTransactionEnabled() {
        return BLangVMUtils.getGlobalTransactionenabled(this);
    }

    public boolean isRootContext() {
        return this.code == null;
    }

    public DebugContext getDebugContext() {
        return this.debugContext;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\n{ ID: " + this.hashCode() + "\n");
        builder.append("Parent: " + (this.parent != null ? Integer.valueOf(this.parent.hashCode()) : "N/A") + "\n");
        builder.append("Callable Unit: " + (this.callableUnitInfo != null ? this.callableUnitInfo.getName() : "N/A") + "\n");
        builder.append("Worker ID: " + (this.workerInfo != null ? this.workerInfo.getWorkerName() : "N/A") + "\n");
        builder.append("STATE: " + (Object)((Object)this.state) + "\n");
        builder.append("Run In Caller: " + this.runInCaller + "\n");
        builder.append("IP: " + this.ip + "\n");
        return builder.toString();
    }

    public boolean equals(Object rhs) {
        return this == rhs;
    }
}

