/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.api;

import org.ballerinalang.bre.Context;
import org.ballerinalang.bre.bvm.BLangVMStructs;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.connector.api.Struct;
import org.ballerinalang.connector.api.Value;
import org.ballerinalang.connector.impl.ConnectorSPIModelHelper;
import org.ballerinalang.model.types.BServiceType;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.BTypeDescValue;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.codegen.StructInfo;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.program.BLangFunctions;

public final class BLangConnectorSPIUtil {
    public static Struct getConnectorEndpointStruct(Context context) {
        BValue result = context.getRefArgument(0);
        if (result == null || result.getType().getTag() != 15) {
            throw new BallerinaException("Can't get connector endpoint struct");
        }
        return ConnectorSPIModelHelper.createStruct((BStruct)result);
    }

    public static Service getServiceRegistered(Context context) {
        BValue result = context.getRefArgument(1);
        if (result == null || result.getType().getTag() != 20 || ((BTypeDescValue)result).value().getTag() != 23) {
            throw new BallerinaConnectorException("Can't get service reference");
        }
        BServiceType serviceType = (BServiceType)((BTypeDescValue)result).value();
        ProgramFile programFile = context.getProgramFile();
        Service service = BLangConnectorSPIUtil.getService(programFile, serviceType);
        BLangFunctions.invokeServiceInitFunction(service.getServiceInfo().getInitFunctionInfo());
        return service;
    }

    public static BStruct createBStruct(Context context, String pkgPath, String structName, Object ... values) {
        return BLangConnectorSPIUtil.createBStruct(context.getProgramFile(), pkgPath, structName, values);
    }

    public static BStruct createBStruct(ProgramFile programFile, String pkgPath, String structName, Object ... values) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgPath);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("package - " + pkgPath + " does not exist");
        }
        StructInfo structInfo = packageInfo.getStructInfo(structName);
        if (structInfo == null) {
            throw new BallerinaConnectorException("struct - " + structName + " does not exist");
        }
        return BLangVMStructs.createBStruct(structInfo, values);
    }

    public static Struct toStruct(BStruct bStruct) {
        return ConnectorSPIModelHelper.createStruct(bStruct);
    }

    public static Service getServiceFromType(ProgramFile programFile, Value value) {
        if (value == null || value.getType() != Value.Type.TYPEDESC) {
            throw new BallerinaConnectorException("Can't get service reference");
        }
        BTypeDescValue vmValue = (BTypeDescValue)value.getVMValue();
        if (vmValue.value().getTag() != 23) {
            throw new BallerinaConnectorException("Can't get service reference, not service type.");
        }
        return BLangConnectorSPIUtil.getService(programFile, (BServiceType)vmValue.value());
    }

    public static BStruct getPackageEndpoint(ProgramFile programFile, String pkgName, String endpointName) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgName);
        if (packageInfo == null) {
            throw new BallerinaConnectorException("Incorrect package name");
        }
        PackageVarInfo packageVarInfo = packageInfo.getPackageVarInfo(endpointName);
        if (packageVarInfo == null) {
            throw new BallerinaConnectorException("Can't locate " + endpointName + " endpoint variable");
        }
        return (BStruct)programFile.getGlobalMemoryBlock().getRefField(packageVarInfo.getGlobalMemIndex());
    }

    public static Service getService(ProgramFile programFile, BServiceType serviceType) {
        ServiceInfo serviceInfo = programFile.getPackageInfo(serviceType.getPackagePath()).getServiceInfo(serviceType.getName());
        return ConnectorSPIModelHelper.createService(programFile, serviceInfo);
    }
}

