/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.Arrays;
import org.ballerinalang.connector.impl.AnnotatableNode;
import org.ballerinalang.connector.impl.AnnotationImpl;
import org.ballerinalang.connector.impl.ResourceImpl;
import org.ballerinalang.connector.impl.ServiceImpl;
import org.ballerinalang.connector.impl.StructImpl;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BStruct;
import org.ballerinalang.model.values.LockableStructureType;
import org.ballerinalang.util.codegen.PackageInfo;
import org.ballerinalang.util.codegen.PackageVarInfo;
import org.ballerinalang.util.codegen.ProgramFile;
import org.ballerinalang.util.codegen.ResourceInfo;
import org.ballerinalang.util.codegen.ServiceInfo;

public class ConnectorSPIModelHelper {
    private static final String ANNOTATION_DATA = "$annotation_data";

    public static ServiceImpl createService(ProgramFile programFile, ServiceInfo serviceInfo) {
        ServiceImpl service = new ServiceImpl(serviceInfo);
        ConnectorSPIModelHelper.processAnnotations(serviceInfo.getPackagePath(), programFile, service);
        Arrays.stream(serviceInfo.getResourceInfoEntries()).forEach(resourceInfo -> {
            ResourceImpl resource = new ResourceImpl(resourceInfo.getName(), (ResourceInfo)resourceInfo);
            ConnectorSPIModelHelper.processAnnotations(resourceInfo.getPkgPath(), programFile, resource);
            service.addResource(resource.getName(), resource);
        });
        return service;
    }

    public static StructImpl createStruct(BStruct struct) {
        return new StructImpl(struct);
    }

    public static BMap getAnnotationVariable(String pkgPath, ProgramFile programFile) {
        PackageInfo packageInfo = programFile.getPackageInfo(pkgPath);
        PackageVarInfo annotationData = packageInfo.getPackageVarInfo(ANNOTATION_DATA);
        LockableStructureType globalMemoryBlock = programFile.getGlobalMemoryBlock();
        return (BMap)globalMemoryBlock.getRefField(annotationData.getGlobalMemIndex());
    }

    private static void processAnnotations(String pkgPath, ProgramFile programFile, AnnotatableNode annotatableNode) {
        BMap bMap = ConnectorSPIModelHelper.getAnnotationVariable(pkgPath, programFile);
        Object map = bMap.get(annotatableNode.getAnnotationEntryKey());
        if (map == null || map.getType().getTag() != BTypes.typeMap.getTag()) {
            return;
        }
        BMap annotationMap = (BMap)map;
        for (String key : annotationMap.keySet()) {
            BStruct annotationData = (BStruct)annotationMap.get(key);
            StructImpl struct = null;
            if (annotationData != null) {
                struct = new StructImpl(annotationData);
            }
            String annotaionQName = key.split("\\$")[0];
            String[] qNameParts = annotaionQName.split(":");
            AnnotationImpl annotation = new AnnotationImpl(qNameParts[1], qNameParts[0], struct);
            annotatableNode.addAnnotation(annotaionQName, annotation);
        }
    }
}

