/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.Map;
import org.ballerinalang.bre.bvm.CallableUnitCallback;
import org.ballerinalang.bre.bvm.WorkerExecutionContext;
import org.ballerinalang.connector.api.BallerinaConnectorException;
import org.ballerinalang.connector.api.Resource;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.codegen.ResourceInfo;
import org.ballerinalang.util.observability.ObservabilityUtils;
import org.ballerinalang.util.observability.ObserverContext;
import org.ballerinalang.util.program.BLangFunctions;
import org.ballerinalang.util.program.BLangVMUtils;
import org.ballerinalang.util.transactions.LocalTransactionInfo;

public class ResourceExecutor {
    public static void execute(Resource resource, CallableUnitCallback responseCallback, Map<String, Object> properties, ObserverContext observerContext, BValue ... bValues) throws BallerinaConnectorException {
        if (resource == null || responseCallback == null) {
            throw new BallerinaConnectorException("invalid arguments provided");
        }
        ResourceInfo resourceInfo = resource.getResourceInfo();
        WorkerExecutionContext context = new WorkerExecutionContext(resourceInfo.getPackageInfo().getProgramFile());
        if (properties != null) {
            context.globalProps.putAll(properties);
            if (properties.get("globalTransactionId") != null) {
                context.setLocalTransactionInfo(new LocalTransactionInfo(properties.get("globalTransactionId").toString(), properties.get("transactionUrl").toString(), "2pc"));
            }
        }
        ObservabilityUtils.continueServerObservation(observerContext, resource.getServiceName(), resource.getName(), context);
        BLangVMUtils.setServiceInfo(context, resourceInfo.getServiceInfo());
        BLangFunctions.invokeServiceCallable(resourceInfo, context, bValues, responseCallback);
    }
}

