/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.connector.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.ballerinalang.connector.api.BallerinaServerConnector;
import org.ballerinalang.connector.api.Service;
import org.ballerinalang.util.codegen.ServiceInfo;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

public class ServerConnectorRegistry {
    private Map<String, BallerinaServerConnector> serverConnectorMap = new HashMap<String, BallerinaServerConnector>();
    private boolean initialized = false;

    public void initServerConnectors() {
        if (this.initialized) {
            return;
        }
        ServiceLoader<BallerinaServerConnector> serverConnectorServiceLoader = ServiceLoader.load(BallerinaServerConnector.class);
        serverConnectorServiceLoader.forEach(serverConnector -> serverConnector.getProtocolPackages().forEach(protocolPkg -> {
            if (this.serverConnectorMap.containsKey(protocolPkg)) {
                throw new BLangRuntimeException("Multiple server connectors in the runtime for given protocol package - " + protocolPkg);
            }
            this.serverConnectorMap.put((String)protocolPkg, (BallerinaServerConnector)serverConnector);
        }));
        this.initialized = true;
    }

    public void deploymentComplete() {
        this.serverConnectorMap.values().forEach(BallerinaServerConnector::deploymentComplete);
    }

    public void registerService(ServiceInfo serviceInfo) {
        if (!this.serverConnectorMap.containsKey(serviceInfo.getEndpointName())) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INVALID_SERVICE_PROTOCOL, serviceInfo.getEndpointName());
        }
        Service service = this.buildService(serviceInfo);
        this.serverConnectorMap.get(serviceInfo.getEndpointName()).serviceRegistered(service);
    }

    public BallerinaServerConnector getBallerinaServerConnector(String protocolPkgPath) {
        return this.serverConnectorMap.get(protocolPkgPath);
    }

    private Service buildService(ServiceInfo serviceInfo) {
        return null;
    }
}

