/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.expressions;

import org.ballerinalang.model.NodeLocation;
import org.ballerinalang.model.WhiteSpaceDescriptor;
import org.ballerinalang.model.expressions.Expression;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.util.exceptions.FlowBuilderException;

public abstract class AbstractExpression
implements Expression {
    protected NodeLocation location;
    protected WhiteSpaceDescriptor whiteSpaceDescriptor;
    protected BType type;
    protected boolean multipleReturnsAvailable;
    protected int offset;
    protected int tempOffset;
    private boolean isTempOffsetSet = false;

    public AbstractExpression(NodeLocation location, WhiteSpaceDescriptor whiteSpaceDescriptor) {
        this.location = location;
        this.whiteSpaceDescriptor = whiteSpaceDescriptor;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public void setType(BType type) {
        this.type = type;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public boolean isMultiReturnExpr() {
        return this.multipleReturnsAvailable;
    }

    public void setMultiReturnAvailable(boolean multiReturnsAvailable) {
        this.multipleReturnsAvailable = multiReturnsAvailable;
    }

    @Override
    public NodeLocation getNodeLocation() {
        return this.location;
    }

    public void setWhiteSpaceDescriptor(WhiteSpaceDescriptor whiteSpaceDescriptor) {
        this.whiteSpaceDescriptor = whiteSpaceDescriptor;
    }

    @Override
    public WhiteSpaceDescriptor getWhiteSpaceDescriptor() {
        return this.whiteSpaceDescriptor;
    }

    @Override
    public int getTempOffset() {
        return this.tempOffset;
    }

    @Override
    public void setTempOffset(int index) {
        if (this.isTempOffsetSet && index != this.tempOffset) {
            throw new FlowBuilderException("Internal Error. Attempt to Overwrite tempOffset. current :" + this.tempOffset + ", new :" + index);
        }
        this.isTempOffsetSet = true;
        this.tempOffset = index;
    }

    @Override
    public boolean hasTemporaryValues() {
        return this.isTempOffsetSet;
    }
}

