/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.types.BIndexedType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeSignature;
import org.ballerinalang.model.values.BArray;
import org.ballerinalang.model.values.BValue;

public class BArrayType
extends BType
implements BIndexedType {
    private BType elementType;
    private int dimensions = 1;

    public BArrayType(BType elementType) {
        super(null, null, BArray.class);
        this.elementType = elementType;
        if (elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)elementType).getDimensions() + 1;
        }
    }

    @Override
    public BType getElementType() {
        return this.elementType;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        BArray emptyVal = new BArray(this.elementType.getValueClass());
        emptyVal.setType(this);
        return (V)emptyVal;
    }

    @Override
    public TypeSignature getSig() {
        return new TypeSignature("[", this.elementType.getSig());
    }

    @Override
    public int getTag() {
        return 16;
    }

    @Override
    public int hashCode() {
        return super.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BArrayType) {
            BArrayType other = (BArrayType)obj;
            return this.elementType.equals(other.elementType);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.elementType + "[]";
    }

    public int getDimensions() {
        return this.dimensions;
    }
}

