/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import java.util.Arrays;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.TypeSignature;
import org.ballerinalang.model.values.BFunctionPointer;
import org.ballerinalang.model.values.BValue;

public class BFunctionType
extends BType {
    public BType[] paramTypes;
    public BType[] retParamTypes;
    private boolean hasReturnsKeyword;
    private String[] parametersFieldsNames = new String[0];
    private String[] returnsParametersFieldsNames = new String[0];

    public BFunctionType() {
        super("function ()", null, BFunctionPointer.class);
        this.paramTypes = new BType[0];
        this.retParamTypes = new BType[0];
    }

    public BFunctionType(BType[] paramTypes, BType[] retParamType) {
        super("function ()", null, BFunctionPointer.class);
        this.paramTypes = paramTypes;
        this.retParamTypes = retParamType;
    }

    public BType[] getParameterType() {
        return this.paramTypes;
    }

    public BType[] getReturnParameterType() {
        return this.retParamTypes;
    }

    @Override
    public <V extends BValue> V getZeroValue() {
        return null;
    }

    @Override
    public <V extends BValue> V getEmptyValue() {
        return null;
    }

    @Override
    public TypeSignature getSig() {
        return new TypeSignature("U");
    }

    @Override
    public int getTag() {
        return 14;
    }

    private String getSigString() {
        return "(" + BFunctionType.getBTypListAsString(this.paramTypes, true) + ")(" + BFunctionType.getBTypListAsString(this.retParamTypes, true) + ")";
    }

    public static String getTypeName(BType[] parameterType, BType[] returnParameterType) {
        return "function (" + (parameterType != null ? BFunctionType.getBTypListAsString(parameterType, false) : "") + ")" + (returnParameterType != null ? " returns (" + BFunctionType.getBTypListAsString(returnParameterType, false) + ")" : "");
    }

    private static String getBTypListAsString(BType[] typeNames, boolean isSigNature) {
        StringBuffer br = new StringBuffer();
        int i = 0;
        for (BType type : typeNames) {
            br.append(isSigNature ? type.getSig() : type.getName());
            if (++i >= typeNames.length) continue;
            br.append(isSigNature ? "" : ",");
        }
        return br.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BFunctionType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BFunctionType that = (BFunctionType)o;
        if (!Arrays.equals(this.paramTypes, that.paramTypes)) {
            return false;
        }
        return Arrays.equals(this.retParamTypes, that.retParamTypes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.paramTypes);
        result = 31 * result + Arrays.hashCode(this.retParamTypes);
        return result;
    }

    public boolean hasReturnsKeyword() {
        return this.hasReturnsKeyword;
    }

    public void setHasReturnsKeyword(boolean hasReturnsKeyword) {
        this.hasReturnsKeyword = hasReturnsKeyword;
    }

    public String[] getParametersFieldsNames() {
        return this.parametersFieldsNames;
    }

    public void setParametersFieldsNames(String[] parametersFieldsNames) {
        this.parametersFieldsNames = parametersFieldsNames;
    }

    public String[] getReturnsParametersFieldsNames() {
        return this.returnsParametersFieldsNames;
    }

    public void setReturnsParametersFieldsNames(String[] returnsParametersFieldsNames) {
        this.returnsParametersFieldsNames = returnsParametersFieldsNames;
    }
}

