/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.types;

import org.ballerinalang.model.types.BAnyType;
import org.ballerinalang.model.types.BBlobType;
import org.ballerinalang.model.types.BBooleanType;
import org.ballerinalang.model.types.BConnectorType;
import org.ballerinalang.model.types.BFloatType;
import org.ballerinalang.model.types.BFutureType;
import org.ballerinalang.model.types.BIntegerType;
import org.ballerinalang.model.types.BIteratorType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BNullType;
import org.ballerinalang.model.types.BStreamType;
import org.ballerinalang.model.types.BStringType;
import org.ballerinalang.model.types.BTableType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypeDesc;
import org.ballerinalang.model.types.BXMLAttributesType;
import org.ballerinalang.model.types.BXMLType;

public class BTypes {
    public static BType typeInt = new BIntegerType("int", null);
    public static BType typeFloat = new BFloatType("float", null);
    public static BType typeString = new BStringType("string", null);
    public static BType typeBoolean = new BBooleanType("boolean", null);
    public static BType typeBlob = new BBlobType("blob", null);
    public static BType typeXML = new BXMLType("xml", null);
    public static BType typeJSON = new BJSONType("json", null);
    public static BType typeTable = new BTableType("table", null);
    public static BType typeStream = new BStreamType("stream", null);
    public static BType typeAny = new BAnyType("any", null);
    public static BType typeDesc = new BTypeDesc("typedesc", null);
    public static BType typeMap = new BMapType("map", typeAny, null);
    public static BType typeFuture = new BFutureType("future", null);
    public static BType typeConnector = new BConnectorType("connector", null);
    public static BType typeNull = new BNullType("null", null);
    public static BType typeXMLAttributes = new BXMLAttributesType("xml-attributes", null);
    public static BType typeIterator = new BIteratorType("iterator", null);

    private BTypes() {
    }

    public static boolean isValueType(BType type) {
        return type == typeInt || type == typeFloat || type == typeString || type == typeBoolean || type == typeBlob;
    }

    public static BType getTypeFromName(String typeName) {
        switch (typeName) {
            case "json": {
                return typeJSON;
            }
            case "xml": {
                return typeXML;
            }
            case "map": {
                return typeMap;
            }
            case "future": {
                return typeFuture;
            }
            case "table": {
                return typeTable;
            }
            case "stream": {
                return typeStream;
            }
        }
        throw new IllegalStateException("Unknown type name");
    }
}

