/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.util.exceptions.BLangExceptionHelper;
import org.ballerinalang.util.exceptions.BallerinaException;
import org.ballerinalang.util.exceptions.RuntimeErrors;

public final class BArray<V extends BValue>
implements BRefType {
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_ARRAY_SIZE = 100;
    private static final int DEFAULT_ARRAY_BUCKET_SIZE = 10;
    private BValue[][] arrayBucket = new BValue[10][];
    private Class<V> valueClass;
    private int lastBucketIndex = -1;
    private int size = 0;
    private BType type;
    private BValue zeroValue;

    public BArray(Class<V> valueClass) {
        this.valueClass = valueClass;
    }

    public <V extends BValue> void add(long index, V value) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int indexVal = (int)index;
        if (indexVal < 0) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, this.size);
        }
        this.ensureCapacity(indexVal);
        int bucketIndex = indexVal / 100;
        int slot = indexVal % 100;
        this.arrayBucket[bucketIndex][slot] = value;
        if (index >= (long)this.size) {
            this.size = indexVal + 1;
        }
    }

    public V get(long index) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int indexVal = (int)index;
        this.rangeCheck(indexVal);
        int bucketIndex = indexVal / 100;
        int slot = indexVal % 100;
        BValue value = this.arrayBucket[bucketIndex][slot];
        if (value == null) {
            return (V)this.zeroValue;
        }
        return (V)value;
    }

    public int size() {
        return this.size;
    }

    @Override
    public String stringValue() {
        return null;
    }

    @Override
    public BType getType() {
        return this.type;
    }

    public void setType(BType type) {
        this.type = type;
        this.zeroValue = type instanceof BArrayType ? ((BArrayType)type).getElementType().getZeroValue() : type.getZeroValue();
    }

    public V value() {
        return null;
    }

    @Override
    public BValue copy() {
        BArray<BValue> array = new BArray<BValue>(this.valueClass);
        for (int i = 0; i < this.size; ++i) {
            V value = this.get(i);
            array.add(i, value == null ? null : value.copy());
        }
        return array;
    }

    private <V extends BValue> V[] createArray() {
        return (BValue[])Array.newInstance(this.valueClass, 100);
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this.size) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, this.size);
        }
    }

    private void ensureCapacity(int capacityRequired) {
        int bucketIndex = capacityRequired / 100;
        if (bucketIndex - this.lastBucketIndex > 0) {
            this.grow(capacityRequired, bucketIndex);
        }
    }

    private void grow(int capacityRequired, int bucketIndex) {
        if (capacityRequired > 0x7FFFFFF7) {
            throw new BallerinaException("Requested array size " + capacityRequired + " exceeds limit: " + 0x7FFFFFF7);
        }
        if (bucketIndex >= this.arrayBucket.length) {
            this.arrayBucket = (BValue[][])Arrays.copyOf(this.arrayBucket, this.arrayBucket.length + 10);
        }
        if (bucketIndex > this.lastBucketIndex) {
            int i = this.lastBucketIndex + 1;
            while (bucketIndex > this.lastBucketIndex) {
                this.arrayBucket[i] = this.createArray();
                ++this.lastBucketIndex;
                ++i;
            }
        }
    }
}

