/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.nio.charset.StandardCharsets;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public class BBlob
extends BValueType
implements BRefType<byte[]> {
    private byte[] value;

    public BBlob(byte[] value) {
        this.value = value;
    }

    @Override
    public String stringValue() {
        return new String(this.value, StandardCharsets.UTF_8);
    }

    @Override
    public BType getType() {
        return BTypes.typeBlob;
    }

    @Override
    public BValue copy() {
        return new BBlob(this.value);
    }

    @Override
    public long intValue() {
        return 0L;
    }

    @Override
    public double floatValue() {
        return 0.0;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte[] blobValue() {
        return this.value;
    }

    @Override
    public byte[] value() {
        return this.value;
    }
}

