/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public final class BBoolean
extends BValueType
implements BRefType<Boolean> {
    public static final BBoolean TRUE = new BBoolean(true);
    public static final BBoolean FALSE = new BBoolean(false);
    private boolean value;

    public BBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        return 0L;
    }

    @Override
    public double floatValue() {
        return 0.0;
    }

    @Override
    public boolean booleanValue() {
        return this.value;
    }

    @Override
    public byte[] blobValue() {
        return null;
    }

    @Override
    public String stringValue() {
        return Boolean.toString(this.value);
    }

    @Override
    public BType getType() {
        return BTypes.typeBoolean;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoolean bBoolean = (BBoolean)o;
        return this.value == bBoolean.value;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public Boolean value() {
        return this.value;
    }

    @Override
    public BValue copy() {
        return new BBoolean(this.value);
    }
}

