/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;

public class BBooleanArray
extends BNewArray {
    private static BType arrayType = new BArrayType(BTypes.typeBoolean);
    private int[] values;

    public BBooleanArray(int[] values) {
        this.values = values;
        this.size = values.length;
    }

    public BBooleanArray() {
        this.values = (int[])this.newArrayInstance(Integer.TYPE);
    }

    public void add(long index, int value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public int get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    @Override
    public BType getType() {
        return arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BBooleanArray booleanArray = new BBooleanArray(Arrays.copyOf(this.values, this.values.length));
        booleanArray.size = this.size;
        return booleanArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            sj.add(Boolean.toString(this.values[i] == 1));
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        return new BBoolean(this.get(index) == 1);
    }
}

