/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.HashMap;
import java.util.Map;
import org.ballerinalang.model.types.BConnectorType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.StructureType;

public final class BConnector
implements BRefType,
StructureType {
    private long[] longFields;
    private double[] doubleFields;
    private String[] stringFields;
    private int[] intFields;
    private byte[][] byteFields;
    private BRefType[] refFields;
    private BConnectorType connectorType;
    private boolean isFilterConnector;
    private final Map<String, Object> nativeData = new HashMap<String, Object>();

    public BConnector(BConnectorType connectorType) {
        this.connectorType = connectorType;
        int[] fieldIndexes = this.connectorType.getFieldTypeCount();
        this.longFields = new long[fieldIndexes[0]];
        this.doubleFields = new double[fieldIndexes[1]];
        this.stringFields = new String[fieldIndexes[2]];
        this.intFields = new int[fieldIndexes[3]];
        this.byteFields = new byte[fieldIndexes[4]][];
        this.refFields = new BRefType[fieldIndexes[5]];
    }

    public BType getConnectorType() {
        return this.connectorType;
    }

    public boolean isFilterConnector() {
        return this.isFilterConnector;
    }

    public void setFilterConnector(boolean filterConnector) {
        this.isFilterConnector = filterConnector;
    }

    public void setNativeData(String key, Object value) {
        this.nativeData.put(key, value);
    }

    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    public BConnector value() {
        return null;
    }

    @Override
    public String stringValue() {
        return "";
    }

    @Override
    public BType getType() {
        return this.connectorType;
    }

    @Override
    public long getIntField(int index) {
        return this.longFields[index];
    }

    @Override
    public void setIntField(int index, long value) {
        this.longFields[index] = value;
    }

    @Override
    public double getFloatField(int index) {
        return this.doubleFields[index];
    }

    @Override
    public void setFloatField(int index, double value) {
        this.doubleFields[index] = value;
    }

    @Override
    public String getStringField(int index) {
        return this.stringFields[index];
    }

    @Override
    public void setStringField(int index, String value) {
        this.stringFields[index] = value;
    }

    @Override
    public int getBooleanField(int index) {
        return this.intFields[index];
    }

    @Override
    public void setBooleanField(int index, int value) {
        this.intFields[index] = value;
    }

    @Override
    public byte[] getBlobField(int index) {
        return this.byteFields[index];
    }

    @Override
    public void setBlobField(int index, byte[] value) {
        this.byteFields[index] = value;
    }

    @Override
    public BRefType getRefField(int index) {
        return this.refFields[index];
    }

    @Override
    public void setRefField(int index, BRefType value) {
        this.refFields[index] = value;
    }

    @Override
    public BValue copy() {
        return null;
    }
}

