/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.util.Arrays;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BNewArray;
import org.ballerinalang.model.values.BValue;

public class BIntArray
extends BNewArray {
    static BType arrayType = new BArrayType(BTypes.typeInt);
    private long[] values;

    public BIntArray(long[] values) {
        this.values = values;
        this.size = values.length;
    }

    public BIntArray() {
        this.values = (long[])this.newArrayInstance(Long.TYPE);
    }

    public void add(long index, long value) {
        this.prepareForAdd(index, this.values.length);
        this.values[(int)index] = value;
    }

    public long get(long index) {
        this.rangeCheckForGet(index, this.size);
        return this.values[(int)index];
    }

    @Override
    public BType getType() {
        return arrayType;
    }

    @Override
    public void grow(int newLength) {
        this.values = Arrays.copyOf(this.values, newLength);
    }

    @Override
    public BValue copy() {
        BIntArray intArray = new BIntArray(Arrays.copyOf(this.values, this.values.length));
        intArray.size = this.size;
        return intArray;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "[", "]");
        for (int i = 0; i < this.size; ++i) {
            sj.add(Long.toString(this.values[i]));
        }
        return sj.toString();
    }

    @Override
    public BValue getBValue(long index) {
        return new BInteger(this.get(index));
    }
}

