/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BValueType;

public final class BInteger
extends BValueType
implements BRefType<Long> {
    private long value;

    public BInteger(long value) {
        this.value = value;
    }

    @Override
    public long intValue() {
        return this.value;
    }

    @Override
    public double floatValue() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return false;
    }

    @Override
    public byte[] blobValue() {
        return null;
    }

    @Override
    public String stringValue() {
        return Long.toString(this.value);
    }

    @Override
    public BType getType() {
        return BTypes.typeInt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BInteger bInteger = (BInteger)o;
        return this.value == bInteger.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    @Override
    public Long value() {
        return this.value;
    }

    @Override
    public BValue copy() {
        return new BInteger(this.value);
    }
}

