/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.StringJoiner;
import org.ballerinalang.model.types.BArrayType;
import org.ballerinalang.model.types.BJSONType;
import org.ballerinalang.model.types.BStructType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.JsonGenerator;
import org.ballerinalang.model.util.JsonNode;
import org.ballerinalang.model.util.JsonParser;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BJSON
extends BallerinaMessageDataSource
implements BRefType<JsonNode>,
BCollection {
    private BType type = BTypes.typeJSON;
    private JSONDataSource datasource;
    private JsonNode value;

    public BJSON(JsonNode json) {
        this.value = json;
        this.setType();
    }

    public BJSON(String jsonString, BType type) {
        this(jsonString);
        this.type = type;
    }

    public BJSON(JSONDataSource datasource) {
        this.datasource = datasource;
    }

    public BJSON(String jsonString) {
        if (jsonString == null) {
            this.value = new JsonNode(JsonNode.Type.NULL);
            this.type = BTypes.typeNull;
            return;
        }
        try {
            this.value = JsonParser.parse(jsonString);
            this.setType();
        }
        catch (Throwable t) {
            BJSON.handleJsonException(t);
        }
    }

    public BJSON(InputStream in) {
        this(in, null);
    }

    public BJSON(InputStream in, String schema) {
        try {
            this.value = JsonParser.parse(in);
        }
        catch (Throwable t) {
            BJSON.handleJsonException("failed to create json: ", t);
        }
    }

    public String toString() {
        return this.stringValue();
    }

    public void setValue(JsonNode value) {
        this.value = value;
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            if (this.value != null) {
                this.value.serialize(outputStream);
            } else {
                JsonGenerator gen = new JsonGenerator(outputStream);
                this.datasource.serialize(gen);
                gen.flush();
            }
        }
        catch (Throwable t) {
            BJSON.handleJsonException("error occurred during writing the message to the output stream: ", t);
        }
    }

    @Override
    public JsonNode value() {
        if (this.value == null) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                JsonGenerator gen = new JsonGenerator(byteOut);
                this.datasource.serialize(gen);
                gen.flush();
                this.value = JsonParser.parse(new ByteArrayInputStream(byteOut.toByteArray()));
            }
            catch (Throwable t) {
                BJSON.handleJsonException("Error in building JSON node: ", t);
            }
        }
        return this.value;
    }

    @Override
    public String stringValue() {
        JsonNode node = this.value();
        if (node.isValueNode()) {
            return this.value().asText();
        }
        if (!node.isObject()) {
            return node.toString();
        }
        BStructType constrainedType = (BStructType)((BJSONType)this.type).getConstrainedType();
        if (constrainedType == null) {
            return node.toString();
        }
        StringJoiner sj = new StringJoiner(",", "{", "}");
        for (BStructType.StructField field : constrainedType.getStructFields()) {
            String key = field.fieldName;
            String stringValue = this.value().get(key).toString();
            sj.add("\"" + key + "\":" + stringValue);
        }
        return sj.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    public void setType(BType type) {
        this.type = (BJSONType)type;
    }

    @Override
    public String getMessageAsString() {
        try {
            return this.value.toString();
        }
        catch (Throwable t) {
            BJSON.handleJsonException("failed to get json as string: ", t);
            return null;
        }
    }

    private static void handleJsonException(Throwable t) {
        if (t.getCause() != null) {
            throw new BallerinaException(t.getCause().getMessage());
        }
        throw new BallerinaException(t.getMessage());
    }

    private static void handleJsonException(String message, Throwable t) {
        if (t.getCause() != null) {
            throw new BallerinaException(message + t.getCause().getMessage());
        }
        throw new BallerinaException(message + t.getMessage());
    }

    @Override
    public BallerinaMessageDataSource clone() {
        BJSON clonedMessage = new BJSON("{}");
        try {
            String elementString = this.getMessageAsString();
            JsonNode clonedContent = JsonParser.parse(elementString);
            clonedMessage.setValue(clonedContent);
        }
        catch (Throwable t) {
            BJSON.handleJsonException("failed to clone the json message: ", t);
        }
        return clonedMessage;
    }

    @Override
    public BIterator newIterator() {
        return new BJSONIterator(this);
    }

    @Override
    public BValue copy() {
        return new BJSON(this.stringValue());
    }

    private void setType() {
        switch (this.value.getType()) {
            case ARRAY: {
                this.type = new BArrayType(BTypes.typeJSON);
                break;
            }
            case BOOLEAN: {
                this.type = BTypes.typeBoolean;
                break;
            }
            case DOUBLE: {
                this.type = BTypes.typeFloat;
                break;
            }
            case LONG: {
                this.type = BTypes.typeInt;
                break;
            }
            case NULL: {
                this.type = BTypes.typeNull;
                break;
            }
            case STRING: {
                this.type = BTypes.typeString;
                break;
            }
            default: {
                this.type = BTypes.typeJSON;
            }
        }
    }

    public static interface JSONDataSource {
        public void serialize(JsonGenerator var1) throws IOException;
    }

    static class BJSONIterator
    implements BIterator {
        BJSON collection;
        Iterator<Map.Entry<String, JsonNode>> iterator;
        boolean isJSONArray;
        int size;
        int cursor = 0;

        BJSONIterator(BJSON value) {
            this.collection = value;
            if (this.collection.type.getTag() == 16 || this.collection.value().isArray()) {
                this.isJSONArray = true;
                this.size = this.collection.value().size();
            } else {
                this.iterator = this.collection.value().fields();
            }
        }

        @Override
        public BValue[] getNext(int arity) {
            if (this.isJSONArray) {
                long cursor = this.cursor++;
                if (arity == 1) {
                    return new BValue[]{new BJSON(this.collection.value.get((int)cursor))};
                }
                return new BValue[]{new BInteger(cursor), new BJSON(this.collection.value.get((int)cursor))};
            }
            if (arity == 1) {
                return new BValue[]{new BJSON(this.iterator.next().getValue())};
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.isJSONArray ? this.cursor < this.size : this.iterator.hasNext();
        }
    }
}

