/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.ballerinalang.model.types.BMapType;
import org.ballerinalang.model.types.BType;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.values.BCollection;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BMap<K, V extends BValue>
extends BallerinaMessageDataSource
implements BRefType,
BCollection {
    private LinkedHashMap<K, V> map;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private BType type = BTypes.typeMap;

    public BMap() {
        this.map = new LinkedHashMap();
    }

    public BMap(BMapType type) {
        this.map = new LinkedHashMap();
        this.type = type;
    }

    public V get(K key) {
        this.readLock.lock();
        try {
            BValue bValue = (BValue)this.map.get(key);
            return (V)bValue;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void put(K key, V value) {
        this.writeLock.lock();
        try {
            this.map.put(key, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean hasKey(K key) {
        return this.map.containsKey(key);
    }

    public LinkedHashMap<K, V> getMap() {
        return this.map;
    }

    public int size() {
        return this.map.size();
    }

    public boolean remove(K key) {
        boolean hasKey = this.map.containsKey(key);
        if (hasKey) {
            this.map.remove(key);
        }
        return hasKey;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    public Object value() {
        return null;
    }

    @Override
    public String stringValue() {
        StringJoiner sj = new StringJoiner(", ", "{", "}");
        for (Map.Entry<K, V> e : this.map.entrySet()) {
            String key = "\"" + (String)e.getKey() + "\"";
            BValue value = (BValue)e.getValue();
            String stringValue = value == null ? null : (value instanceof BString ? "\"" + value.stringValue() + "\"" : value.stringValue());
            sj.add(key + ":" + stringValue);
        }
        return sj.toString();
    }

    @Override
    public BType getType() {
        return this.type;
    }

    @Override
    public BValue copy() {
        BMap newMap = (BMap)BTypes.typeMap.getEmptyValue();
        for (Map.Entry<K, V> entry : this.map.entrySet()) {
            BValue value = (BValue)entry.getValue();
            newMap.put(entry.getKey(), value == null ? null : value.copy());
        }
        return newMap;
    }

    @Override
    public String getMessageAsString() {
        return this.stringValue();
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            outputStream.write(this.stringValue().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while serializing data", e);
        }
    }

    @Override
    public BIterator newIterator() {
        return new BMapIterator(this);
    }

    static class BMapIterator<K, V extends BValue>
    implements BIterator {
        BMap<K, V> collection;
        Iterator<Map.Entry<K, V>> iterator;

        BMapIterator(BMap<K, V> value) {
            this.collection = value;
            this.iterator = new LinkedHashMap(((BMap)value).map).entrySet().iterator();
        }

        @Override
        public BValue[] getNext(int arity) {
            Map.Entry<K, V> next = this.iterator.next();
            if (arity == 1) {
                return new BValue[]{(BValue)next.getValue()};
            }
            return new BValue[]{new BString((String)next.getKey()), (BValue)next.getValue()};
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

