/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMComment;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.OMXMLBuilderFactory;
import org.apache.axiom.om.impl.common.OMChildrenQNameIterator;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.CommentImpl;
import org.apache.axiom.om.impl.dom.TextImpl;
import org.apache.axiom.om.impl.llom.OMAttributeImpl;
import org.apache.axiom.om.impl.llom.OMDocumentImpl;
import org.apache.axiom.om.impl.llom.OMElementImpl;
import org.apache.axiom.om.impl.llom.OMProcessingInstructionImpl;
import org.apache.axiom.om.util.AXIOMUtil;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.XMLNodeType;
import org.ballerinalang.model.util.XMLValidationUtils;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLSequence;
import org.ballerinalang.util.BLangConstants;
import org.ballerinalang.util.exceptions.BLangRuntimeException;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BXMLItem
extends BXML<OMNode> {
    private OMNode omNode;
    private XMLNodeType nodeType;

    public BXMLItem() {
        this.omNode = new OMElementImpl();
        this.setXMLNodeType();
    }

    public BXMLItem(String xmlValue) {
        if (xmlValue == null) {
            return;
        }
        try {
            this.omNode = AXIOMUtil.stringToOM((String)xmlValue);
            this.setXMLNodeType();
        }
        catch (Throwable t) {
            BXMLItem.handleXmlException("failed to create xml: ", t);
        }
    }

    public BXMLItem(OMNode value) {
        this.omNode = value;
        this.setXMLNodeType();
    }

    public BXMLItem(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            this.omNode = OMXMLBuilderFactory.createOMBuilder((InputStream)inputStream).getDocumentElement();
            this.setXMLNodeType();
        }
        catch (Throwable t) {
            BXMLItem.handleXmlException("failed to create xml: ", t);
        }
    }

    @Override
    public XMLNodeType getNodeType() {
        return this.nodeType;
    }

    @Override
    public BBoolean isEmpty() {
        return new BBoolean(this.omNode == null);
    }

    @Override
    public BBoolean isSingleton() {
        return new BBoolean(true);
    }

    @Override
    public BString getItemType() {
        return new BString(this.nodeType.value());
    }

    @Override
    public BString getElementName() {
        if (this.nodeType == XMLNodeType.ELEMENT) {
            return new BString(((OMElement)this.omNode).getQName().toString());
        }
        return (BString)BTypes.typeString.getEmptyValue();
    }

    @Override
    public BString getTextValue() {
        switch (this.nodeType) {
            case ELEMENT: {
                StringBuilder elementTextBuilder = new StringBuilder();
                Iterator children = ((OMElement)this.omNode).getChildren();
                while (children.hasNext()) {
                    elementTextBuilder.append(this.getTextValue((OMNode)children.next()));
                }
                return new BString(elementTextBuilder.toString());
            }
            case TEXT: {
                return new BString(((OMText)this.omNode).getText());
            }
            case COMMENT: {
                return (BString)BTypes.typeString.getZeroValue();
            }
            case PI: {
                return (BString)BTypes.typeString.getZeroValue();
            }
        }
        return (BString)BTypes.typeString.getZeroValue();
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        return this.getAttribute(localName, namespace, "");
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.nodeType != XMLNodeType.ELEMENT || localName == null || localName.isEmpty()) {
            return BLangConstants.STRING_NULL_VALUE;
        }
        QName attributeName = this.getQName(localName, namespace, prefix);
        OMAttribute attribute = ((OMElement)this.omNode).getAttribute(attributeName);
        if (attribute != null) {
            return attribute.getAttributeValue();
        }
        OMNamespace ns = ((OMElement)this.omNode).findNamespaceURI(localName);
        return ns == null ? BLangConstants.STRING_NULL_VALUE : ns.getNamespaceURI();
    }

    @Override
    public void setAttribute(String localName, String namespaceUri, String prefix, String value) {
        if (this.nodeType != XMLNodeType.ELEMENT) {
            return;
        }
        if (localName == null || localName.isEmpty()) {
            throw new BLangRuntimeException("localname of the attribute cannot be empty");
        }
        XMLValidationUtils.validateXMLName(localName);
        XMLValidationUtils.validateXMLName(prefix);
        OMElement node = (OMElement)this.omNode;
        QName qname = this.getQName(localName, namespaceUri, prefix);
        OMAttribute attr = node.getAttribute(qname);
        if (attr != null) {
            attr.setAttributeValue(value);
            return;
        }
        if (prefix != null && prefix.equals("xmlns")) {
            node.declareNamespace(value, localName);
            return;
        }
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            attr = new OMAttributeImpl();
            attr.setAttributeValue(value);
            attr.setLocalName(localName);
            node.addAttribute(attr);
            return;
        }
        if (node.getDefaultNamespace() != null && namespaceUri.equals(node.getDefaultNamespace().getNamespaceURI()) || namespaceUri.equals("http://www.w3.org/2000/xmlns/")) {
            node.declareNamespace(value, localName);
            return;
        }
        OMNamespaceImpl ns = null;
        if (prefix != null && !prefix.isEmpty()) {
            OMNamespace existingNs = node.findNamespaceURI(prefix);
            if (existingNs != null && !namespaceUri.equals(existingNs.getNamespaceURI())) {
                throw new BLangRuntimeException("failed to add attribute '" + prefix + ":" + localName + "'. prefix '" + prefix + "' is already bound to namespace '" + existingNs.getNamespaceURI() + "'");
            }
            ns = new OMNamespaceImpl(namespaceUri, prefix);
            node.addAttribute(localName, value, (OMNamespace)ns);
            return;
        }
        if (namespaceUri != null && !namespaceUri.isEmpty()) {
            prefix = null;
            Iterator<String> prefixes = node.getNamespaceContext(false).getPrefixes(namespaceUri);
            while (prefixes.hasNext()) {
                String definedPrefix = prefixes.next();
                if (definedPrefix.isEmpty()) continue;
                prefix = definedPrefix;
                break;
            }
            if (prefix != null && prefix.equals("xmlns")) {
                node.declareNamespace(value, localName);
                return;
            }
            ns = new OMNamespaceImpl(namespaceUri, prefix);
        }
        node.addAttribute(localName, value, ns);
    }

    @Override
    public BMap<?, ?> getAttributesMap() {
        BMap<String, BString> attrMap = new BMap<String, BString>();
        if (this.nodeType != XMLNodeType.ELEMENT) {
            return attrMap;
        }
        OMNamespace defaultNs = ((OMElement)this.omNode).getDefaultNamespace();
        String namespaceOfPrefix = '{' + (defaultNs == null ? "http://www.w3.org/2000/xmlns/" : defaultNs.getNamespaceURI()) + '}';
        Iterator namespaceIterator = ((OMElement)this.omNode).getAllDeclaredNamespaces();
        while (namespaceIterator.hasNext()) {
            OMNamespace namespace = (OMNamespace)namespaceIterator.next();
            String prefix = namespace.getPrefix();
            if (prefix.isEmpty()) continue;
            attrMap.put(namespaceOfPrefix + prefix, new BString(namespace.getNamespaceURI()));
        }
        Iterator attrIterator = ((OMElement)this.omNode).getAllAttributes();
        while (attrIterator.hasNext()) {
            OMAttribute attr = (OMAttribute)attrIterator.next();
            attrMap.put(attr.getQName().toString(), new BString(attr.getAttributeValue()));
        }
        return attrMap;
    }

    @Override
    public void setAttributes(BMap<String, ?> attributes) {
        if (this.nodeType != XMLNodeType.ELEMENT || attributes == null) {
            return;
        }
        OMElement omElement = (OMElement)this.omNode;
        Iterator attrIterator = omElement.getAllAttributes();
        while (attrIterator.hasNext()) {
            omElement.removeAttribute((OMAttribute)attrIterator.next());
        }
        Iterator namespaceIterator = omElement.getAllDeclaredNamespaces();
        while (namespaceIterator.hasNext()) {
            namespaceIterator.next();
            namespaceIterator.remove();
        }
        Set<String> attributeQNames = attributes.keySet();
        for (String qname : attributeQNames) {
            String uri;
            String localName;
            if (qname.startsWith("{") && qname.indexOf(125) > 0) {
                localName = qname.substring(qname.indexOf(125) + 1, qname.length());
                uri = qname.substring(1, qname.indexOf(125));
            } else {
                localName = qname;
                uri = BLangConstants.STRING_NULL_VALUE;
            }
            XMLValidationUtils.validateXMLName(localName);
            this.setAttribute(localName, uri, BLangConstants.STRING_NULL_VALUE, attributes.get(qname).stringValue());
        }
    }

    @Override
    public BXML<?> elements() {
        BRefValueArray elementsSeq = new BRefValueArray();
        switch (this.nodeType) {
            case ELEMENT: {
                elementsSeq.add(0L, this);
                break;
            }
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> elements(String qname) {
        BRefValueArray elementsSeq = new BRefValueArray();
        switch (this.nodeType) {
            case ELEMENT: {
                if (!this.getElementName().stringValue().equals(this.getQname(qname).toString())) break;
                elementsSeq.add(0L, this);
                break;
            }
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children() {
        BRefValueArray elementsSeq = new BRefValueArray();
        switch (this.nodeType) {
            case ELEMENT: {
                Iterator childrenItr = ((OMElement)this.omNode).getChildren();
                int i = 0;
                while (childrenItr.hasNext()) {
                    elementsSeq.add(i++, new BXMLItem((OMNode)childrenItr.next()));
                }
                break;
            }
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children(String qname) {
        BRefValueArray elementsSeq = new BRefValueArray();
        switch (this.nodeType) {
            case ELEMENT: {
                OMChildrenQNameIterator childrenItr = new OMChildrenQNameIterator(((OMElement)this.omNode).getFirstOMChild(), this.getQname(qname));
                int i = 0;
                while (childrenItr.hasNext()) {
                    OMNode node = (OMNode)childrenItr.next();
                    elementsSeq.add(i++, new BXMLItem(node));
                }
                break;
            }
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public void setChildren(BXML<?> seq) {
        OMElement currentNode;
        if (seq == null) {
            return;
        }
        switch (this.nodeType) {
            case ELEMENT: {
                currentNode = (OMElement)this.omNode;
                break;
            }
            default: {
                throw new BallerinaException("not an " + (Object)((Object)XMLNodeType.ELEMENT));
            }
        }
        currentNode.removeChildren();
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            BRefValueArray childSeq = ((BXMLSequence)seq).value();
            int i = 0;
            while ((long)i < childSeq.size()) {
                currentNode.addChild((OMNode)childSeq.get(i).value());
                ++i;
            }
        } else {
            currentNode.addChild((OMNode)seq.value());
        }
    }

    @Override
    public void addChildren(BXML<?> seq) {
        OMElement currentNode;
        if (seq == null) {
            return;
        }
        switch (this.nodeType) {
            case ELEMENT: {
                currentNode = (OMElement)this.omNode;
                break;
            }
            default: {
                throw new BallerinaException("not an " + (Object)((Object)XMLNodeType.ELEMENT));
            }
        }
        if (seq.getNodeType() == XMLNodeType.SEQUENCE) {
            BRefValueArray childSeq = ((BXMLSequence)seq).value();
            int i = 0;
            while ((long)i < childSeq.size()) {
                currentNode.addChild((OMNode)childSeq.get(i).value());
                ++i;
            }
        } else {
            currentNode.addChild((OMNode)seq.value());
        }
    }

    @Override
    public BXML<?> strip() {
        if (this.omNode == null || this.nodeType == XMLNodeType.TEXT && ((OMText)this.omNode).getText().isEmpty()) {
            return new BXMLSequence();
        }
        return this;
    }

    @Override
    public BXML<?> slice(long startIndex, long endIndex) {
        if (startIndex > 1L || endIndex > 1L || startIndex < -1L || endIndex < -1L) {
            throw new BallerinaException("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = 1L;
        }
        if (startIndex == endIndex) {
            return new BXMLSequence();
        }
        if (startIndex > endIndex) {
            throw new BallerinaException("invalid indices: " + startIndex + " < " + endIndex);
        }
        return this;
    }

    @Override
    public BXML<?> descendants(String qname) {
        ArrayList descendants = new ArrayList();
        switch (this.nodeType) {
            case ELEMENT: {
                this.addDescendants(descendants, (OMElement)this.omNode, this.getQname(qname).toString());
                break;
            }
        }
        return new BXMLSequence(new BRefValueArray(descendants.toArray(new BXML[descendants.size()]), BTypes.typeXML));
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            this.omNode.serialize(outputStream);
        }
        catch (Throwable t) {
            BXMLItem.handleXmlException("error occurred during writing the message to the output stream: ", t);
        }
    }

    @Override
    public OMNode value() {
        return this.omNode;
    }

    @Override
    public String stringValue() {
        try {
            switch (this.nodeType) {
                case COMMENT: {
                    return "<!--" + ((OMComment)this.omNode).getValue() + "-->";
                }
                case TEXT: {
                    return ((OMText)this.omNode).getText();
                }
                case PI: {
                    return "<?" + ((OMProcessingInstruction)this.omNode).getTarget() + " " + ((OMProcessingInstruction)this.omNode).getValue() + "?>";
                }
            }
            return this.omNode.toString();
        }
        catch (Throwable t) {
            BXMLItem.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BXMLItem copy() {
        OMNode clonedNode = null;
        switch (this.nodeType) {
            case ELEMENT: {
                clonedNode = ((OMElement)this.omNode).cloneOMElement();
                break;
            }
            case TEXT: {
                TextImpl text = new TextImpl();
                text.setTextContent(((OMText)this.omNode).getText());
                clonedNode = text;
                break;
            }
            case COMMENT: {
                CommentImpl comment = new CommentImpl();
                comment.setTextContent(((OMComment)this.omNode).getValue());
                clonedNode = comment;
                break;
            }
            case PI: {
                OMProcessingInstructionImpl pi = new OMProcessingInstructionImpl();
                pi.setTarget(((OMProcessingInstruction)this.omNode).getTarget());
                pi.setValue(((OMProcessingInstruction)this.omNode).getValue());
                clonedNode = pi;
                break;
            }
            default: {
                clonedNode = this.omNode;
            }
        }
        OMDocumentImpl doc = new OMDocumentImpl();
        doc.addChild(clonedNode);
        return new BXMLItem(clonedNode);
    }

    private void setXMLNodeType() {
        switch (this.omNode.getType()) {
            case 1: {
                this.nodeType = XMLNodeType.ELEMENT;
                break;
            }
            case 4: {
                this.nodeType = XMLNodeType.TEXT;
                break;
            }
            case 5: {
                this.nodeType = XMLNodeType.COMMENT;
                break;
            }
            case 3: {
                this.nodeType = XMLNodeType.PI;
                break;
            }
            default: {
                this.nodeType = XMLNodeType.SEQUENCE;
            }
        }
    }

    private String getTextValue(OMNode node) {
        switch (node.getType()) {
            case 1: {
                StringBuilder sb = new StringBuilder();
                Iterator children = ((OMElement)node).getChildren();
                while (children.hasNext()) {
                    sb.append(this.getTextValue((OMNode)children.next()));
                }
                return sb.toString();
            }
            case 4: {
                return ((OMText)node).getText();
            }
            case 5: {
                return BLangConstants.STRING_NULL_VALUE;
            }
            case 3: {
                return BLangConstants.STRING_NULL_VALUE;
            }
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public BXML<?> getItem(long index) {
        if (index != 0L) {
            throw new BLangRuntimeException("index out of range: index: " + index + ", size: 1");
        }
        return this;
    }

    @Override
    public int length() {
        return this.omNode == null ? 0 : 1;
    }

    @Override
    public void build() {
        this.omNode.build();
    }

    @Override
    public void removeAttribute(String qname) {
        if (this.nodeType != XMLNodeType.ELEMENT || qname.isEmpty()) {
            return;
        }
        OMElement omElement = (OMElement)this.omNode;
        OMAttribute attribute = omElement.getAttribute(this.getQname(qname));
        if (attribute == null) {
            return;
        }
        omElement.removeAttribute(attribute);
    }

    private QName getQName(String localName, String namespaceUri, String prefix) {
        QName qname = prefix != null ? new QName(namespaceUri, localName, prefix) : new QName(namespaceUri, localName);
        return qname;
    }

    @Override
    public BIterator newIterator() {
        return new BXMLItemIterator(this);
    }

    static class BXMLItemIterator
    implements BIterator {
        BXMLItem value;
        int cursor = 0;

        BXMLItemIterator(BXMLItem bxmlItem) {
            this.value = bxmlItem;
        }

        @Override
        public BValue[] getNext(int arity) {
            BValue[] bValueArray;
            if (arity == 1) {
                BValue[] bValueArray2;
                if (this.cursor++ == 0) {
                    BValue[] bValueArray3 = new BValue[1];
                    bValueArray2 = bValueArray3;
                    bValueArray3[0] = this.value;
                } else {
                    bValueArray2 = null;
                }
                return bValueArray2;
            }
            if (this.cursor++ == 0) {
                BValue[] bValueArray4 = new BValue[2];
                bValueArray4[0] = new BInteger(0L);
                bValueArray = bValueArray4;
                bValueArray4[1] = this.value;
            } else {
                bValueArray = null;
            }
            return bValueArray;
        }

        @Override
        public boolean hasNext() {
            return this.cursor == 0;
        }
    }
}

