/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.model.values;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.ballerinalang.model.types.BTypes;
import org.ballerinalang.model.util.XMLNodeType;
import org.ballerinalang.model.values.BBoolean;
import org.ballerinalang.model.values.BInteger;
import org.ballerinalang.model.values.BIterator;
import org.ballerinalang.model.values.BMap;
import org.ballerinalang.model.values.BRefType;
import org.ballerinalang.model.values.BRefValueArray;
import org.ballerinalang.model.values.BString;
import org.ballerinalang.model.values.BValue;
import org.ballerinalang.model.values.BXML;
import org.ballerinalang.model.values.BXMLItem;
import org.ballerinalang.util.BLangConstants;
import org.ballerinalang.util.exceptions.BallerinaException;

public final class BXMLSequence
extends BXML<BRefValueArray> {
    private BRefValueArray sequence;

    public BXMLSequence() {
        this.sequence = new BRefValueArray();
    }

    public BXMLSequence(BRefValueArray sequence) {
        this.sequence = sequence;
    }

    @Override
    public XMLNodeType getNodeType() {
        return XMLNodeType.SEQUENCE;
    }

    @Override
    public BBoolean isEmpty() {
        return new BBoolean(this.sequence.size() == 0L);
    }

    @Override
    public BBoolean isSingleton() {
        return new BBoolean(this.sequence.size() == 1L);
    }

    @Override
    public BString getItemType() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.get(0L)).getItemType();
        }
        return new BString(XMLNodeType.SEQUENCE.value());
    }

    @Override
    public BString getElementName() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.get(0L)).getElementName();
        }
        return (BString)BTypes.typeString.getZeroValue();
    }

    @Override
    public BString getTextValue() {
        StringBuilder seqTextBuilder = new StringBuilder();
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.get(i);
            seqTextBuilder.append(item.getTextValue().stringValue());
            ++i;
        }
        return new BString(seqTextBuilder.toString());
    }

    @Override
    public String getAttribute(String localName, String namespace) {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.get(0L)).getAttribute(localName, namespace);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public String getAttribute(String localName, String namespace, String prefix) {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.get(0L)).getAttribute(localName, namespace, prefix);
        }
        return BLangConstants.STRING_NULL_VALUE;
    }

    @Override
    public void setAttribute(String localName, String namespace, String prefix, String value) {
        if (this.sequence.size() == 1L) {
            ((BXMLItem)this.sequence.get(0L)).setAttribute(localName, namespace, prefix, value);
        }
    }

    @Override
    public BMap<?, ?> getAttributesMap() {
        if (this.sequence.size() == 1L) {
            return ((BXMLItem)this.sequence.get(0L)).getAttributesMap();
        }
        return (BMap)BTypes.typeMap.getEmptyValue();
    }

    @Override
    public void setAttributes(BMap<String, ?> attributes) {
        if (this.sequence.size() == 1L) {
            ((BXMLItem)this.sequence.get(0L)).setAttributes(attributes);
        }
    }

    @Override
    public BXML<?> elements() {
        BRefValueArray elementsSeq = new BRefValueArray(BTypes.typeXML);
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.get(i);
            if (item.getNodeType() == XMLNodeType.ELEMENT) {
                elementsSeq.add(j++, item);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> elements(String qname) {
        BRefValueArray elementsSeq = new BRefValueArray(BTypes.typeXML);
        String qnameStr = this.getQname(qname).toString();
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem item = (BXMLItem)this.sequence.get(i);
            if (item.getNodeType() == XMLNodeType.ELEMENT && item.getElementName().stringValue().equals(qnameStr)) {
                elementsSeq.add(j++, item);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children() {
        BRefValueArray elementsSeq = new BRefValueArray(BTypes.typeXML);
        int index = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.get(i);
            if (element.getNodeType() == XMLNodeType.ELEMENT) {
                Iterator childrenItr = ((OMElement)element.value()).getChildren();
                while (childrenItr.hasNext()) {
                    elementsSeq.add(index++, new BXMLItem((OMNode)childrenItr.next()));
                }
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> children(String qname) {
        BRefValueArray elementsSeq = new BRefValueArray();
        QName name = this.getQname(qname);
        int index = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.get(i);
            if (element.getNodeType() == XMLNodeType.ELEMENT) {
                Iterator childrenItr = ((OMElement)element.value()).getChildrenWithName(name);
                while (childrenItr.hasNext()) {
                    OMNode child = (OMNode)childrenItr.next();
                    elementsSeq.add(index++, new BXMLItem(child));
                }
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public void setChildren(BXML<?> seq) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((BXMLItem)this.sequence.get(0L)).setChildren(seq);
    }

    @Override
    public void addChildren(BXML<?> seq) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((BXMLItem)this.sequence.get(0L)).addChildren(seq);
    }

    @Override
    public BXML<?> strip() {
        BRefValueArray elementsSeq = new BRefValueArray();
        int j = 0;
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.get(i);
            if (!(element.value() == null || element.getNodeType() == XMLNodeType.TEXT && ((OMText)element.value()).getText().trim().isEmpty())) {
                elementsSeq.add(j++, element);
            }
            ++i;
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> slice(long startIndex, long endIndex) {
        if (startIndex > this.sequence.size() || endIndex > this.sequence.size() || startIndex < -1L || endIndex < -1L) {
            throw new BallerinaException("index out of range: [" + startIndex + "," + endIndex + "]");
        }
        if (startIndex == -1L) {
            startIndex = 0L;
        }
        if (endIndex == -1L) {
            endIndex = this.sequence.size();
        }
        if (startIndex == endIndex) {
            return new BXMLSequence();
        }
        if (startIndex > endIndex) {
            throw new BallerinaException("invalid indices: " + startIndex + " < " + endIndex);
        }
        int j = 0;
        BRefValueArray elementsSeq = new BRefValueArray();
        for (long i = startIndex; i < endIndex; ++i) {
            elementsSeq.add(j++, this.sequence.get(i));
        }
        return new BXMLSequence(elementsSeq);
    }

    @Override
    public BXML<?> descendants(String qname) {
        ArrayList descendants = new ArrayList();
        int i = 0;
        while ((long)i < this.sequence.size()) {
            BXMLItem element = (BXMLItem)this.sequence.get(i);
            switch (element.getNodeType()) {
                case ELEMENT: {
                    this.addDescendants(descendants, (OMElement)element.value(), this.getQname(qname).toString());
                    break;
                }
            }
            ++i;
        }
        return new BXMLSequence(new BRefValueArray(descendants.toArray(new BXML[descendants.size()]), BTypes.typeXML));
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        int i = 0;
        while ((long)i < this.sequence.size()) {
            ((BXML)this.sequence.get(i)).serializeData(outputStream);
            ++i;
        }
    }

    @Override
    public BRefValueArray value() {
        return this.sequence;
    }

    @Override
    public String stringValue() {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while ((long)i < this.sequence.size()) {
                sb.append(this.sequence.get(i).stringValue());
                ++i;
            }
            return sb.toString();
        }
        catch (Throwable t) {
            BXMLSequence.handleXmlException("failed to get xml as string: ", t);
            return BLangConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public BXMLSequence copy() {
        BRefType[] copiedVals = new BRefType[(int)this.sequence.size()];
        int i = 0;
        while ((long)i < this.sequence.size()) {
            copiedVals[i] = ((BXML)this.sequence.get(i)).copy();
            ++i;
        }
        return new BXMLSequence(new BRefValueArray(copiedVals, BTypes.typeXML));
    }

    @Override
    public BXML<?> getItem(long index) {
        return (BXML)this.sequence.get(index);
    }

    @Override
    public int length() {
        return this.sequence.size;
    }

    @Override
    public void build() {
        int i = 0;
        while ((long)i < this.sequence.size()) {
            ((BXML)this.sequence.get(i)).build();
            ++i;
        }
    }

    @Override
    public void removeAttribute(String qname) {
        if (this.sequence.size() != 1L) {
            throw new BallerinaException("not an " + (Object)((Object)XMLNodeType.ELEMENT));
        }
        ((BXMLItem)this.sequence.get(0L)).removeAttribute(qname);
    }

    @Override
    public BIterator newIterator() {
        return new BXMLSequenceIterator(this);
    }

    static class BXMLSequenceIterator
    implements BIterator {
        BXMLSequence value;
        int cursor = 0;

        BXMLSequenceIterator(BXMLSequence bxmlSequence) {
            this.value = bxmlSequence;
        }

        @Override
        public BValue[] getNext(int arity) {
            if (arity == 1) {
                return new BValue[]{this.value.sequence.get(this.cursor++)};
            }
            int cursor = this.cursor++;
            return new BValue[]{new BInteger(cursor), this.value.sequence.get(cursor)};
        }

        @Override
        public boolean hasNext() {
            return (long)this.cursor < this.value.sequence.size();
        }
    }
}

