/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.runtime.message;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.ballerinalang.runtime.message.BallerinaMessageDataSource;
import org.ballerinalang.util.exceptions.BallerinaException;

public class BlobDataSource
extends BallerinaMessageDataSource {
    private byte[] value;

    public BlobDataSource(byte[] value) {
        this.value = value;
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] value) {
        this.value = value;
    }

    @Override
    public void serializeData(OutputStream outputStream) {
        try {
            outputStream.write(this.value);
        }
        catch (IOException e) {
            throw new BallerinaException("Error occurred while writing the binary payload to the output stream", e);
        }
    }

    @Override
    public String getMessageAsString() {
        return new String(this.value, Charset.forName("UTF-8"));
    }

    @Override
    public BallerinaMessageDataSource clone() {
        return new BlobDataSource((byte[])this.value.clone());
    }

    @Override
    public Object getDataObject() {
        return this.value;
    }
}

